/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleDependenciesResolver;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleReferences;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModule;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleHeader;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgram;", "", "modules", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "(Ljava/util/List;)V", "mainModule", "getMainModule", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "getModules", "()Ljava/util/List;", "otherModules", "getOtherModules", "crossModuleDependencies", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleReferences;", "relativeRequirePath", "", "backend.js"})
public final class JsIrProgram {
    @NotNull
    private final List<JsIrModule> modules;
    @NotNull
    private final JsIrModule mainModule;
    @NotNull
    private final List<JsIrModule> otherModules;

    public JsIrProgram(@NotNull List<JsIrModule> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
        this.mainModule = (JsIrModule)CollectionsKt.last(this.modules);
        this.otherModules = CollectionsKt.dropLast(this.modules, (int)1);
    }

    @NotNull
    public final List<JsIrModule> getModules() {
        return this.modules;
    }

    @NotNull
    public final JsIrModule getMainModule() {
        return this.mainModule;
    }

    @NotNull
    public final List<JsIrModule> getOtherModules() {
        return this.otherModules;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<JsIrModule, CrossModuleReferences> crossModuleDependencies(boolean relativeRequirePath) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.modules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsIrModule jsIrModule = (JsIrModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.makeModuleHeader());
        }
        List list2 = (List)destination$iv$iv;
        CrossModuleDependenciesResolver resolver = new CrossModuleDependenciesResolver(list2);
        Map<JsIrModuleHeader, CrossModuleReferences> crossModuleReferences = resolver.resolveCrossModuleDependencies(relativeRequirePath);
        Iterable $this$associate$iv = crossModuleReferences.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            JsIrModule module2;
            Map map = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (((JsIrModuleHeader)it.getKey()).getAssociatedModule() == null) {
                throw new IllegalStateException(("Internal error: module " + ((JsIrModuleHeader)it.getKey()).getModuleName() + " is not loaded").toString());
            }
            ((CrossModuleReferences)it.getValue()).initJsImportsForModule(module2);
            Pair pair = TuplesKt.to((Object)module2, it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }
}

