/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;

public abstract class AbstractJavaCompileSpecFactory<T extends JavaCompileSpec>
implements Factory<T> {
    private final CompileOptions compileOptions;
    private final JavaInstallationMetadata toolchain;

    public AbstractJavaCompileSpecFactory(CompileOptions compileOptions, @Nullable JavaInstallationMetadata toolchain) {
        this.compileOptions = compileOptions;
        this.toolchain = toolchain;
    }

    public AbstractJavaCompileSpecFactory(CompileOptions compileOptions) {
        this(compileOptions, null);
    }

    public T create() {
        if (this.toolchain != null) {
            return this.chooseSpecForToolchain();
        }
        if (this.compileOptions.isFork()) {
            if (this.compileOptions.getForkOptions().getExecutable() != null || this.compileOptions.getForkOptions().getJavaHome() != null) {
                return this.getCommandLineSpec();
            }
            return this.getForkingSpec();
        }
        return this.getDefaultSpec();
    }

    private T chooseSpecForToolchain() {
        if (!this.toolchain.getLanguageVersion().canCompileOrRun(8)) {
            return this.getCommandLineSpec();
        }
        if (this.compileOptions.isFork()) {
            return this.getForkingSpec();
        }
        if (this.isCurrentVmOurToolchain()) {
            return this.getDefaultSpec();
        }
        return this.getForkingSpec();
    }

    boolean isCurrentVmOurToolchain() {
        return this.toolchain.getInstallationPath().getAsFile().equals(Jvm.current().getJavaHome());
    }

    protected abstract T getCommandLineSpec();

    protected abstract T getForkingSpec();

    protected abstract T getDefaultSpec();
}

