/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.signer.DefaultSignerAsyncClient;
import software.amazon.awssdk.services.signer.DefaultSignerBaseClientBuilder;
import software.amazon.awssdk.services.signer.SignerAsyncClient;
import software.amazon.awssdk.services.signer.SignerAsyncClientBuilder;
import software.amazon.awssdk.services.signer.SignerServiceClientConfiguration;
import software.amazon.awssdk.services.signer.endpoints.SignerEndpointProvider;

@SdkInternalApi
final class DefaultSignerAsyncClientBuilder
extends DefaultSignerBaseClientBuilder<SignerAsyncClientBuilder, SignerAsyncClient>
implements SignerAsyncClientBuilder {
    DefaultSignerAsyncClientBuilder() {
    }

    @Override
    public DefaultSignerAsyncClientBuilder endpointProvider(SignerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SignerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSignerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SignerServiceClientConfiguration serviceClientConfiguration = SignerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSignerAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

