/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintSeverity;

public class LinterTableWithNoRemarks
extends BaseLinter {
    public LinterTableWithNoRemarks() {
        this.setSeverity(LintSeverity.low);
    }

    @Override
    public String getSummary() {
        return "should have remarks";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        ArrayList<String> columnsWithNoRemarks;
        Objects.requireNonNull(table, "No table provided");
        if (!table.hasRemarks()) {
            this.addTableLint(table, this.getSummary());
        }
        if (!(columnsWithNoRemarks = this.findColumnsWithNoRemarks(this.getColumns(table))).isEmpty()) {
            this.addTableLint(table, this.getSummary(), columnsWithNoRemarks);
        }
    }

    private ArrayList<String> findColumnsWithNoRemarks(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column column : columns) {
            if (column.hasRemarks()) continue;
            names.add(column.getName());
        }
        return names;
    }
}

