/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintSeverity;

public class LinterTableWithNoSurrogatePrimaryKey
extends BaseLinter {
    public LinterTableWithNoSurrogatePrimaryKey() {
        this.setSeverity(LintSeverity.high);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "primary key may not be a surrogate";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        if (this.hasNoSurrogatePrimaryKey(table)) {
            this.addTableLint(table, this.getSummary());
        }
    }

    private boolean hasNoSurrogatePrimaryKey(Table table) {
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null) {
            int pkColumnCount = primaryKey.getConstrainedColumns().size();
            return pkColumnCount > 1;
        }
        return true;
    }
}

