/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.DescribedObject;
import us.fatehi.utility.Utility;

abstract class AbstractNamedObjectWithAttributes
extends AbstractNamedObject
implements AttributedObject,
DescribedObject {
    private static final String REMARKS_ATTRIBUTE = "REMARKS";
    private static final long serialVersionUID = -1486322887991472729L;
    private final Map<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();

    AbstractNamedObjectWithAttributes(String name) {
        super(name);
    }

    @Override
    public final <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public final <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return (T)this.attributeMap.getOrDefault(name, defaultValue);
    }

    @Override
    public final Map<String, Object> getAttributes() {
        return new TreeMap<String, Object>(this.attributeMap);
    }

    @Override
    public final String getRemarks() {
        Object remarks = this.attributeMap.get(REMARKS_ATTRIBUTE);
        if (remarks == null) {
            return "";
        }
        return String.valueOf(remarks);
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public final boolean hasRemarks() {
        return this.hasAttribute(REMARKS_ATTRIBUTE) && !Utility.isBlank(this.getRemarks());
    }

    @Override
    public final <T> Optional<T> lookupAttribute(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getAttribute(name));
    }

    @Override
    public final void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public final void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    @Override
    public final void setRemarks(String remarks) {
        this.setAttribute(REMARKS_ATTRIBUTE, Utility.trimToEmpty(remarks));
    }

    protected final void addAttributes(Map<String, Object> values) {
        if (values == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            this.attributeMap.put(key, value);
        }
    }
}

