/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.ProcessExecutor;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.FileContents;
import us.fatehi.utility.string.StringFormat;

public final class GraphvizUtility {
    private static final Logger LOGGER = Logger.getLogger(GraphvizUtility.class.getName());
    private static final String SC_GRAPHVIZ_PROC_DISABLE = "SC_GRAPHVIZ_PROC_DISABLE";

    public static boolean isGraphvizAvailable() {
        Integer exitCode;
        boolean disableGraphviz = Boolean.valueOf(PropertiesUtility.getSystemConfigurationProperty(SC_GRAPHVIZ_PROC_DISABLE, "false"));
        if (disableGraphviz) {
            LOGGER.log(Level.CONFIG, "Not creating a native process for Grahviz, since this is disabled");
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.add("-V");
        LOGGER.log(Level.FINE, new StringFormat("Checking if Graphviz is available:%n%s", ((Object)command).toString()));
        ProcessExecutor processExecutor = new ProcessExecutor();
        processExecutor.setCommandLine(command);
        try {
            exitCode = processExecutor.call();
            LOGGER.log(Level.CONFIG, new StringFormat("Graphviz stdout:%n%s", new FileContents(processExecutor.getProcessOutput())));
            LOGGER.log(Level.CONFIG, new StringFormat("Graphviz stderr:%n%s", new FileContents(processExecutor.getProcessError())));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not execute Graphviz command", e);
            LOGGER.log(Level.WARNING, new StringFormat("Graphviz stderr:%n%s", new FileContents(processExecutor.getProcessError())));
            exitCode = Integer.MIN_VALUE;
        }
        boolean successful = exitCode != null && exitCode == 0;
        LOGGER.log(Level.CONFIG, new StringFormat("Checking if diagram can be generated with Graphviz - \n is Graphviz installed? = <%s>", successful));
        return successful;
    }

    public static boolean isGraphvizJavaAvailable(DiagramOutputFormat diagramOutputFormat) {
        String className = "guru.nidi.graphviz.engine.Graphviz";
        boolean hasClass = Utility.isClassAvailable("guru.nidi.graphviz.engine.Graphviz");
        boolean supportsFormat = EnumSet.of(DiagramOutputFormat.svg, DiagramOutputFormat.png, DiagramOutputFormat.ps, DiagramOutputFormat.xdot, DiagramOutputFormat.plain).contains(diagramOutputFormat);
        LOGGER.log(Level.CONFIG, new StringFormat("Checking if diagram can be generated with the Graphviz Java library - \n can load <%s>? = <%b>, \n can generate format <%s>? = <%b>", "guru.nidi.graphviz.engine.Graphviz", hasClass, diagramOutputFormat.getDescription(), supportsFormat));
        return hasClass && supportsFormat;
    }

    private GraphvizUtility() {
    }
}

