/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.kerberos;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.auth.kerberos.SubjectProvider;
import io.trino.jdbc.$internal.guava.base.CharMatcher;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Throwables;
import io.trino.jdbc.$internal.okhttp3.Authenticator;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoHandler
implements Interceptor,
Authenticator {
    private static final String NEGOTIATE = "Negotiate";
    private static final Duration MIN_CREDENTIAL_LIFETIME = new Duration(60.0, TimeUnit.SECONDS);
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID = SpnegoHandler.createOid("1.3.6.1.5.5.2");
    private static final Oid KERBEROS_OID = SpnegoHandler.createOid("1.2.840.113554.1.2.2");
    private final String servicePrincipalPattern;
    private final String remoteServiceName;
    private final boolean useCanonicalHostname;
    private final SubjectProvider subjectProvider;
    @.GuardedBy(value="this")
    private GSSCredential clientCredential;

    public SpnegoHandler(String servicePrincipalPattern, String remoteServiceName, boolean useCanonicalHostname, SubjectProvider subjectProvider) {
        this.servicePrincipalPattern = Objects.requireNonNull(servicePrincipalPattern, "servicePrincipalPattern is null");
        this.remoteServiceName = Objects.requireNonNull(remoteServiceName, "remoteServiceName is null");
        this.useCanonicalHostname = useCanonicalHostname;
        this.subjectProvider = Objects.requireNonNull(subjectProvider, "subjectProvider is null");
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            return chain.proceed(this.authenticate(chain.request()));
        }
        catch (ClientException ignored) {
            return chain.proceed(chain.request());
        }
    }

    @Override
    public Request authenticate(.Route route, Response response) {
        if (response.request().headers("Authorization").stream().anyMatch(SpnegoHandler::isNegotiate) || response.headers("WWW-Authenticate").stream().noneMatch(SpnegoHandler::isNegotiate)) {
            return null;
        }
        return this.authenticate(response.request());
    }

    private static boolean isNegotiate(String value) {
        return Splitter.on(CharMatcher.whitespace()).split(value).iterator().next().equalsIgnoreCase(NEGOTIATE);
    }

    private Request authenticate(Request request) {
        String hostName = request.url().host();
        String principal = SpnegoHandler.makeServicePrincipal(this.servicePrincipalPattern, this.remoteServiceName, hostName, this.useCanonicalHostname);
        byte[] token = this.generateToken(principal);
        String credential = "Negotiate " + Base64.getEncoder().encodeToString(token);
        return request.newBuilder().header("Authorization", credential).build();
    }

    private byte[] generateToken(String servicePrincipal) {
        GSSContext context = null;
        try {
            GSSCredential clientCredential = this.getGssCredential();
            context = SpnegoHandler.doAs(this.subjectProvider.getSubject(), () -> {
                GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, GSSName.NT_HOSTBASED_SERVICE), SPNEGO_OID, clientCredential, Integer.MAX_VALUE);
                result.requestMutualAuth(true);
                result.requestConf(true);
                result.requestInteg(true);
                result.requestCredDeleg(true);
                return result;
            });
            byte[] token = context.initSecContext(new byte[0], 0, 0);
            if (token == null) {
                throw new LoginException("No token generated from GSS context");
            }
            byte[] byArray = token;
            return byArray;
        }
        catch (LoginException | GSSException e) {
            throw new ClientException(String.format("Kerberos error for [%s]: %s", servicePrincipal, e.getMessage()), e);
        }
        finally {
            try {
                if (context != null) {
                    context.dispose();
                }
            }
            catch (GSSException gSSException) {}
        }
    }

    private synchronized GSSCredential getGssCredential() throws LoginException, GSSException {
        if (this.clientCredential == null || (double)this.clientCredential.getRemainingLifetime() < MIN_CREDENTIAL_LIFETIME.getValue(TimeUnit.SECONDS)) {
            this.clientCredential = this.createGssCredential();
        }
        return this.clientCredential;
    }

    private GSSCredential createGssCredential() throws LoginException, GSSException {
        this.subjectProvider.refresh();
        Subject subject = this.subjectProvider.getSubject();
        Principal clientPrincipal = subject.getPrincipals().iterator().next();
        return SpnegoHandler.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
    }

    private static String makeServicePrincipal(String servicePrincipalPattern, String serviceName, String hostName, boolean useCanonicalHostname) {
        String serviceHostName = hostName;
        if (useCanonicalHostname) {
            serviceHostName = SpnegoHandler.canonicalizeServiceHostName(hostName);
        }
        return servicePrincipalPattern.replaceAll("\\$\\{SERVICE}", serviceName).replaceAll("\\$\\{HOST}", serviceHostName.toLowerCase(Locale.US));
    }

    private static String canonicalizeServiceHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            if (fullHostName.equalsIgnoreCase("localhost")) {
                throw new ClientException("Fully qualified name of localhost should not resolve to 'localhost'. System configuration error?");
            }
            return fullHostName;
        }
        catch (UnknownHostException e) {
            throw new ClientException("Failed to resolve host: " + hostName, e);
        }
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) throws GSSException {
        try {
            return (T)Subject.doAs(subject, action::get);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfInstanceOf(t, GSSException.class);
            Throwables.throwIfUnchecked(t);
            throw new RuntimeException(t);
        }
    }

    private static Oid createOid(String value) {
        try {
            return new Oid(value);
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

