/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import us.fatehi.utility.string.StringFormat;

final class CatalogModelInputStream
extends ObjectInputStream {
    private static final Logger LOGGER = Logger.getLogger(CatalogModelInputStream.class.getName());
    private final List<Pattern> acceptPatterns = Arrays.asList(Pattern.compile("schemacrawler\\.(schema(crawler)?|crawl)\\.[A-Z].*"), Pattern.compile("schemacrawler\\.[A-Z].*"), Pattern.compile("(\\[L)?java\\.(lang|util)\\..*"), Pattern.compile("java\\.(sql|math|time|net)\\..*"), Pattern.compile("\\[[BC]"));

    CatalogModelInputStream(InputStream input) throws IOException {
        super(Objects.requireNonNull(input, "No input stream provided"));
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        this.validateClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    private void validateClassName(String className) throws InvalidClassException {
        for (Pattern pattern : this.acceptPatterns) {
            if (!pattern.matcher(className).matches()) continue;
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Deserializing class <%s>", new Object[]{className}));
            return;
        }
        throw new InvalidClassException(String.format("Not deserializing class <%s>", className));
    }
}

