/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.List;
import java.util.Vector;

final class MessageLookup {
    private static final int ISC_MASK = 0x14000000;
    private static final int FAC_MASK = 0xFF0000;
    private static final int CODE_MASK = 65535;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int MAX_FACILITY = 26;
    static final int FACILITY_SIZE = 27;
    private final String[][] messages;
    private final String[][] sqlStates;

    MessageLookup(List<Vector<String>> facilityMessages, List<Vector<String>> facilityStates) {
        this.messages = MessageLookup.toLookupArray(facilityMessages);
        this.sqlStates = MessageLookup.toLookupArray(facilityStates);
    }

    String getErrorMessage(int errorCode) {
        if (MessageLookup.isInvalidErrorCode(errorCode)) {
            return null;
        }
        try {
            return this.messages[MessageLookup.getFacility(errorCode)][MessageLookup.getCode(errorCode)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    String getSqlState(int errorCode) {
        if (MessageLookup.isInvalidErrorCode(errorCode)) {
            return null;
        }
        try {
            return this.sqlStates[MessageLookup.getFacility(errorCode)][MessageLookup.getCode(errorCode)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    private static boolean isInvalidErrorCode(int errorCode) {
        return (errorCode & 0x14000000) != 0x14000000;
    }

    private static String[][] toLookupArray(List<Vector<String>> sourceData) {
        int facilitySize = sourceData.size();
        String[][] data = new String[facilitySize][];
        for (int idx = 0; idx < facilitySize; ++idx) {
            data[idx] = sourceData.get(idx).toArray(EMPTY_STRING_ARRAY);
        }
        return data;
    }

    static int getFacility(int errorCode) {
        return (errorCode & 0xFF0000) >> 16;
    }

    static int getCode(int errorCode) {
        return errorCode & 0xFFFF;
    }
}

