/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.util.SQLExceptionChainBuilder;

final class FBRowUpdater
implements FirebirdRowUpdater {
    private static final int PARAMETER_UNUSED = 0;
    private static final int PARAMETER_USED = 1;
    private static final int PARAMETER_DBKEY = 2;
    private static final byte[][] EMPTY_2D_BYTES = new byte[0][];
    private final FBConnection connection;
    private final GDSHelper gdsHelper;
    private final RowDescriptor rowDescriptor;
    private final FBField[] fields;
    private final QuoteStrategy quoteStrategy;
    private boolean inInsertRow;
    private RowValue newRow;
    private RowValue oldRow;
    private RowValue insertRow;
    private boolean[] updatedFlags;
    private String tableName;
    private final FbStatement[] statements = new FbStatement[4];
    private final FBObjectListener.ResultSetListener rsListener;
    private boolean closed;
    private boolean processing;
    private static final int UPDATE_STATEMENT_TYPE = 0;
    private static final int DELETE_STATEMENT_TYPE = 1;
    private static final int INSERT_STATEMENT_TYPE = 2;
    private static final int SELECT_STATEMENT_TYPE = 3;

    FBRowUpdater(FBConnection connection, RowDescriptor rowDescriptor, boolean cached, FBObjectListener.ResultSetListener rsListener) throws SQLException {
        this.rsListener = rsListener;
        this.connection = connection;
        this.gdsHelper = connection.getGDSHelper();
        this.rowDescriptor = rowDescriptor;
        this.fields = new FBField[rowDescriptor.getCount()];
        this.quoteStrategy = QuoteStrategy.forDialect(this.gdsHelper.getDialect());
        this.newRow = rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[rowDescriptor.getCount()];
        for (int i = 0; i < rowDescriptor.getCount(); ++i) {
            final int fieldPos = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    if (!FBRowUpdater.this.updatedFlags[fieldPos]) {
                        return FBRowUpdater.this.oldRow.getFieldData(fieldPos);
                    }
                    if (FBRowUpdater.this.inInsertRow) {
                        return FBRowUpdater.this.insertRow.getFieldData(fieldPos);
                    }
                    return FBRowUpdater.this.newRow.getFieldData(fieldPos);
                }

                @Override
                public void setFieldData(byte[] data) {
                    if (FBRowUpdater.this.inInsertRow) {
                        FBRowUpdater.this.insertRow.setFieldData(fieldPos, data);
                    } else {
                        FBRowUpdater.this.newRow.setFieldData(fieldPos, data);
                    }
                    ((FBRowUpdater)FBRowUpdater.this).updatedFlags[fieldPos] = true;
                }
            };
            this.fields[i] = FBField.createField(rowDescriptor.getFieldDescriptor(i), dataProvider, this.gdsHelper, cached);
        }
        for (FieldDescriptor fieldDescriptor : rowDescriptor) {
            if (this.tableName == null) {
                this.tableName = fieldDescriptor.getOriginalTableName();
                continue;
            }
            if (this.tableName.equals(fieldDescriptor.getOriginalTableName())) continue;
            throw new FBResultSetNotUpdatableException("Underlying result set references at least two relations: " + this.tableName + " and " + fieldDescriptor.getOriginalTableName() + ".");
        }
    }

    private void notifyExecutionStarted() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Corresponding result set is closed.");
        }
        if (this.processing) {
            return;
        }
        this.rsListener.executionStarted(this);
        this.processing = true;
    }

    private void notifyExecutionCompleted(boolean success) throws SQLException {
        if (!this.processing) {
            return;
        }
        this.rsListener.executionCompleted(this, success);
        this.processing = false;
    }

    private void deallocateStatement(FbStatement handle, SQLExceptionChainBuilder<SQLException> chain) {
        if (handle == null) {
            return;
        }
        try {
            handle.close();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        for (FbStatement statement : this.statements) {
            this.deallocateStatement(statement, chain);
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
        this.closed = true;
        if (this.processing) {
            this.notifyExecutionCompleted(true);
        }
    }

    @Override
    public void setRow(RowValue row) {
        this.oldRow = row;
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
        this.inInsertRow = false;
    }

    @Override
    public void cancelRowUpdates() {
        this.newRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
        this.inInsertRow = false;
    }

    @Override
    public FBField getField(int fieldPosition) {
        return this.fields[fieldPosition];
    }

    private int[] getParameterMask() throws SQLException {
        FBDatabaseMetaData metaData = (FBDatabaseMetaData)this.connection.getMetaData();
        try (ResultSet bestRowIdentifier = metaData.getBestRowIdentifier("", "", this.tableName, 1, true);){
            int[] result = new int[this.rowDescriptor.getCount()];
            boolean hasParams = false;
            while (bestRowIdentifier.next()) {
                String columnName = bestRowIdentifier.getString(2);
                if (columnName == null) continue;
                for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
                    if ("RDB$DB_KEY".equals(columnName) && this.rowDescriptor.getFieldDescriptor(i).isDbKey()) {
                        result[i] = 2;
                        hasParams = true;
                        continue;
                    }
                    if (!columnName.equals(this.rowDescriptor.getFieldDescriptor(i).getOriginalName())) continue;
                    result[i] = 1;
                    hasParams = true;
                }
                if (hasParams) continue;
                throw new FBResultSetNotUpdatableException("Underlying result set does not contain all columns that form 'best row identifier'.");
            }
            if (!hasParams) {
                throw new FBResultSetNotUpdatableException("No columns that can be used in WHERE clause could be found.");
            }
            int[] nArray = result;
            return nArray;
        }
    }

    private void appendWhereClause(StringBuilder sb, int[] parameterMask) {
        sb.append("WHERE ");
        boolean hasDbKey = false;
        for (int aParameterMask : parameterMask) {
            if (aParameterMask != 2) continue;
            hasDbKey = true;
            break;
        }
        if (hasDbKey) {
            sb.append("RDB$DB_KEY = ?");
            return;
        }
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (parameterMask[i] == 0) continue;
            if (!first) {
                sb.append(" AND");
            }
            sb.append("\n\t");
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), sb).append(" = ?");
            first = false;
        }
    }

    private String buildUpdateStatement(int[] parameterMask) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append("\nSET\n");
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                sb.append(',');
            }
            sb.append("\n\t");
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), sb).append(" = ?");
            first = false;
        }
        sb.append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildDeleteStatement(int[] parameterMask) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildInsertStatement() {
        StringBuilder columns = new StringBuilder();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                columns.append(',');
                params.append(',');
            }
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), columns);
            params.append('?');
            first = false;
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append(" (").append((CharSequence)columns).append(") VALUES (").append((CharSequence)params).append(')');
        return sb.toString();
    }

    private String buildSelectStatement(int[] parameterMask) {
        StringBuilder columns = new StringBuilder();
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
            if (!first) {
                columns.append(',');
            }
            if (fieldDescriptor.isDbKey()) {
                columns.append("RDB$DB_KEY");
            } else {
                this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), columns);
            }
            first = false;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append((CharSequence)columns).append('\n').append("FROM ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyRow(int statementType) throws SQLException {
        try (LockCloseable ignored = this.gdsHelper.withLock();){
            boolean success = false;
            try {
                this.notifyExecutionStarted();
                this.executeStatement(statementType, this.getStatementWithTransaction(statementType));
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private FbStatement getStatementWithTransaction(int statementType) throws SQLException {
        FbStatement stmt = this.statements[statementType];
        if (stmt == null) {
            this.statements[statementType] = this.gdsHelper.allocateStatement();
            return this.statements[statementType];
        }
        stmt.setTransaction(this.gdsHelper.getCurrentTransaction());
        return stmt;
    }

    @Override
    public void updateRow() throws SQLException {
        this.modifyRow(0);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.modifyRow(1);
    }

    @Override
    public void insertRow() throws SQLException {
        this.modifyRow(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        try (LockCloseable ignored = this.gdsHelper.withLock();){
            boolean success = false;
            try {
                this.notifyExecutionStarted();
                FbStatement selectStatement = this.getStatementWithTransaction(3);
                RowListener rowListener = new RowListener();
                selectStatement.addStatementListener(rowListener);
                try {
                    this.executeStatement(3, selectStatement);
                    selectStatement.fetchRows(10);
                    List<RowValue> rows = rowListener.getRows();
                    if (rows.size() == 0) {
                        throw new SQLException("No rows could be fetched.");
                    }
                    if (rows.size() > 1) {
                        throw new SQLException("More then one row fetched.");
                    }
                    this.setRow(rows.get(0));
                }
                finally {
                    selectStatement.removeStatementListener(rowListener);
                    selectStatement.closeCursor();
                }
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private void executeStatement(int statementType, FbStatement stmt) throws SQLException {
        String sql;
        if (this.inInsertRow && statementType != 2) {
            throw new SQLException("Only insertRow() is allowed when result set is positioned on insert row.");
        }
        if (statementType != 2 && this.oldRow == null) {
            throw new SQLException("Result set is not positioned on a row.");
        }
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!(this.fields[i] instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)this.fields[i])).flushCachedData();
        }
        int[] parameterMask = this.getParameterMask();
        switch (statementType) {
            case 0: {
                sql = this.buildUpdateStatement(parameterMask);
                break;
            }
            case 1: {
                sql = this.buildDeleteStatement(parameterMask);
                break;
            }
            case 2: {
                sql = this.buildInsertStatement();
                break;
            }
            case 3: {
                sql = this.buildSelectStatement(parameterMask);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect statement type specified.");
            }
        }
        stmt.prepare(sql);
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        if (statementType == 0) {
            for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!this.updatedFlags[i]) continue;
                params.add(this.newRow.getFieldData(i));
            }
        }
        RowValue source = statementType == 2 ? this.insertRow : this.oldRow;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (parameterMask[i] == 0 && statementType != 2 || !this.updatedFlags[i] && statementType == 2) continue;
            params.add(source.getFieldData(i));
        }
        stmt.execute(RowValue.of((byte[][])params.toArray((T[])EMPTY_2D_BYTES)));
    }

    @Override
    public RowValue getNewRow() {
        RowValue newRowCopy = this.rowDescriptor.createDefaultFieldValues();
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            RowValue source = this.updatedFlags[i] ? this.newRow : this.oldRow;
            byte[] fieldData = source.getFieldData(i);
            newRowCopy.setFieldData(i, fieldData != null ? (byte[])fieldData.clone() : null);
        }
        return newRowCopy;
    }

    @Override
    public RowValue getInsertRow() {
        return this.insertRow;
    }

    @Override
    public RowValue getOldRow() {
        return this.oldRow;
    }

    @Override
    public void moveToInsertRow() {
        this.inInsertRow = true;
        this.insertRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
    }

    @Override
    public void moveToCurrentRow() {
        this.inInsertRow = false;
        this.insertRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
    }

    private static final class RowListener
    implements StatementListener {
        private final List<RowValue> rows = new ArrayList<RowValue>();

        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        public List<RowValue> getRows() {
            return this.rows;
        }
    }
}

