/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.jaybird.fb.constants.TpbItems;
import org.firebirdsql.jaybird.props.internal.TransactionNameMapping;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public final class FBTpbMapper
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1690658870275668176L;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    private static final List<String> ISOLATION_LEVEL_NAMES = Collections.unmodifiableList(Arrays.asList("TRANSACTION_SERIALIZABLE", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_READ_COMMITTED"));
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    private Map<Integer, TransactionParameterBuffer> mapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>();
    private int defaultIsolationLevel = 2;

    public static FBTpbMapper getDefaultMapper() {
        return new FBTpbMapper();
    }

    public static String getTransactionIsolationName(int isolationLevel) {
        return TransactionNameMapping.toIsolationLevelName(isolationLevel);
    }

    public static int getTransactionIsolationLevel(String isolationName) {
        return TransactionNameMapping.toIsolationLevel(isolationName);
    }

    public FBTpbMapper() {
        TransactionParameterBufferImpl serializableTpb = new TransactionParameterBufferImpl();
        serializableTpb.addArgument(9);
        serializableTpb.addArgument(6);
        serializableTpb.addArgument(1);
        TransactionParameterBufferImpl repeatableReadTpb = new TransactionParameterBufferImpl();
        repeatableReadTpb.addArgument(9);
        repeatableReadTpb.addArgument(6);
        repeatableReadTpb.addArgument(2);
        TransactionParameterBufferImpl readCommittedTpb = new TransactionParameterBufferImpl();
        readCommittedTpb.addArgument(9);
        readCommittedTpb.addArgument(6);
        readCommittedTpb.addArgument(15);
        readCommittedTpb.addArgument(17);
        this.mapping.put(8, serializableTpb);
        this.mapping.put(4, repeatableReadTpb);
        this.mapping.put(2, readCommittedTpb);
    }

    public FBTpbMapper(Map<String, String> stringMapping) throws SQLException {
        this();
        this.processMapping(stringMapping);
    }

    private void processMapping(Map<String, String> stringMapping) throws SQLException {
        for (Map.Entry<String, String> entry : stringMapping.entrySet()) {
            int isolationLevel;
            String jdbcTxIsolation = entry.getKey();
            try {
                isolationLevel = FBTpbMapper.getTransactionIsolationLevel(jdbcTxIsolation);
            }
            catch (IllegalArgumentException ex) {
                throw new SQLException("Transaction isolation " + jdbcTxIsolation + " is not supported.");
            }
            TransactionParameterBuffer tpb = FBTpbMapper.processMapping(entry.getValue());
            this.mapping.put(isolationLevel, tpb);
        }
    }

    public FBTpbMapper(String mappingResource, ClassLoader cl) throws SQLException {
        if (mappingResource.startsWith("res:")) {
            mappingResource = mappingResource.substring(4);
        }
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingResource, Locale.getDefault(), cl);
            HashMap<String, String> mapping = new HashMap<String, String>();
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                mapping.put(key, value);
            }
            this.processMapping(mapping);
        }
        catch (MissingResourceException mrex) {
            throw new SQLException("Cannot load TPB mapping. " + mrex.getMessage(), mrex);
        }
    }

    public static void processMapping(FirebirdConnectionProperties connectionProperties, Properties info) throws SQLException {
        for (String isolationName : ISOLATION_LEVEL_NAMES) {
            String property = info.getProperty(isolationName);
            if (property == null) continue;
            connectionProperties.setTransactionParameters(FBTpbMapper.getTransactionIsolationLevel(isolationName), FBTpbMapper.processMapping(property));
        }
    }

    public static void processMapping(FirebirdConnectionProperties connectionProperties, Map<String, String> info) throws SQLException {
        for (String isolationName : ISOLATION_LEVEL_NAMES) {
            String property = info.get(isolationName);
            if (property == null) continue;
            connectionProperties.setTransactionParameters(FBTpbMapper.getTransactionIsolationLevel(isolationName), FBTpbMapper.processMapping(property));
        }
    }

    public static TransactionParameterBuffer processMapping(String mapping) throws SQLException {
        TransactionParameterBufferImpl result = new TransactionParameterBufferImpl();
        StringTokenizer st = new StringTokenizer(mapping, ",");
        while (st.hasMoreTokens()) {
            Integer value;
            String token = st.nextToken();
            Integer argValue = null;
            if (token.contains("=")) {
                String[] parts = token.split("=");
                try {
                    argValue = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException ex) {
                    throw new SQLException(parts[1] + " is not valid integer value");
                }
                token = parts[0];
            }
            if ((value = TpbMapping.getTpbParam(token)) == null) {
                throw new SQLException("Keyword " + token + " unknown. Please check your mapping.");
            }
            if (argValue == null) {
                result.addArgument(value);
                continue;
            }
            result.addArgument((int)value, argValue);
        }
        return result;
    }

    public TransactionParameterBuffer getMapping(int transactionIsolation) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                return this.mapping.get(transactionIsolation).deepCopy();
            }
            case 1: {
                return this.mapping.get(2).deepCopy();
            }
        }
        throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
    }

    public void setMapping(int transactionIsolation, TransactionParameterBuffer tpb) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                this.mapping.put(transactionIsolation, tpb.deepCopy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
            }
        }
    }

    public TransactionParameterBuffer getDefaultMapping() {
        return this.mapping.get(this.defaultIsolationLevel);
    }

    int getDefaultTransactionIsolation() {
        return this.defaultIsolationLevel;
    }

    void setDefaultTransactionIsolation(int isolationLevel) {
        this.defaultIsolationLevel = isolationLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FBTpbMapper)) {
            return false;
        }
        FBTpbMapper that = (FBTpbMapper)obj;
        boolean result = this.mapping.equals(that.mapping);
        return result &= this.defaultIsolationLevel == that.defaultIsolationLevel;
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.defaultIsolationLevel);
    }

    public Object clone() {
        try {
            FBTpbMapper clone = (FBTpbMapper)super.clone();
            ConcurrentHashMap<Integer, TransactionParameterBuffer> newMapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>();
            for (Map.Entry<Integer, TransactionParameterBuffer> entry : this.mapping.entrySet()) {
                newMapping.put(entry.getKey(), entry.getValue().deepCopy());
            }
            clone.mapping = newMapping;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure: clone not supported");
        }
    }

    private static final class TpbMapping {
        private static final String TPB_PREFIX = "isc_tpb_";
        private static final Map<String, Integer> tpbTypes;

        private TpbMapping() {
        }

        private static Integer getTpbParam(String name) {
            return tpbTypes.get(name);
        }

        static {
            Field[] fields;
            HashMap<String, Integer> tempTpbTypes = new HashMap<String, Integer>(64);
            for (Field field : fields = TpbItems.class.getFields()) {
                Integer value;
                String name = field.getName();
                if (!name.startsWith(TPB_PREFIX) || !field.getType().equals(Integer.TYPE)) continue;
                try {
                    value = field.getInt(null);
                }
                catch (IllegalAccessException iaex) {
                    continue;
                }
                tempTpbTypes.put(name.substring(TPB_PREFIX.length()), value);
                tempTpbTypes.put(name, value);
            }
            tpbTypes = Collections.unmodifiableMap(tempTpbTypes);
        }
    }
}

