/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.google.common.collect.Lists;
import com.ing.data.cassandra.jdbc.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.MetadataResultSet;
import com.ing.data.cassandra.jdbc.MetadataRow;
import com.ing.data.cassandra.jdbc.TypesMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataResultSets {
    public static final MetadataResultSets INSTANCE = new MetadataResultSets();
    static final String CQL_OPTION_COMMENT = "comment";
    static final String ASC_OR_DESC = "ASC_OR_DESC";
    static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String CARDINALITY = "CARDINALITY";
    static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    static final String COLUMN_DEFAULT = "COLUMN_DEF";
    static final String COLUMN_NAME = "COLUMN_NAME";
    static final String COLUMN_SIZE = "COLUMN_SIZE";
    static final String DATA_TYPE = "DATA_TYPE";
    static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String FILTER_CONDITION = "FILTER_CONDITION";
    static final String INDEX_NAME = "INDEX_NAME";
    static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    static final String IS_GENERATED_COLUMN = "IS_GENERATEDCOLUMN";
    static final String IS_NULLABLE = "IS_NULLABLE";
    static final String KEY_SEQ = "KEY_SEQ";
    static final String NO_VALUE = "NO";
    static final String NON_UNIQUE = "NON_UNIQUE";
    static final String NULLABLE = "NULLABLE";
    static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    static final String PAGES = "PAGES";
    static final String PRIMARY_KEY_NAME = "PK_NAME";
    static final String REF_GENERATION = "REF_GENERATION";
    static final String REMARKS = "REMARKS";
    static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    static final String SCOPE_TABLE = "SCOPE_TABLE";
    static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    static final String TABLE = "TABLE";
    static final String TABLE_CATALOG_SHORTNAME = "TABLE_CAT";
    static final String TABLE_CATALOG = "TABLE_CATALOG";
    static final String TABLE_NAME = "TABLE_NAME";
    static final String TABLE_SCHEMA = "TABLE_SCHEM";
    static final String TABLE_TYPE = "TABLE_TYPE";
    static final String TYPE = "TYPE";
    static final String TYPE_CATALOG = "TYPE_CAT";
    static final String TYPE_NAME = "TYPE_NAME";
    static final String TYPE_SCHEMA = "TYPE_SCHEM";
    static final String WILDCARD_CHAR = "%";
    private static final Logger LOG = LoggerFactory.getLogger(MetadataResultSets.class);

    private MetadataResultSets() {
    }

    public CassandraMetadataResultSet makeTableTypes(CassandraStatement statement) throws SQLException {
        ArrayList tableTypes = Lists.newArrayList();
        MetadataRow row = new MetadataRow().addEntry(TABLE_TYPE, TABLE);
        tableTypes.add(row);
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(tableTypes));
    }

    public CassandraMetadataResultSet makeCatalogs(CassandraStatement statement) throws SQLException {
        ArrayList catalog = Lists.newArrayList();
        MetadataRow row = new MetadataRow().addEntry(TABLE_CATALOG_SHORTNAME, statement.connection.getCatalog());
        catalog.add(row);
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(catalog));
    }

    public CassandraMetadataResultSet makeSchemas(CassandraStatement statement, String schemaPattern) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        Map keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (Map.Entry keyspace : keyspaces.entrySet()) {
            KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)keyspace.getValue();
            String schemaNamePattern = schemaPattern;
            if (WILDCARD_CHAR.equals(schemaPattern)) {
                schemaNamePattern = keyspaceMetadata.getName().asInternal();
            }
            if (schemaNamePattern != null && !schemaNamePattern.equals(keyspaceMetadata.getName().asInternal())) continue;
            MetadataRow row = new MetadataRow().addEntry(TABLE_SCHEMA, keyspaceMetadata.getName().asInternal()).addEntry(TABLE_CATALOG, statement.connection.getCatalog());
            schemas.add(row);
        }
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
    }

    public CassandraMetadataResultSet makeTables(CassandraStatement statement, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        Map keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (Map.Entry keyspace : keyspaces.entrySet()) {
            KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)keyspace.getValue();
            String schemaNamePattern = schemaPattern;
            if (WILDCARD_CHAR.equals(schemaPattern)) {
                schemaNamePattern = keyspaceMetadata.getName().asInternal();
            }
            if (schemaNamePattern != null && !schemaNamePattern.equals(keyspaceMetadata.getName().asInternal())) continue;
            Map tables = keyspaceMetadata.getTables();
            for (Map.Entry table : tables.entrySet()) {
                TableMetadata tableMetadata = (TableMetadata)table.getValue();
                if (!WILDCARD_CHAR.equals(tableNamePattern) && tableNamePattern != null && !tableNamePattern.equals(tableMetadata.getName().asInternal())) continue;
                MetadataRow row = new MetadataRow().addEntry(TABLE_CATALOG_SHORTNAME, statement.connection.getCatalog()).addEntry(TABLE_SCHEMA, keyspaceMetadata.getName().asInternal()).addEntry(TABLE_NAME, tableMetadata.getName().asInternal()).addEntry(TABLE_TYPE, TABLE).addEntry(REMARKS, tableMetadata.getOptions().get(CqlIdentifier.fromCql((String)CQL_OPTION_COMMENT)).toString()).addEntry(TYPE_CATALOG, null).addEntry(TYPE_SCHEMA, null).addEntry(TYPE_NAME, null).addEntry(SELF_REFERENCING_COL_NAME, null).addEntry(REF_GENERATION, null);
                schemas.add(row);
            }
        }
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
    }

    public CassandraMetadataResultSet makeColumns(CassandraStatement statement, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String originalSchemaPattern = schemaPattern;
        ArrayList schemas = Lists.newArrayList();
        Map keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (Map.Entry keyspace : keyspaces.entrySet()) {
            KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)keyspace.getValue();
            if (WILDCARD_CHAR.equals(schemaPattern)) {
                originalSchemaPattern = keyspaceMetadata.getName().asInternal();
            }
            if (originalSchemaPattern != null && !originalSchemaPattern.equals(keyspaceMetadata.getName().asInternal())) continue;
            Map tables = keyspaceMetadata.getTables();
            for (Map.Entry table : tables.entrySet()) {
                TableMetadata tableMetadata = (TableMetadata)table.getValue();
                if (!WILDCARD_CHAR.equals(tableNamePattern) && tableNamePattern != null && !tableNamePattern.equals(tableMetadata.getName().asInternal())) continue;
                Map columns = tableMetadata.getColumns();
                int columnIndex = 1;
                for (Map.Entry column : columns.entrySet()) {
                    ColumnMetadata columnMetadata = (ColumnMetadata)column.getValue();
                    if (!WILDCARD_CHAR.equals(columnNamePattern) && columnNamePattern != null && !columnNamePattern.equals(columnMetadata.getName().asInternal())) continue;
                    AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnMetadata.getType().toString());
                    int columnSize = -1;
                    if (jdbcEquivalentType != null) {
                        columnSize = jdbcEquivalentType.getPrecision(null);
                    }
                    int radix = 2;
                    if (jdbcEquivalentType != null && (jdbcEquivalentType.getJdbcType() == 3 || jdbcEquivalentType.getJdbcType() == 2)) {
                        radix = 10;
                    }
                    int jdbcType = 1111;
                    try {
                        jdbcType = TypesMap.getTypeForComparator(columnMetadata.getType().toString()).getJdbcType();
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to get JDBC type for comparator [{}]: {}", (Object)columnMetadata.getType(), (Object)e.getMessage());
                    }
                    MetadataRow row = new MetadataRow().addEntry(TABLE_CATALOG_SHORTNAME, statement.connection.getCatalog()).addEntry(TABLE_SCHEMA, keyspaceMetadata.getName().asInternal()).addEntry(TABLE_NAME, tableMetadata.getName().asInternal()).addEntry(COLUMN_NAME, columnMetadata.getName().asInternal()).addEntry(DATA_TYPE, String.valueOf(jdbcType)).addEntry(TYPE_NAME, columnMetadata.getType().toString()).addEntry(COLUMN_SIZE, String.valueOf(columnSize)).addEntry(BUFFER_LENGTH, String.valueOf(0)).addEntry(DECIMAL_DIGITS, null).addEntry(NUM_PREC_RADIX, String.valueOf(radix)).addEntry(NULLABLE, String.valueOf(0)).addEntry(REMARKS, column.toString()).addEntry(COLUMN_DEFAULT, null).addEntry(SQL_DATA_TYPE, null).addEntry(SQL_DATETIME_SUB, null).addEntry(CHAR_OCTET_LENGTH, String.valueOf(Integer.MAX_VALUE)).addEntry(ORDINAL_POSITION, String.valueOf(columnIndex)).addEntry(IS_NULLABLE, "").addEntry(SCOPE_CATALOG, null).addEntry(SCOPE_SCHEMA, null).addEntry(SCOPE_TABLE, null).addEntry(SOURCE_DATA_TYPE, null).addEntry(IS_AUTOINCREMENT, NO_VALUE).addEntry(IS_GENERATED_COLUMN, NO_VALUE);
                    schemas.add(row);
                    ++columnIndex;
                }
            }
        }
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
    }

    public CassandraMetadataResultSet makeIndexes(CassandraStatement statement, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        Map keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (Map.Entry keyspace : keyspaces.entrySet()) {
            KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)keyspace.getValue();
            if (!schema.equals(keyspaceMetadata.getName().asInternal())) continue;
            Map tables = keyspaceMetadata.getTables();
            for (Map.Entry table : tables.entrySet()) {
                TableMetadata tableMetadata = (TableMetadata)table.getValue();
                if (!tableName.equals(tableMetadata.getName().asInternal())) continue;
                for (Map.Entry index : tableMetadata.getIndexes().entrySet()) {
                    IndexMetadata indexMetadata = (IndexMetadata)index.getValue();
                    MetadataRow row = new MetadataRow().addEntry(TABLE_CATALOG_SHORTNAME, statement.connection.getCatalog()).addEntry(TABLE_SCHEMA, keyspaceMetadata.getName().asInternal()).addEntry(TABLE_NAME, tableMetadata.getName().asInternal()).addEntry(NON_UNIQUE, Boolean.TRUE.toString()).addEntry(INDEX_QUALIFIER, statement.connection.getCatalog()).addEntry(INDEX_NAME, indexMetadata.getName().asInternal()).addEntry(TYPE, String.valueOf(2)).addEntry(ORDINAL_POSITION, String.valueOf(1)).addEntry(COLUMN_NAME, indexMetadata.getTarget()).addEntry(ASC_OR_DESC, null).addEntry(CARDINALITY, String.valueOf(-1)).addEntry(PAGES, String.valueOf(-1)).addEntry(FILTER_CONDITION, null);
                    schemas.add(row);
                }
            }
        }
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
    }

    public CassandraMetadataResultSet makePrimaryKeys(CassandraStatement statement, String schema, String tableName) throws SQLException {
        ArrayList schemas = Lists.newArrayList();
        Map keyspaces = statement.connection.getClusterMetadata().getKeyspaces();
        for (Map.Entry keyspace : keyspaces.entrySet()) {
            KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)keyspace.getValue();
            if (!schema.equals(keyspaceMetadata.getName().asInternal())) continue;
            Map tables = keyspaceMetadata.getTables();
            for (Map.Entry table : tables.entrySet()) {
                TableMetadata tableMetadata = (TableMetadata)table.getValue();
                if (!tableName.equals(tableMetadata.getName().asInternal())) continue;
                int seq = 0;
                for (ColumnMetadata col : tableMetadata.getPrimaryKey()) {
                    MetadataRow row = new MetadataRow().addEntry(TABLE_CATALOG_SHORTNAME, statement.connection.getCatalog()).addEntry(TABLE_SCHEMA, keyspaceMetadata.getName().asInternal()).addEntry(TABLE_NAME, tableMetadata.getName().asInternal()).addEntry(COLUMN_NAME, col.getName().asInternal()).addEntry(KEY_SEQ, String.valueOf(seq)).addEntry(PRIMARY_KEY_NAME, null);
                    schemas.add(row);
                    ++seq;
                }
            }
        }
        return new CassandraMetadataResultSet(statement, new MetadataResultSet().setRows(schemas));
    }
}

