/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.google.common.cache.LoadingCache;
import com.ing.data.cassandra.jdbc.Utils;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.codec.BigintToBigDecimalCodec;
import com.ing.data.cassandra.jdbc.codec.DecimalToDoubleCodec;
import com.ing.data.cassandra.jdbc.codec.FloatToDoubleCodec;
import com.ing.data.cassandra.jdbc.codec.IntToLongCodec;
import com.ing.data.cassandra.jdbc.codec.LongToIntCodec;
import com.ing.data.cassandra.jdbc.codec.SmallintToIntCodec;
import com.ing.data.cassandra.jdbc.codec.TimestampToLongCodec;
import com.ing.data.cassandra.jdbc.codec.TinyintToIntCodec;
import com.ing.data.cassandra.jdbc.codec.VarintToIntCodec;
import java.io.File;
import java.net.InetSocketAddress;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionHolder {
    static final String URL_KEY = "jdbcUrl";
    private static final Logger LOG = LoggerFactory.getLogger(SessionHolder.class);
    final Session session;
    final Properties properties;
    private final LoadingCache<Map<String, String>, SessionHolder> parentCache;
    private final Map<String, String> cacheKey;
    private final AtomicInteger references = new AtomicInteger();

    SessionHolder(Map<String, String> params, LoadingCache<Map<String, String>, SessionHolder> parentCache) throws SQLException {
        this.cacheKey = params;
        this.parentCache = parentCache;
        String url = params.get(URL_KEY);
        this.properties = Utils.parseURL(url.replace("\"", "'"));
        params.keySet().stream().filter(key -> !URL_KEY.equals(key)).forEach(key -> this.properties.put(key, params.get(key)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Final Properties to Connection: {}", (Object)this.properties);
        }
        this.session = this.createSession(this.properties);
    }

    void release() {
        int newRef;
        int ref;
        while (!this.references.compareAndSet(ref, newRef = (ref = this.references.get()) == 1 ? -1 : ref - 1)) {
        }
        if (newRef == -1) {
            LOG.debug("Released last reference to {}, closing Session.", (Object)this.cacheKey.get(URL_KEY));
            this.dispose();
        } else {
            LOG.debug("Released reference to {}, new count = {}.", (Object)this.cacheKey.get(URL_KEY), (Object)newRef);
        }
    }

    boolean acquire() {
        int ref;
        do {
            if ((ref = this.references.get()) >= 0) continue;
            LOG.debug("Failed to acquire reference to {}.", (Object)this.cacheKey.get(URL_KEY));
            return false;
        } while (!this.references.compareAndSet(ref, ref + 1));
        LOG.debug("Acquired reference to {}, new count = {}.", (Object)this.cacheKey.get(URL_KEY), (Object)(ref + 1));
        return true;
    }

    private Session createSession(Properties properties) throws SQLException {
        File configurationFile = null;
        String configurationFilePath = properties.getProperty("configFile", "");
        if (StringUtils.isNotBlank((CharSequence)configurationFilePath)) {
            configurationFile = new File(configurationFilePath);
            if (configurationFile.exists()) {
                this.properties.remove("consistencyLevel");
                this.properties.remove("localDatacenter");
                this.properties.remove("user");
                this.properties.remove("password");
                this.properties.remove("enableSsl");
                this.properties.remove("sslEngineFactory");
                this.properties.remove("requestTimeout");
                LOG.info("The configuration file {} will be used and will override the parameters defined into the JDBC URL except contact points and keyspace.", (Object)configurationFilePath);
            } else {
                LOG.warn("The configuration file {} cannot be found, it will be ignored.", (Object)configurationFilePath);
            }
        }
        String hosts = properties.getProperty("serverName");
        int port = Integer.parseInt(properties.getProperty("portNumber"));
        String cloudSecureConnectBundle = properties.getProperty("secureConnectBundle");
        String keyspace = properties.getProperty("databaseName");
        String username = properties.getProperty("user", "");
        String password = properties.getProperty("password", "");
        String loadBalancingPolicy = properties.getProperty("loadBalancing", "");
        String localDatacenter = properties.getProperty("localDatacenter", "");
        String retryPolicy = properties.getProperty("retry", "");
        String reconnectPolicy = properties.getProperty("reconnection", "");
        boolean debugMode = Boolean.TRUE.toString().equals(properties.getProperty("debug", ""));
        String enableSslValue = properties.getProperty("enableSsl");
        String sslEngineFactoryClassName = properties.getProperty("sslEngineFactory", "");
        boolean sslEnabled = Boolean.TRUE.toString().equals(enableSslValue) || enableSslValue == null && StringUtils.isNotEmpty((CharSequence)sslEngineFactoryClassName);
        String requestTimeoutRawValue = properties.getProperty("requestTimeout");
        Integer requestTimeout = null;
        if (NumberUtils.isParsable((String)requestTimeoutRawValue)) {
            requestTimeout = Integer.parseInt(requestTimeoutRawValue);
        }
        CqlSessionBuilder builder = CqlSession.builder();
        ProgrammaticDriverConfigLoaderBuilder driverConfigLoaderBuilder = DriverConfigLoader.programmaticBuilder();
        driverConfigLoaderBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_KEEP_ALIVE, true);
        if (StringUtils.isNotBlank((CharSequence)cloudSecureConnectBundle)) {
            driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, cloudSecureConnectBundle);
            LOG.info("Cloud secure connect bundle used. Host(s) {} will be ignored.", (Object)hosts);
        } else {
            builder.addContactPoints((Collection)Arrays.stream(hosts.split("--")).map(host -> InetSocketAddress.createUnresolved(host, port)).collect(Collectors.toList()));
        }
        if (requestTimeout != null && requestTimeout > 0) {
            driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.of(requestTimeout.intValue(), ChronoUnit.MILLIS));
        }
        if (username.length() > 0) {
            builder.withAuthCredentials(username, password);
        }
        builder.withLocalDatacenter(localDatacenter);
        if (loadBalancingPolicy.length() > 0) {
            try {
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, loadBalancingPolicy);
            }
            catch (Exception e) {
                if (debugMode) {
                    throw new SQLNonTransientConnectionException(e);
                }
                LOG.warn("Error occurred while parsing load balancing policy: {} / Forcing to DefaultLoadBalancingPolicy...", (Object)e.getMessage());
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, DefaultLoadBalancingPolicy.class.getSimpleName());
            }
        }
        if (retryPolicy.length() > 0) {
            try {
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, retryPolicy);
            }
            catch (Exception e) {
                if (debugMode) {
                    throw new SQLNonTransientConnectionException(e);
                }
                LOG.warn("Error occurred while parsing retry policy: {} / skipping...", (Object)e.getMessage());
            }
        }
        if (reconnectPolicy.length() > 0) {
            try {
                Map parsedPolicy = Optional.ofNullable(Utils.parseReconnectionPolicy(reconnectPolicy)).orElse(new HashMap());
                driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, (String)parsedPolicy.get(DefaultDriverOption.RECONNECTION_POLICY_CLASS));
                if (parsedPolicy.containsKey(DefaultDriverOption.RECONNECTION_BASE_DELAY)) {
                    driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, (Duration)parsedPolicy.get(DefaultDriverOption.RECONNECTION_BASE_DELAY));
                }
                if (parsedPolicy.containsKey(DefaultDriverOption.RECONNECTION_MAX_DELAY)) {
                    driverConfigLoaderBuilder.withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, (Duration)parsedPolicy.get(DefaultDriverOption.RECONNECTION_MAX_DELAY));
                }
            }
            catch (Exception e) {
                if (debugMode) {
                    throw new SQLNonTransientConnectionException(e);
                }
                LOG.warn("Error occurred while parsing reconnection policy: {} / skipping...", (Object)e.getMessage());
            }
        }
        ArrayList<AbstractCodec> codecs = new ArrayList<AbstractCodec>();
        codecs.add(new TimestampToLongCodec());
        codecs.add(new LongToIntCodec());
        codecs.add(new IntToLongCodec());
        codecs.add(new BigintToBigDecimalCodec());
        codecs.add(new DecimalToDoubleCodec());
        codecs.add(new FloatToDoubleCodec());
        codecs.add(new VarintToIntCodec());
        codecs.add(new SmallintToIntCodec());
        codecs.add(new TinyintToIntCodec());
        builder.addTypeCodecs(codecs.toArray(new TypeCodec[0]));
        builder.withKeyspace(keyspace);
        builder.withConfigLoader(driverConfigLoaderBuilder.build());
        if (StringUtils.isBlank((CharSequence)cloudSecureConnectBundle)) {
            if (sslEnabled) {
                if (StringUtils.isNotEmpty((CharSequence)sslEngineFactoryClassName)) {
                    this.configureSslEngineFactory(builder, sslEngineFactoryClassName);
                } else {
                    this.configureDefaultSslEngineFactory(builder, driverConfigLoaderBuilder);
                }
            }
        } else {
            LOG.info("Cloud secure connect bundle used. SSL will always be enabled. All manual SSL configuration(s) will be ignored.");
        }
        if (configurationFile != null) {
            builder.withConfigLoader(DriverConfigLoader.fromFile((File)configurationFile));
        }
        try {
            return (Session)builder.build();
        }
        catch (DriverException e) {
            if (this.session != null) {
                this.session.close();
            }
            throw new SQLNonTransientConnectionException(e);
        }
    }

    void configureSslEngineFactory(CqlSessionBuilder builder, String sslEngineFactoryClassName) throws SQLNonTransientConnectionException {
        try {
            Class<?> sslEngineFactoryClass = Class.forName(sslEngineFactoryClassName);
            SslEngineFactory sslEngineFactory = (SslEngineFactory)sslEngineFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            builder.withSslEngineFactory(sslEngineFactory);
        }
        catch (Exception e) {
            throw new SQLNonTransientConnectionException(String.format("Unable to configure SSL: %s.", e.getMessage()), e);
        }
    }

    void configureDefaultSslEngineFactory(CqlSessionBuilder builder, ProgrammaticDriverConfigLoaderBuilder driverConfigLoaderBuilder) {
        driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PATH, System.getProperty("javax.net.ssl.trustStore"));
        driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD, System.getProperty("javax.net.ssl.trustStorePassword"));
        driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PATH, System.getProperty("javax.net.ssl.keyStore"));
        driverConfigLoaderBuilder.withString((DriverOption)DefaultDriverOption.SSL_KEYSTORE_PASSWORD, System.getProperty("javax.net.ssl.keyStorePassword"));
        DefaultDriverContext driverContext = new DefaultDriverContext(driverConfigLoaderBuilder.build(), ProgrammaticArguments.builder().build());
        builder.withSslEngineFactory((SslEngineFactory)new DefaultSslEngineFactory((DriverContext)driverContext));
    }

    private void dispose() {
        this.session.close();
        this.parentCache.invalidate(this.cacheKey);
    }
}

