/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.ByteBufferUtil;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public class VarintToIntCodec
extends AbstractCodec<Integer>
implements TypeCodec<Integer> {
    @NonNull
    public GenericType<Integer> getJavaType() {
        return GenericType.INTEGER;
    }

    @NonNull
    public DataType getCqlType() {
        return DataTypes.VARINT;
    }

    public ByteBuffer encode(Integer value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value);
    }

    public Integer decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        return ByteBufferUtil.toInt(bytes.duplicate());
    }

    @Override
    Integer parseNonNull(@NonNull String value) {
        return Integer.valueOf(value);
    }

    @Override
    String formatNonNull(@NonNull Integer value) {
        return String.valueOf(value);
    }
}

