/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Objects;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.GrepOptions;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LoadOptions;
import schemacrawler.schemacrawler.Options;
import us.fatehi.utility.ObjectToString;

public final class SchemaCrawlerOptions
implements Options {
    private final LimitOptions limitOptions;
    private final FilterOptions filterOptions;
    private final GrepOptions grepOptions;
    private final LoadOptions loadOptions;

    public SchemaCrawlerOptions(LimitOptions limitOptions, FilterOptions filterOptions, GrepOptions grepOptions, LoadOptions loadOptions) {
        this.limitOptions = Objects.requireNonNull(limitOptions, "No limit options provided");
        this.filterOptions = Objects.requireNonNull(filterOptions, "No filter options provided");
        this.grepOptions = Objects.requireNonNull(grepOptions, "No grep options provided");
        this.loadOptions = Objects.requireNonNull(loadOptions, "No load options provided");
    }

    public FilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    public GrepOptions getGrepOptions() {
        return this.grepOptions;
    }

    public LimitOptions getLimitOptions() {
        return this.limitOptions;
    }

    public LoadOptions getLoadOptions() {
        return this.loadOptions;
    }

    public String toString() {
        return ObjectToString.toString((Object)this);
    }

    public SchemaCrawlerOptions withFilterOptions(FilterOptions filterOptions) {
        if (filterOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, filterOptions, this.grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withGrepOptions(GrepOptions grepOptions) {
        if (grepOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, this.filterOptions, grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withLimitOptions(LimitOptions limitOptions) {
        if (limitOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(limitOptions, this.filterOptions, this.grepOptions, this.loadOptions);
    }

    public SchemaCrawlerOptions withLoadOptions(LoadOptions loadOptions) {
        if (loadOptions == null) {
            return this;
        }
        return new SchemaCrawlerOptions(this.limitOptions, this.filterOptions, this.grepOptions, loadOptions);
    }
}

