/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import us.fatehi.utility.graph.DirectedEdge;
import us.fatehi.utility.graph.DirectedGraph;
import us.fatehi.utility.graph.GraphException;
import us.fatehi.utility.graph.SimpleCycleDetector;
import us.fatehi.utility.graph.Vertex;

public class SimpleTopologicalSort<T extends Comparable<? super T>> {
    private final DirectedGraph<T> graph;

    public SimpleTopologicalSort(DirectedGraph<T> graph) {
        this.graph = Objects.requireNonNull(graph, "No diagram provided");
    }

    public List<T> topologicalSort() throws GraphException {
        if (this.containsCycle()) {
            throw new GraphException("Graph contains a cycle, so cannot be topologically sorted");
        }
        Set<Vertex<T>> vertices = this.graph.vertexSet();
        int collectionSize = vertices.size();
        ArrayList<DirectedEdge<T>> edges = new ArrayList<DirectedEdge<T>>(this.graph.edgeSet());
        ArrayList sortedValues = new ArrayList(collectionSize);
        while (!vertices.isEmpty()) {
            ArrayList nodesAtLevel = new ArrayList(collectionSize);
            Iterator iterator = vertices.iterator();
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                if (!this.isUnattachedNode(vertex, edges)) continue;
                nodesAtLevel.add((Comparable)vertex.getValue());
                iterator.remove();
            }
            ArrayList<Vertex> startNodes = new ArrayList<Vertex>(collectionSize);
            for (Vertex vertex : vertices) {
                if (!this.isStartNode(vertex, edges)) continue;
                startNodes.add(vertex);
            }
            for (Vertex vertex : startNodes) {
                nodesAtLevel.add((Comparable)vertex.getValue());
                this.dropOutEdges(vertex, edges);
                vertices.remove(vertex);
            }
            nodesAtLevel.sort(Comparator.naturalOrder());
            sortedValues.addAll(nodesAtLevel);
        }
        return sortedValues;
    }

    private boolean containsCycle() {
        SimpleCycleDetector<T> cycleDetector = new SimpleCycleDetector<T>(this.graph);
        return cycleDetector.containsCycle();
    }

    private void dropOutEdges(Vertex<T> vertex, Collection<DirectedEdge<T>> edges) {
        Iterator<DirectedEdge<T>> iterator = edges.iterator();
        while (iterator.hasNext()) {
            DirectedEdge<T> edge = iterator.next();
            if (!edge.isFrom(vertex)) continue;
            iterator.remove();
        }
    }

    private boolean isStartNode(Vertex<T> vertex, Collection<DirectedEdge<T>> edges) {
        for (DirectedEdge<T> edge : edges) {
            if (!edge.isTo(vertex)) continue;
            return false;
        }
        return true;
    }

    private boolean isUnattachedNode(Vertex<T> vertex, Collection<DirectedEdge<T>> edges) {
        for (DirectedEdge<T> edge : edges) {
            if (!edge.isTo(vertex) && !edge.isFrom(vertex)) continue;
            return false;
        }
        return true;
    }
}

