/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.logging.runtime;

import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;

@DisableTrace
public class Features {
    private final Map<String, Long> features = new HashMap<String, Long>();

    public Features(String name) {
        try {
            Class<?> feature = Class.forName(name).getMethod("value", new Class[0]).getReturnType();
            String canoName = feature.getCanonicalName();
            String typeName = canoName.endsWith("[]") ? canoName.substring(0, canoName.length() - 2) : canoName;
            for (Feature f2 : (Feature[])Class.forName(typeName).getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                this.features.put(f2.name(), f2.bitVector());
            }
        }
        catch (Throwable e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public long bitVector(String name) {
        Long bitMask = this.features.get(name);
        if (null == bitMask) {
            throw new IllegalArgumentException("unknown feature " + name);
        }
        return bitMask;
    }
}

