/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.TimerTask;
import java.util.logging.Logger;
import oracle.jdbc.internal.Monitor;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

public final class AsyncOutboundTimeoutHandler {
    private final AsyncOutboundTimeoutHandler loginTimeoutHandler;
    private final IOException error;
    private final Monitor monitor = Monitor.newInstance();
    private SocketChannel channel = null;
    private TimerTask timeoutTask = null;
    private boolean isExpired = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    private AsyncOutboundTimeoutHandler(AsyncOutboundTimeoutHandler loginTimeoutHandler, IOException error) {
        this.loginTimeoutHandler = loginTimeoutHandler;
        this.error = error;
    }

    final void setChannel(SocketChannel channel) throws IOException {
        if (this.loginTimeoutHandler != null) {
            this.loginTimeoutHandler.setChannel(channel);
        }
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.channel = channel;
        }
    }

    public final void scheduleTimeout(Duration duration) throws IOException {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.cancelTimeout();
            this.scheduleTimeoutTask(duration);
        }
    }

    private void scheduleTimeoutTask(Duration duration) {
        this.timeoutTask = TimeoutInterruptHandler.scheduleTask(() -> {
            try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
                if (this.channel != null) {
                    TcpMultiplexer.cancelRegistration(this.channel, this.error);
                }
                this.isExpired = true;
            }
        }, duration.toMillis());
    }

    public final boolean cancelTimeout() {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            if (this.timeoutTask != null) {
                boolean bl = this.timeoutTask.cancel();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private final void ensureUnexpired() throws IOException {
        if (this.isExpired) {
            throw this.error;
        }
    }

    public static AsyncOutboundTimeoutHandler newInstance(AsyncOutboundTimeoutHandler loginTimeoutHandler, IOException error) {
        return new AsyncOutboundTimeoutHandler(loginTimeoutHandler, error);
    }

    public static AsyncOutboundTimeoutHandler newScheduledInstance(AsyncOutboundTimeoutHandler loginTimeoutHandler, Duration duration, IOException error) {
        AsyncOutboundTimeoutHandler newHandler = new AsyncOutboundTimeoutHandler(loginTimeoutHandler, error);
        newHandler.scheduleTimeoutTask(duration);
        return newHandler;
    }

    static {
        try {
            $$$methodRef$$$8 = AsyncOutboundTimeoutHandler.class.getDeclaredConstructor(AsyncOutboundTimeoutHandler.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("lambda$scheduleTimeoutTask$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("newScheduledInstance", AsyncOutboundTimeoutHandler.class, Duration.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("newInstance", AsyncOutboundTimeoutHandler.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("ensureUnexpired", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("scheduleTimeoutTask", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("scheduleTimeout", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AsyncOutboundTimeoutHandler.class.getDeclaredMethod("setChannel", SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

