/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.ThreadLocalRandom;

public class ArrayUtils {
    public static <ElementT> void swap(@NonNull ElementT[] elements, int i, int j) {
        if (i != j) {
            ElementT tmp = elements[i];
            elements[i] = elements[j];
            elements[j] = tmp;
        }
    }

    public static <ElementT> void bubbleUp(@NonNull ElementT[] elements, int sourceIndex, int targetIndex) {
        for (int i = sourceIndex; i > targetIndex; --i) {
            ArrayUtils.swap(elements, i, i - 1);
        }
    }

    public static <ElementT> void bubbleDown(@NonNull ElementT[] elements, int sourceIndex, int targetIndex) {
        for (int i = sourceIndex; i < targetIndex; ++i) {
            ArrayUtils.swap(elements, i, i + 1);
        }
    }

    public static <ElementT> void shuffleHead(@NonNull ElementT[] elements, int n) {
        ArrayUtils.shuffleHead(elements, n, ThreadLocalRandom.current());
    }

    public static <ElementT> void shuffleHead(@NonNull ElementT[] elements, int n, @NonNull ThreadLocalRandom random) {
        if (n > elements.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Can't shuffle the first %d elements, there are only %d", n, elements.length));
        }
        if (n > 1) {
            for (int i = n - 1; i > 0; --i) {
                int j = random.nextInt(i + 1);
                ArrayUtils.swap(elements, i, j);
            }
        }
    }

    public static <ElementT> void rotate(@NonNull ElementT[] elements, int startIndex, int length, int amount) {
        if (length >= 2) {
            amount %= length;
            for (int i = 0; i < amount; ++i) {
                ArrayUtils.bubbleDown(elements, startIndex, startIndex + length - 1);
            }
        }
    }
}

