/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedWeakReference<T>
extends WeakReference<T>
implements Delayed {
    private final long origin = System.currentTimeMillis();
    private final long delay;

    public DelayedWeakReference(T referent, long delay) {
        super(referent);
        this.delay = delay;
    }

    public DelayedWeakReference(T referent, ReferenceQueue<T> q, long delay) {
        super(referent, q);
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getExpirationTime() {
        return this.origin + this.delay;
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof DelayedWeakReference) {
            long diff = this.getExpirationTime() - ((DelayedWeakReference)other).getExpirationTime();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("time unit must not be null");
        }
        return unit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }
}

