/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.util.Map;
import picocli.CommandLine;
import schemacrawler.tools.commandline.command.AvailableServers;
import schemacrawler.tools.commandline.command.ConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseServerHostConnectionOptions;

public class ServerHostConnectionGroupOptions
implements ConnectionOptions {
    @CommandLine.Option(names={"--database"}, description={"Database name"})
    private String database;
    @CommandLine.Option(names={"--server"}, required=true, description={"Where <database system identifier> is a database for which a SchemaCrawler plug-in is available", "Use one of ${COMPLETION-CANDIDATES}"}, completionCandidates=AvailableServers.class, paramLabel="<database system identifier>")
    private String databaseSystemIdentifier;
    @CommandLine.Option(names={"--host"}, description={"Database server host"})
    private String host;
    @CommandLine.Option(names={"--port"}, description={"Database server port"})
    private Integer port;
    @CommandLine.Option(names={"--urlx"}, description={"JDBC URL additional properties"})
    private Map<String, String> urlx;

    @Override
    public DatabaseConnectionOptions toDatabaseConnectionOptions() {
        return new DatabaseServerHostConnectionOptions(this.databaseSystemIdentifier, this.host, this.port, this.database, this.urlx);
    }
}

