/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.PooledCassandraConnection;
import com.ing.data.cassandra.jdbc.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class CassandraDataSource
implements ConnectionPoolDataSource,
DataSource {
    protected static final String DATA_SOURCE_DESCRIPTION = "Cassandra Data Source";
    protected String serverName;
    protected int portNumber = 9042;
    protected String databaseName;
    protected String user;
    protected String password;
    protected String version = null;
    protected String consistency = null;
    protected String localDataCenter = null;

    public CassandraDataSource(String host, int port, String keyspace, String user, String password, String version, String consistency) {
        this(host, port, keyspace, user, password, version, consistency, null);
    }

    public CassandraDataSource(String host, int port, String keyspace, String user, String password, String version, String consistency, String localDataCenter) {
        if (host != null) {
            this.setServerName(host);
        }
        if (port >= 0) {
            this.setPortNumber(port);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (consistency != null) {
            this.setConsistency(consistency);
        }
        if (localDataCenter != null) {
            this.setLocalDataCenter(localDataCenter);
        }
        this.setDatabaseName(keyspace);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getDescription() {
        return DATA_SOURCE_DESCRIPTION;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLocalDataCenter() {
        return this.localDataCenter;
    }

    public void setLocalDataCenter(String localDataCenter) {
        this.localDataCenter = localDataCenter;
    }

    @Override
    public CassandraConnection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public CassandraConnection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        this.user = user;
        this.password = password;
        if (this.serverName == null) {
            throw new SQLNonTransientConnectionException("A 'host' name is required to build a Connection.");
        }
        props.setProperty("serverName", this.serverName);
        props.setProperty("portNumber", String.valueOf(this.portNumber));
        if (this.databaseName != null) {
            props.setProperty("databaseName", this.databaseName);
        }
        if (user != null) {
            props.setProperty("user", user);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        if (this.version != null) {
            props.setProperty("cqlVersion", this.version);
        }
        if (this.consistency != null) {
            props.setProperty("consistencyLevel", this.consistency);
        }
        if (this.localDataCenter != null) {
            props.setProperty("localDatacenter", this.localDataCenter);
        }
        String url = "jdbc:cassandra:".concat(Utils.createSubName(props));
        return (CassandraConnection)DriverManager.getConnection(url, props);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLoginTimeout(int timeout) {
        DriverManager.setLoginTimeout(timeout);
    }

    @Override
    public void setLogWriter(PrintWriter writer) {
        DriverManager.setLogWriter(writer);
    }

    @Override
    public boolean isWrapperFor(@NonNull Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(@NonNull Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLFeatureNotSupportedException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public PooledCassandraConnection getPooledConnection() throws SQLException {
        return new PooledCassandraConnection(this.getConnection());
    }

    @Override
    public PooledCassandraConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledCassandraConnection(this.getConnection(user, password));
    }

    static {
        try {
            Class.forName("com.ing.data.cassandra.jdbc.CassandraDriver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

