/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.util.CanEstimateSize;

public class FieldMetadata
implements CanEstimateSize {
    final String columnName;
    final String tableName;
    final String schemaName;
    final int nullable;
    final boolean autoIncrement;
    final String catalogName;
    final boolean readOnly;
    final boolean searchable;
    final boolean caseSensitive;

    public FieldMetadata(String columnName) {
        this(columnName, "", "", 2, false);
    }

    public FieldMetadata(String columnName, String tableName, String schemaName, int nullable, boolean autoIncrement) {
        this(columnName, tableName, schemaName, nullable, autoIncrement, "", false, true, false);
    }

    public FieldMetadata(String columnName, String tableName, String schemaName, int nullable, boolean autoIncrement, String catalogName, boolean readOnly, boolean searchable, boolean caseSensitive) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.nullable = nullable;
        this.autoIncrement = autoIncrement;
        this.catalogName = catalogName;
        this.readOnly = readOnly;
        this.searchable = searchable;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public long getSize() {
        return (long)(this.columnName.length() * 2 + this.tableName.length() * 2 + this.schemaName.length() * 2) + 4L + 1L + (long)(this.catalogName.length() * 2) + 1L + 1L;
    }

    public String toString() {
        return "FieldMetadata{columnName='" + this.columnName + '\'' + ", tableName='" + this.tableName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", nullable=" + this.nullable + ", autoIncrement=" + this.autoIncrement + ", catalogName='" + this.catalogName + '\'' + ", readOnly=" + this.readOnly + ", searchable=" + this.searchable + ", caseSensitive=" + this.caseSensitive + '}';
    }

    public static class Key {
        final int tableOid;
        final int positionInTable;

        Key(int tableOid, int positionInTable) {
            this.positionInTable = positionInTable;
            this.tableOid = tableOid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.tableOid != key.tableOid) {
                return false;
            }
            return this.positionInTable == key.positionInTable;
        }

        public int hashCode() {
            int result = this.tableOid;
            result = 31 * result + this.positionInTable;
            return result;
        }

        public String toString() {
            return "Key{tableOid=" + this.tableOid + ", positionInTable=" + this.positionInTable + '}';
        }
    }
}

