/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public class IfxTmpFile {
    private final File tempFile;
    private int refCount = 0;
    private final IfxConnection conn;

    IfxTmpFile(IfxConnection conn) throws SQLException {
        this.conn = conn;
        try {
            String tmpDirName = conn.getJDBCTempDir();
            if (tmpDirName == null || tmpDirName.length() == 0) {
                tmpDirName = System.getProperty("user.dir");
            }
            final File tmpDir = new File(tmpDirName);
            this.tempFile = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return File.createTempFile("IfxTmpFile_", "", tmpDir);
                }
            });
            ((IfxSqliConnect)conn).addToFileList(this.tempFile);
        }
        catch (Exception e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString());
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
    }

    protected String getFileName() {
        return this.tempFile.getPath();
    }

    protected synchronized int incRefCount() {
        return this.refCount++;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            try {
                ((IfxSqliConnect)this.conn).removeFromFileList(this.tempFile);
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        Files.delete(IfxTmpFile.this.tempFile.toPath());
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }

    int length() throws PrivilegedActionException {
        final File tempFileDo = this.tempFile;
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws IOException {
                return (int)tempFileDo.length();
            }
        });
    }

    InputStream getInputStream() throws PrivilegedActionException {
        final IfxTmpFile thisDo = this;
        return AccessController.doPrivileged(new PrivilegedExceptionAction<IfxInputStream>(){

            @Override
            public IfxInputStream run() throws IOException {
                IfxInputStream tmpStreamDo = new IfxInputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
    }

    IfxOutputStream getOutputStream() throws PrivilegedActionException {
        final IfxTmpFile thisDo = this;
        return AccessController.doPrivileged(new PrivilegedExceptionAction<IfxOutputStream>(){

            @Override
            public IfxOutputStream run() throws IOException {
                IfxOutputStream tmpStreamDo = new IfxOutputStream(thisDo);
                IfxTmpFile.this.incRefCount();
                return tmpStreamDo;
            }
        });
    }
}

