/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal;

import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PDQDB2Types {
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int DISTINCT = 2001;
    public static final int ARRAY = 2003;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int CURSOR = -100008;
    public static final int ROW = -100009;
    public static final int XML = 2009;
    public static final int ROWID = -8;
    public static final int ASCIISTREAM = 1000;
    public static final int BINARYSTREAM = 1001;
    public static final int CHARACTERSTREAM = 1002;
    public static final int ROW_IDENTIFIER = -8;
    public static final int DATALINK = 70;
    public static final int DBCLOB = 502;
    public static final int GRAPHIC = 503;
    public static final int VARGRAPHIC = 504;
    public static final int LONGVARGRAPHIC = 505;
    public static final int CHAR_FOR_BIT_DATA = -4524532;
    public static final int VARCHAR_FOR_BIT_DATA = -4484493;
    public static final int LONG_VARCHAR_FOR_BIT_DATA = -4564574;
    public static final int TIMESTAMPTZ = -100010;
    public static final int BLOB_LOCATOR = 506;
    public static final int CLOB_LOCATOR = 507;
    public static final int DBCLOB_LOCATOR = 508;
    public static final int DECFLOAT = -100001;
    public static final int DB2_SQLTYPE_DATE = 384;
    public static final int DB2_SQLTYPE_NDATE = 385;
    public static final int DB2_SQLTYPE_TIME = 388;
    public static final int DB2_SQLTYPE_NTIME = 389;
    public static final int DB2_SQLTYPE_TIMESTAMP = 392;
    public static final int DB2_SQLTYPE_NTIMESTAMP = 393;
    public static final int DB2_SQLTYPE_TIMESTAMPTZ = 2448;
    public static final int DB2_SQLTYPE_NTIMESTAMPTZ = 2449;
    public static final int DB2_SQLTYPE_DATALINK = 396;
    public static final int DB2_SQLTYPE_NDATALINK = 397;
    public static final int DB2_SQLTYPE_BLOB = 404;
    public static final int DB2_SQLTYPE_NBLOB = 405;
    public static final int DB2_SQLTYPE_CLOB = 408;
    public static final int DB2_SQLTYPE_NCLOB = 409;
    public static final int DB2_SQLTYPE_DBCLOB = 412;
    public static final int DB2_SQLTYPE_NDBCLOB = 413;
    public static final int DB2_SQLTYPE_VARCHAR = 448;
    public static final int DB2_SQLTYPE_NVARCHAR = 449;
    public static final int DB2_SQLTYPE_CHAR = 452;
    public static final int DB2_SQLTYPE_NCHAR = 453;
    public static final int DB2_SQLTYPE_LONG = 456;
    public static final int DB2_SQLTYPE_NLONG = 457;
    public static final int DB2_SQLTYPE_CSTR = 460;
    public static final int DB2_SQLTYPE_NCSTR = 461;
    public static final int DB2_SQLTYPE_VARGRAPH = 464;
    public static final int DB2_SQLTYPE_NVARGRAPH = 465;
    public static final int DB2_SQLTYPE_GRAPHIC = 468;
    public static final int DB2_SQLTYPE_NGRAPHIC = 469;
    public static final int DB2_SQLTYPE_LONGRAPH = 472;
    public static final int DB2_SQLTYPE_NLONGRAPH = 473;
    public static final int DB2_SQLTYPE_LSTR = 476;
    public static final int DB2_SQLTYPE_NLSTR = 477;
    public static final int DB2_SQLTYPE_FLOAT = 480;
    public static final int DB2_SQLTYPE_NFLOAT = 481;
    public static final int DB2_SQLTYPE_DECIMAL = 484;
    public static final int DB2_SQLTYPE_NDECIMAL = 485;
    public static final int DB2_SQLTYPE_ZONED = 488;
    public static final int DB2_SQLTYPE_NZONED = 489;
    public static final int DB2_SQLTYPE_BIGINT = 492;
    public static final int DB2_SQLTYPE_NBIGINT = 493;
    public static final int DB2_SQLTYPE_INTEGER = 496;
    public static final int DB2_SQLTYPE_NINTEGER = 497;
    public static final int DB2_SQLTYPE_SMALL = 500;
    public static final int DB2_SQLTYPE_NSMALL = 501;
    public static final int DB2_SQLTYPE_NUMERIC = 504;
    public static final int DB2_SQLTYPE_NNUMERIC = 505;
    public static final int DB2_SQLTYPE_ROWID = 904;
    public static final int DB2_SQLTYPE_NROWID = 905;
    public static final int DB2_SQLTYPE_VARBINARY = 908;
    public static final int DB2_SQLTYPE_NVARBINARY = 909;
    public static final int DB2_SQLTYPE_BINARY = 912;
    public static final int DB2_SQLTYPE_NBINARY = 913;
    public static final int DB2_SQLTYPE_BLOB_LOCATOR = 960;
    public static final int DB2_SQLTYPE_NBLOB_LOCATOR = 961;
    public static final int DB2_SQLTYPE_CLOB_LOCATOR = 964;
    public static final int DB2_SQLTYPE_NCLOB_LOCATOR = 965;
    public static final int DB2_SQLTYPE_DBCLOB_LOCATOR = 968;
    public static final int DB2_SQLTYPE_NDBCLOB_LOCATOR = 969;
    public static final int DB2_SQLTYPE_RESULTSET_LOCATOR = 972;
    public static final int DB2_SQLTYPE_NRESULTSET_LOCATOR = 973;
    public static final int DB2_SQLTYPE_XML = 988;
    public static final int DB2_SQLTYPE_NXML = 989;
    public static final int DB2_SQLTYPE_DECIMAL_FLOAT = 996;
    public static final int DB2_SQLTYPE_NDECIMAL_FLOAT = 997;
    public static final int DB2_SQLTYPE_CURSOR = 2444;
    public static final int DB2_SQLTYPE_NCURSOR = 2445;
    public static final int DB2_SQLTYPE_ROW = 2440;
    public static final int DB2_SQLTYPE_NROW = 2441;
    static HashMap<Integer, String> driverTypeToSqlTypeNameMap;
    public static HashMap<String, Integer> sqlTypeNameToDriverTypeMap;

    private PDQDB2Types() {
    }

    private static void initializeDriverTypeToSqlTypeNameMap() {
        driverTypeToSqlTypeNameMap = new HashMap();
        driverTypeToSqlTypeNameMap.put(5, "SMALLINT");
        driverTypeToSqlTypeNameMap.put(4, "INTEGER");
        driverTypeToSqlTypeNameMap.put(-5, "BIGINT");
        driverTypeToSqlTypeNameMap.put(7, "REAL");
        driverTypeToSqlTypeNameMap.put(8, "DOUBLE");
        driverTypeToSqlTypeNameMap.put(3, "DECIMAL");
        driverTypeToSqlTypeNameMap.put(-100001, "DECFLOAT");
        driverTypeToSqlTypeNameMap.put(1, "CHAR");
        driverTypeToSqlTypeNameMap.put(12, "VARCHAR");
        driverTypeToSqlTypeNameMap.put(-1, "LONG VARCHAR");
        driverTypeToSqlTypeNameMap.put(503, "GRAPHIC");
        driverTypeToSqlTypeNameMap.put(504, "VARGRAPHIC");
        driverTypeToSqlTypeNameMap.put(505, "LONG VARGRAPHIC");
        driverTypeToSqlTypeNameMap.put(-2, "BINARY");
        driverTypeToSqlTypeNameMap.put(-3, "VARBINARY");
        driverTypeToSqlTypeNameMap.put(-4, "LONG VARBINARY");
        driverTypeToSqlTypeNameMap.put(2005, "CLOB");
        driverTypeToSqlTypeNameMap.put(502, "DBCLOB");
        driverTypeToSqlTypeNameMap.put(2004, "BLOB");
        driverTypeToSqlTypeNameMap.put(91, "DATE");
        driverTypeToSqlTypeNameMap.put(92, "TIME");
        driverTypeToSqlTypeNameMap.put(93, "TIMESTAMP");
        driverTypeToSqlTypeNameMap.put(-100010, "TIMESTAMP WITH TIME ZONE");
        driverTypeToSqlTypeNameMap.put(507, "CLOB");
        driverTypeToSqlTypeNameMap.put(508, "DBCLOB");
        driverTypeToSqlTypeNameMap.put(506, "BLOB");
        driverTypeToSqlTypeNameMap.put(2009, "XML");
    }

    private static void initializeSqlTypeNameToDriverTypeMap() {
        sqlTypeNameToDriverTypeMap = new HashMap();
        sqlTypeNameToDriverTypeMap.put("SMALLINT", 5);
        sqlTypeNameToDriverTypeMap.put("INTEGER", 4);
        sqlTypeNameToDriverTypeMap.put("BIGINT", -5);
        sqlTypeNameToDriverTypeMap.put("REAL", 7);
        sqlTypeNameToDriverTypeMap.put("DOUBLE", 8);
        sqlTypeNameToDriverTypeMap.put("DECIMAL", 3);
        sqlTypeNameToDriverTypeMap.put("DECFLOAT", -100001);
        sqlTypeNameToDriverTypeMap.put("CHAR", 1);
        sqlTypeNameToDriverTypeMap.put("VARCHAR", 12);
        sqlTypeNameToDriverTypeMap.put("LONG VARCHAR", -1);
        sqlTypeNameToDriverTypeMap.put("GRAPHIC", 503);
        sqlTypeNameToDriverTypeMap.put("VARGRAPHIC", 504);
        sqlTypeNameToDriverTypeMap.put("LONG VARGRAPHIC", 505);
        sqlTypeNameToDriverTypeMap.put("BINARY", -2);
        sqlTypeNameToDriverTypeMap.put("VARBINARY", -3);
        sqlTypeNameToDriverTypeMap.put("LONG VARBINARY", -4);
        sqlTypeNameToDriverTypeMap.put("CLOB", 2005);
        sqlTypeNameToDriverTypeMap.put("DBCLOB", 502);
        sqlTypeNameToDriverTypeMap.put("BLOB", 2004);
        sqlTypeNameToDriverTypeMap.put("DATE", 91);
        sqlTypeNameToDriverTypeMap.put("TIME", 92);
        sqlTypeNameToDriverTypeMap.put("TIMESTAMP", 93);
        sqlTypeNameToDriverTypeMap.put("TIMESTAMP WITH TIME ZONE", -100010);
        sqlTypeNameToDriverTypeMap.put("CHAR FOR BIT DATA", -2);
        sqlTypeNameToDriverTypeMap.put("VARCHAR FOR BIT DATA", -3);
        sqlTypeNameToDriverTypeMap.put("LONG VARCHAR FOR BIT DATA", -4);
        sqlTypeNameToDriverTypeMap.put("XML", 2009);
        sqlTypeNameToDriverTypeMap.put("ROWID", -8);
        sqlTypeNameToDriverTypeMap.put("CLOB LOCATOR", 507);
        sqlTypeNameToDriverTypeMap.put("DBCLOB LOCATOR", 508);
        sqlTypeNameToDriverTypeMap.put("BLOB LOCATOR", 506);
    }

    public static int mapSqlTypeNameToDriverType(String string) {
        return sqlTypeNameToDriverTypeMap.get(string);
    }

    public static void mapDriverTypeToDB2TypeInfo(Object object, int n2, int n3, boolean bl2, int n4, int n5) {
        SQLJColumnMetaData sQLJColumnMetaData = (SQLJColumnMetaData)object;
        sQLJColumnMetaData.sqlTypes[n3] = 0;
        sQLJColumnMetaData.sqlLengths[n3] = n5;
        sQLJColumnMetaData.sqlScales[n3] = 0;
        sQLJColumnMetaData.sqlPrecisions[n3] = 0;
        switch (n2) {
            case 5: {
                sQLJColumnMetaData.sqlTypes[n3] = 501;
                sQLJColumnMetaData.sqlLengths[n3] = 2L;
                break;
            }
            case 4: {
                sQLJColumnMetaData.sqlTypes[n3] = 497;
                sQLJColumnMetaData.sqlLengths[n3] = 4L;
                break;
            }
            case -5: {
                sQLJColumnMetaData.sqlTypes[n3] = 493;
                sQLJColumnMetaData.sqlLengths[n3] = 8L;
                break;
            }
            case 7: {
                sQLJColumnMetaData.sqlTypes[n3] = 481;
                sQLJColumnMetaData.sqlLengths[n3] = 4L;
                break;
            }
            case 8: {
                sQLJColumnMetaData.sqlTypes[n3] = 481;
                sQLJColumnMetaData.sqlLengths[n3] = 8L;
                break;
            }
            case 3: {
                sQLJColumnMetaData.sqlTypes[n3] = 485;
                sQLJColumnMetaData.sqlLengths[n3] = 0L;
                sQLJColumnMetaData.sqlScales[n3] = n4;
                sQLJColumnMetaData.sqlPrecisions[n3] = n5;
                break;
            }
            case 2: {
                sQLJColumnMetaData.sqlTypes[n3] = 485;
                sQLJColumnMetaData.sqlLengths[n3] = 0L;
                sQLJColumnMetaData.sqlScales[n3] = n4;
                sQLJColumnMetaData.sqlPrecisions[n3] = n5;
                break;
            }
            case -100001: {
                sQLJColumnMetaData.sqlTypes[n3] = 997;
                sQLJColumnMetaData.sqlPrecisions[n3] = n5;
                if (sQLJColumnMetaData.sqlPrecisions[n3] == 16) {
                    sQLJColumnMetaData.sqlLengths[n3] = 8L;
                    break;
                }
                if (sQLJColumnMetaData.sqlPrecisions[n3] != 34) break;
                sQLJColumnMetaData.sqlLengths[n3] = 16L;
                break;
            }
            case 1: {
                sQLJColumnMetaData.sqlTypes[n3] = 453;
                break;
            }
            case 12: {
                sQLJColumnMetaData.sqlTypes[n3] = 449;
                break;
            }
            case -1: {
                sQLJColumnMetaData.sqlTypes[n3] = 457;
                break;
            }
            case 503: {
                sQLJColumnMetaData.sqlTypes[n3] = 465;
                break;
            }
            case 504: {
                sQLJColumnMetaData.sqlTypes[n3] = 465;
                break;
            }
            case 505: {
                sQLJColumnMetaData.sqlTypes[n3] = 473;
                break;
            }
            case -2: {
                if (!bl2) {
                    sQLJColumnMetaData.sqlTypes[n3] = 453;
                    sQLJColumnMetaData.sqlCcsids[n3] = -1;
                    break;
                }
                sQLJColumnMetaData.sqlTypes[n3] = 913;
                break;
            }
            case -3: {
                if (!bl2) {
                    sQLJColumnMetaData.sqlTypes[n3] = 449;
                    sQLJColumnMetaData.sqlCcsids[n3] = -1;
                    break;
                }
                sQLJColumnMetaData.sqlTypes[n3] = 909;
                break;
            }
            case -4524532: {
                sQLJColumnMetaData.sqlTypes[n3] = 453;
                sQLJColumnMetaData.sqlCcsids[n3] = -1;
                break;
            }
            case -4484493: {
                sQLJColumnMetaData.sqlTypes[n3] = 449;
                sQLJColumnMetaData.sqlCcsids[n3] = -1;
                break;
            }
            case -4564574: {
                sQLJColumnMetaData.sqlTypes[n3] = 457;
                sQLJColumnMetaData.sqlCcsids[n3] = -1;
                break;
            }
            case -4: {
                if (!bl2) {
                    sQLJColumnMetaData.sqlTypes[n3] = 449;
                    sQLJColumnMetaData.sqlCcsids[n3] = -1;
                    break;
                }
                sQLJColumnMetaData.sqlTypes[n3] = 909;
                break;
            }
            case 2005: {
                sQLJColumnMetaData.sqlTypes[n3] = 409;
                break;
            }
            case 502: {
                sQLJColumnMetaData.sqlTypes[n3] = 413;
                break;
            }
            case 2004: {
                sQLJColumnMetaData.sqlTypes[n3] = 405;
                break;
            }
            case 91: {
                sQLJColumnMetaData.sqlTypes[n3] = 385;
                sQLJColumnMetaData.sqlLengths[n3] = 10L;
                break;
            }
            case 92: {
                sQLJColumnMetaData.sqlTypes[n3] = 389;
                sQLJColumnMetaData.sqlLengths[n3] = 8L;
                break;
            }
            case 93: {
                sQLJColumnMetaData.sqlTypes[n3] = 393;
                sQLJColumnMetaData.sqlLengths[n3] = n5;
                break;
            }
            case -100010: {
                sQLJColumnMetaData.sqlTypes[n3] = 2449;
                sQLJColumnMetaData.sqlLengths[n3] = StaticProfileCaptureHelper.correctDateTimeLength(2449, n5);
                sQLJColumnMetaData.sqlScales[n3] = n4;
                sQLJColumnMetaData.sqlPrecisions[n3] = n5;
                break;
            }
            case 2009: {
                sQLJColumnMetaData.sqlTypes[n3] = 989;
                sQLJColumnMetaData.sqlLengths[n3] = 0L;
                break;
            }
            case -8: {
                sQLJColumnMetaData.sqlTypes[n3] = 905;
                break;
            }
            case 507: {
                sQLJColumnMetaData.sqlTypes[n3] = 965;
                break;
            }
            case 508: {
                sQLJColumnMetaData.sqlTypes[n3] = 969;
                break;
            }
            case 506: {
                sQLJColumnMetaData.sqlTypes[n3] = 961;
                break;
            }
            default: {
                sQLJColumnMetaData.sqlTypes[n3] = 0;
            }
        }
    }

    public static String mapDriverTypeToSqlTypeName(int n2) {
        return driverTypeToSqlTypeNameMap.get(n2);
    }

    private static boolean isSqlDataTypeLob(int n2) {
        switch (n2) {
            case 404: 
            case 405: 
            case 408: 
            case 409: 
            case 412: 
            case 413: 
            case 502: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private static boolean isSqlDataTypeXml(int n2) {
        switch (n2) {
            case 988: 
            case 989: 
            case 2009: {
                return true;
            }
        }
        return false;
    }

    public static boolean doColumnsContainLobOrXml(ArrayList<Element> arrayList) {
        if (null != arrayList) {
            for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                String string;
                int n2;
                Node node = arrayList.get(i10);
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = namedNodeMap.getNamedItem("jdbcType");
                Node node3 = namedNodeMap.getNamedItem("db2type");
                if (null != node2 && (PDQDB2Types.isSqlDataTypeLob(n2 = XmlTags.getDB2TypeNumber(string = node2.getTextContent())) || PDQDB2Types.isSqlDataTypeXml(n2))) {
                    return true;
                }
                if (null == node3 || !PDQDB2Types.isSqlDataTypeLob(n2 = XmlTags.getDB2TypeNumber(string = node3.getTextContent())) && !PDQDB2Types.isSqlDataTypeXml(n2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doColumnsContainLobOrXml(int[] nArray) {
        if (null != nArray) {
            for (int n2 : nArray) {
                if (!PDQDB2Types.isSqlDataTypeLob(n2) && !PDQDB2Types.isSqlDataTypeXml(n2)) continue;
                return true;
            }
        }
        return false;
    }

    public static int mapDB2DataTypeToJDBCType(boolean bl2, int n2, long l10, int n3) {
        switch (n2 & 0xFFFFFFFE) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (l10 == 16L) {
                    return 3;
                }
                if (l10 == 8L) {
                    return 8;
                }
                if (l10 == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 488: 
            case 504: {
                return 3;
            }
            case 996: {
                return -100001;
            }
            case 452: {
                if (bl2 && (n3 == 65535 || n3 == 0)) {
                    return -2;
                }
                return 1;
            }
            case 460: {
                return 1;
            }
            case 468: {
                return 503;
            }
            case 464: {
                return 504;
            }
            case 448: {
                if (bl2 && (n3 == 65535 || n3 == 0)) {
                    return -3;
                }
                return 12;
            }
            case 908: {
                return -3;
            }
            case 912: {
                return -2;
            }
            case 476: {
                return 12;
            }
            case 472: {
                return 505;
            }
            case 456: {
                if (bl2 && (n3 == 65535 || n3 == 0)) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 2448: {
                return -100010;
            }
            case 408: 
            case 964: {
                return 2005;
            }
            case 412: 
            case 968: {
                return 502;
            }
            case 404: 
            case 960: {
                return 2004;
            }
            case 904: {
                return -8;
            }
            case 396: {
                return 70;
            }
            case 988: {
                return 2009;
            }
            case 2444: {
                return -100008;
            }
            case 2440: {
                return -100009;
            }
        }
        return 0;
    }

    static {
        PDQDB2Types.initializeDriverTypeToSqlTypeNameMap();
        PDQDB2Types.initializeSqlTypeNameToDriverTypeMap();
    }
}

