/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;

public abstract class AbstractProtocolDescriptor
implements ProtocolDescriptor {
    private final int version;
    private final int architecture;
    private final int minimumType;
    private final int maximumType;
    private final boolean supportsWireCompression;
    private final int weight;
    private final int hashCode;

    protected AbstractProtocolDescriptor(int version, int architecture, int minimumType, int maximumType, boolean supportsWireCompression, int weight) {
        this.version = version;
        this.architecture = architecture;
        this.minimumType = minimumType;
        this.maximumType = maximumType;
        this.weight = weight;
        this.supportsWireCompression = supportsWireCompression;
        this.hashCode = Objects.hash(version, architecture, minimumType, maximumType, weight);
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final int getArchitecture() {
        return this.architecture;
    }

    @Override
    public final int getMinimumType() {
        return this.minimumType;
    }

    @Override
    public final int getMaximumType() {
        return this.maximumType;
    }

    @Override
    public final boolean supportsWireCompression() {
        return this.supportsWireCompression;
    }

    @Override
    public final int getWeight() {
        return this.weight;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass();
    }

    @Override
    public final DatabaseParameterBuffer createDatabaseParameterBuffer(WireDatabaseConnection connection) throws SQLException {
        return this.getParameterConverter().toDatabaseParameterBuffer(connection);
    }

    @Override
    public final ServiceParameterBuffer createAttachServiceParameterBuffer(WireServiceConnection connection) throws SQLException {
        return this.getParameterConverter().toServiceParameterBuffer(connection);
    }

    protected abstract ParameterConverter<WireDatabaseConnection, WireServiceConnection> getParameterConverter();
}

