/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.Arrays;
import java.util.Objects;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

class CryptSessionConfigImpl
implements CryptSessionConfig {
    private final EncryptionIdentifier encryptionIdentifier;
    private byte[] encryptKey;
    private byte[] decryptKey;
    private byte[] specificData;

    CryptSessionConfigImpl(EncryptionIdentifier encryptionIdentifier, byte[] encryptKey, byte[] decryptKey, byte[] specificData) {
        this.encryptionIdentifier = Objects.requireNonNull(encryptionIdentifier, "encryptionIdentifier");
        this.encryptKey = (byte[])Objects.requireNonNull(encryptKey, "encryptKey").clone();
        this.decryptKey = (byte[])Objects.requireNonNull(decryptKey, "decryptKey").clone();
        this.specificData = specificData != null ? (byte[])specificData.clone() : null;
    }

    @Override
    public EncryptionIdentifier getEncryptionIdentifier() {
        return this.encryptionIdentifier;
    }

    @Override
    public byte[] getEncryptKey() {
        return this.encryptKey;
    }

    @Override
    public byte[] getDecryptKey() {
        return this.decryptKey;
    }

    @Override
    public byte[] getSpecificData() {
        return this.specificData;
    }

    @Override
    public void close() {
        Arrays.fill(this.encryptKey, (byte)0);
        Arrays.fill(this.decryptKey, (byte)0);
        if (this.specificData != null) {
            Arrays.fill(this.specificData, (byte)0);
        }
        this.specificData = null;
        this.decryptKey = null;
        this.encryptKey = null;
    }
}

