/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.client.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfigurationFactory;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.NotThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.client.AwsAsyncClientParams;
import net.snowflake.client.jdbc.internal.amazonaws.client.builder.AwsClientBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.client.builder.ExecutorFactory;
import net.snowflake.client.jdbc.internal.amazonaws.regions.AwsRegionProvider;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsAsyncClientBuilder<Subclass extends AwsAsyncClientBuilder, TypeToBuild>
extends AwsClientBuilder<Subclass, TypeToBuild> {
    private ExecutorFactory executorFactory;

    protected AwsAsyncClientBuilder(ClientConfigurationFactory clientConfigFactory) {
        super(clientConfigFactory);
    }

    @SdkTestInternalApi
    protected AwsAsyncClientBuilder(ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        super(clientConfigFactory, regionProvider);
    }

    public final ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public final void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public final Subclass withExecutorFactory(ExecutorFactory executorFactory) {
        this.setExecutorFactory(executorFactory);
        return (Subclass)((AwsAsyncClientBuilder)this.getSubclass());
    }

    @Override
    public final TypeToBuild build() {
        return this.configureMutableProperties(this.build(this.getAsyncClientParams()));
    }

    protected abstract TypeToBuild build(AwsAsyncClientParams var1);

    protected final AwsAsyncClientParams getAsyncClientParams() {
        return new AsyncBuilderParams(this.executorFactory);
    }

    protected class AsyncBuilderParams
    extends AwsClientBuilder.SyncBuilderParams {
        private final ExecutorService _executorService;

        protected AsyncBuilderParams(ExecutorFactory executorFactory) {
            super(AwsAsyncClientBuilder.this);
            this._executorService = executorFactory == null ? this.defaultExecutor() : executorFactory.newExecutor();
        }

        @Override
        public ExecutorService getExecutor() {
            return this._executorService;
        }

        private ExecutorService defaultExecutor() {
            return Executors.newFixedThreadPool(this.getClientConfiguration().getMaxConnections());
        }
    }
}

