/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFDate;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class TmExt {
    public int tm_sec = 0;
    public int tm_min = 0;
    public int tm_hour = 0;
    public int tm_mday = 1;
    public int tm_mon = 0;
    public int tm_year = 0;
    public int tm_wday = -1;
    public int tm_yday = -1;
    public int tm_isdst = 0;
    public int tm_gmtoff = 0;
    public String tm_zone = null;
    public long tm_epochSec = 0L;
    public int tm_nsec = 0;
    public int tm_sec_scale = 0;
    public String tm_region = null;
    public boolean tm_has_offset = false;
    public boolean tm_has_epochSec = false;
    public boolean tm_has_tzidx = false;
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int MINUTES_IN_HOUR = 60;
    public static final int SECONDS_IN_HOUR = 3600;
    public static final int HOURS_IN_DAY = 24;
    public static final int MINUTES_IN_DAY = 1440;
    public static final int SECONDS_IN_DAY = 86400;
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    public static final int MAX_DAYS_IN_MONTH = 31;
    public static final int MAX_DAYS_IN_YEAR = 366;
    public static final int MAX_YEAR = 9999;
    public static final int MAX_SCALE = 9;
    public static final int FRAC_SECONDS = 1000000000;
    public static final int MAX_ZONE_LEN = 5;
    public static final int MAX_REGION_LEN = 48;
    public static final long EPOCH_START = -377673494400L;
    public static final long EPOCH_END = 253402214400L;
    public static final long EPOCH_AUTO_LIMIT = 31536000000L;
    private static final int[] s_mdays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] s_cdays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] s_lmdays = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] s_lcdays = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final int BAD_EPOCH_DATE = Integer.MAX_VALUE;
    public final TimeZone s_gmtTz = TimeZone.getTimeZone("GMT");
    private static final HashMap<String, Integer> s_tzAbbr = new HashMap();

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && ((year & 0xF) == 0 || year % 25 != 0);
    }

    public static YearDay yearFromDate(int date) {
        int y400 = (date - ((date += 719528) < 0 ? 146096 : 0)) / 146097;
        int y100 = 0;
        int y4 = 0;
        int y1 = 0;
        if ((date -= y400 * 146097) >= 366) {
            y100 = --date / 36524;
            if ((date %= 36524) >= 365) {
                y4 = ++date / 1461;
                if ((date %= 1461) >= 366) {
                    y1 = --date / 365;
                    date %= 365;
                }
            }
        }
        return new YearDay(y1 + 4 * y4 + 100 * y100 + 400 * y400, date);
    }

    public static int yearStartDate(int year) {
        return 365 * year - 719528 + (year > 0 ? (year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400 : year / 4 - year / 100 + year / 400);
    }

    public static int monthFromYday(int yday, boolean leap) {
        int d;
        assert (yday < 366);
        int m3 = yday / 31;
        int n = d = leap ? s_lcdays[m3 + 1] : s_cdays[m3 + 1];
        if (yday >= d) {
            ++m3;
        }
        return m3;
    }

    public static int mdayFromYday(int yday, int month, boolean leap) {
        assert (0 <= yday && yday < 366);
        assert (0 <= month && month < 12);
        return yday - (leap ? s_lcdays[month] : s_cdays[month]);
    }

    public static int dayOfWeek(int date) {
        if ((date += 4) < 0) {
            date += 0x70000000;
        }
        return date % 7;
    }

    public static int ydayFromMonthDay(int month, int mday, boolean leap) {
        assert (0 <= mday && mday < 31);
        assert (0 <= month && month < 12);
        return mday + (leap ? s_lcdays[month] : s_cdays[month]);
    }

    public static boolean isGoodMonthDay(int month, int mday, boolean leap) {
        return mday < (leap ? s_lmdays[month] : s_mdays[month]);
    }

    private void setTimeSec(long sec) {
        assert (0L <= sec && sec < 86400L);
        this.tm_sec = (int)sec % 60;
        int min2 = (int)sec / 60;
        this.tm_min = min2 % 60;
        this.tm_hour = min2 / 60;
    }

    public void setTimestamp(SFTimestamp ts, int scale, TimeZone tz) {
        long msec;
        assert (0 <= scale && scale <= 9);
        if (tz == null) {
            tz = ts.getTimeZone();
        } else if (!ts.getTimeZone().hasSameRules(tz)) {
            ts = ts.changeTimeZone(tz);
        }
        this.tm_sec = ts.extract(13);
        this.tm_min = ts.extract(12);
        this.tm_hour = ts.extract(11);
        this.tm_mday = ts.extract(5);
        this.tm_mon = ts.extract(2) - 1;
        this.tm_year = ts.extract(1) - 1900;
        this.tm_wday = ts.extract(7);
        this.tm_yday = ts.extract(6) - 1;
        int dstOff = ts.extract(16) / 1000;
        this.tm_gmtoff = ts.extract(15) / 1000 + dstOff;
        this.tm_isdst = dstOff != 0 ? 1 : 0;
        this.tm_has_offset = true;
        this.tm_zone = tz.getDisplayName(dstOff != 0, 0);
        if (this.tm_zone != null && (this.tm_zone.startsWith("GMT") || this.tm_zone.startsWith("UTC"))) {
            this.tm_zone = "GMT";
        }
        if ((msec = ts.getTime()) < 0L) {
            msec -= 999L;
        }
        this.tm_epochSec = msec / 1000L;
        this.tm_has_epochSec = true;
        this.tm_nsec = ts.getNanos();
        this.tm_sec_scale = scale;
        this.tm_region = tz.getID();
        this.tm_has_tzidx = false;
    }

    public void setDate(SFDate d) {
        this.tm_sec = 0;
        this.tm_min = 0;
        this.tm_hour = 0;
        this.tm_mday = d.extract(5);
        this.tm_mon = d.extract(2) - 1;
        this.tm_year = d.extract(1) - 1900;
        this.tm_wday = d.extract(7);
        this.tm_yday = d.extract(6) - 1;
        this.tm_gmtoff = 0;
        this.tm_isdst = -1;
        this.tm_has_offset = false;
        this.tm_zone = null;
        this.tm_epochSec = d.getTime() / 1000L;
        this.tm_has_epochSec = true;
        this.tm_nsec = 0;
        this.tm_sec_scale = 0;
        this.tm_region = null;
        this.tm_has_tzidx = false;
    }

    private int getEpochDate() {
        int d;
        if (this.tm_has_epochSec) {
            d = this.tm_epochSec >= 0L ? (int)(this.tm_epochSec / 86400L) : (int)((this.tm_epochSec - 86399L) / 86400L);
        } else {
            int year = this.tm_year + 1900;
            boolean leap = TmExt.isLeapYear(year);
            if (!TmExt.isGoodMonthDay(this.tm_mon, this.tm_mday - 1, leap)) {
                return Integer.MAX_VALUE;
            }
            d = TmExt.ydayFromMonthDay(this.tm_mon, this.tm_mday - 1, leap);
            if (this.tm_yday > 0 && this.tm_yday != d + 1) {
                return Integer.MAX_VALUE;
            }
            if (this.tm_wday >= 0 && this.tm_wday != TmExt.dayOfWeek(d += TmExt.yearStartDate(year))) {
                return Integer.MAX_VALUE;
            }
        }
        return d;
    }

    public SFDate getDate() {
        int d = this.getEpochDate();
        if (d == Integer.MAX_VALUE) {
            return null;
        }
        return new SFDate((long)d * 86400000L);
    }

    public void setTime(SFTime t, int scale) {
        assert (0 <= scale && scale <= 9);
        long nsec = t.getNanoseconds();
        int sec = (int)(nsec / 1000000000L);
        this.setTimeSec(sec);
        this.tm_mday = -1;
        this.tm_mon = -1;
        this.tm_year = -1;
        this.tm_wday = -1;
        this.tm_yday = -1;
        this.tm_gmtoff = 0;
        this.tm_isdst = -1;
        this.tm_has_offset = false;
        this.tm_zone = null;
        this.tm_epochSec = sec;
        this.tm_has_epochSec = false;
        this.tm_nsec = (int)(nsec % 1000000000L);
        this.tm_sec_scale = scale;
        this.tm_region = null;
        this.tm_has_tzidx = false;
    }

    private int getTimeOfDay() {
        int s2;
        if (this.tm_has_epochSec) {
            long ls = this.tm_epochSec / 86400L * 86400L;
            if ((ls = this.tm_epochSec - ls) < 0L) {
                ls += 86400L;
            }
            assert (0L <= ls && ls < 86400L);
            s2 = (int)ls;
        } else {
            s2 = this.tm_hour * 3600 + this.tm_min * 60 + this.tm_sec;
        }
        return s2;
    }

    public SFTime getTime() {
        long ns = (long)this.getTimeOfDay() * 1000000000L + (long)this.tm_nsec;
        return SFTime.fromNanoseconds(ns);
    }

    public SFTimestamp getTimestamp(TimeZone tz) {
        int d = this.getEpochDate();
        if (d == Integer.MAX_VALUE) {
            return null;
        }
        BigDecimal ns = new BigDecimal(d);
        ns = ns.multiply(new BigDecimal(86400000000000L));
        ns = ns.add(new BigDecimal((long)this.getTimeOfDay() * 1000000000L + (long)this.tm_nsec));
        SFTimestamp ts = SFTimestamp.fromNanoseconds(ns, this.s_gmtTz);
        if (this.tm_has_offset) {
            int tzidx = this.tm_gmtoff / 60 + 1440;
            tz = SFTimestamp.convertTimezoneIndexToTimeZone(tzidx);
        } else if (this.tm_zone != null) {
            Integer tzoff = s_tzAbbr.get(this.tm_zone);
            if (tzoff == null) {
                return null;
            }
            int tzidx = 1440 + tzoff;
            tz = SFTimestamp.convertTimezoneIndexToTimeZone(tzidx);
        }
        if (tz != null && !tz.hasSameRules(this.s_gmtTz)) {
            ts = this.tm_has_epochSec ? ts.changeTimeZone(tz) : ts.moveToTimeZone(tz);
        }
        return ts;
    }

    static {
        s_tzAbbr.put("NZDT", 780);
        s_tzAbbr.put("IDLE", 720);
        s_tzAbbr.put("NZST", 720);
        s_tzAbbr.put("NZT", 720);
        s_tzAbbr.put("AESST", 660);
        s_tzAbbr.put("ACSST", 630);
        s_tzAbbr.put("CADT", 630);
        s_tzAbbr.put("SADT", 630);
        s_tzAbbr.put("AEST", 600);
        s_tzAbbr.put("EAST", 600);
        s_tzAbbr.put("GST", 600);
        s_tzAbbr.put("LIGT", 600);
        s_tzAbbr.put("SAST", 570);
        s_tzAbbr.put("CAST", 570);
        s_tzAbbr.put("AWSST", 540);
        s_tzAbbr.put("JST", 540);
        s_tzAbbr.put("KST", 540);
        s_tzAbbr.put("MHT", 540);
        s_tzAbbr.put("WDT", 540);
        s_tzAbbr.put("MT", 510);
        s_tzAbbr.put("AWST", 480);
        s_tzAbbr.put("CCT", 480);
        s_tzAbbr.put("WADT", 480);
        s_tzAbbr.put("WST", 480);
        s_tzAbbr.put("JT", 450);
        s_tzAbbr.put("ALMST", 420);
        s_tzAbbr.put("WAST", 420);
        s_tzAbbr.put("CXT", 420);
        s_tzAbbr.put("ALMT", 360);
        s_tzAbbr.put("MAWT", 360);
        s_tzAbbr.put("IOT", 300);
        s_tzAbbr.put("MVT", 300);
        s_tzAbbr.put("TFT", 300);
        s_tzAbbr.put("AFT", 270);
        s_tzAbbr.put("MUT", 240);
        s_tzAbbr.put("RET", 240);
        s_tzAbbr.put("SCT", 240);
        s_tzAbbr.put("IT", 210);
        s_tzAbbr.put("EAT", 180);
        s_tzAbbr.put("BT", 180);
        s_tzAbbr.put("EETDST", 180);
        s_tzAbbr.put("HMT", 180);
        s_tzAbbr.put("BDST", 120);
        s_tzAbbr.put("CEST", 120);
        s_tzAbbr.put("CETDST", 120);
        s_tzAbbr.put("EET", 120);
        s_tzAbbr.put("FWT", 120);
        s_tzAbbr.put("IST", 120);
        s_tzAbbr.put("MEST", 120);
        s_tzAbbr.put("METDST", 120);
        s_tzAbbr.put("SST", 120);
        s_tzAbbr.put("BST", 60);
        s_tzAbbr.put("CET", 60);
        s_tzAbbr.put("DNT", 60);
        s_tzAbbr.put("FST", 60);
        s_tzAbbr.put("MET", 60);
        s_tzAbbr.put("MEWT", 60);
        s_tzAbbr.put("MEZ", 60);
        s_tzAbbr.put("NOR", 60);
        s_tzAbbr.put("SET", 60);
        s_tzAbbr.put("SWT", 60);
        s_tzAbbr.put("WETDST", 60);
        s_tzAbbr.put("GMT", 0);
        s_tzAbbr.put("UT", 0);
        s_tzAbbr.put("UTC", 0);
        s_tzAbbr.put("Z", 0);
        s_tzAbbr.put("ZULU", 0);
        s_tzAbbr.put("WET", 0);
        s_tzAbbr.put("WAT", -60);
        s_tzAbbr.put("NDT", -150);
        s_tzAbbr.put("ADT", -180);
        s_tzAbbr.put("AWT", -180);
        s_tzAbbr.put("NFT", -210);
        s_tzAbbr.put("NST", -210);
        s_tzAbbr.put("AST", -240);
        s_tzAbbr.put("ACST", -240);
        s_tzAbbr.put("ACT", -300);
        s_tzAbbr.put("EDT", -240);
        s_tzAbbr.put("CDT", -300);
        s_tzAbbr.put("EST", -300);
        s_tzAbbr.put("CST", -360);
        s_tzAbbr.put("MDT", -360);
        s_tzAbbr.put("MST", -420);
        s_tzAbbr.put("PDT", -420);
        s_tzAbbr.put("AKDT", -480);
        s_tzAbbr.put("PST", -480);
        s_tzAbbr.put("YDT", -480);
        s_tzAbbr.put("AKST", -540);
        s_tzAbbr.put("HDT", -540);
        s_tzAbbr.put("YST", -540);
        s_tzAbbr.put("AHST", -600);
        s_tzAbbr.put("HST", -600);
        s_tzAbbr.put("CAT", -600);
        s_tzAbbr.put("NT", -660);
        s_tzAbbr.put("IDLW", -720);
    }

    public static class YearDay {
        public int year;
        public int yday;

        public YearDay(int year_, int yday_) {
            this.year = year_;
            this.yday = yday_;
        }
    }
}

