/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.time.TimestampGenerator;
import com.datastax.oss.driver.internal.core.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
abstract class MonotonicTimestampGenerator
implements TimestampGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MonotonicTimestampGenerator.class);
    private final Clock clock;
    private final long warningThresholdMicros;
    private final long warningIntervalMillis;
    private final AtomicLong lastDriftWarning = new AtomicLong(Long.MIN_VALUE);

    protected MonotonicTimestampGenerator(DriverContext context) {
        this(MonotonicTimestampGenerator.buildClock(context), context);
    }

    protected MonotonicTimestampGenerator(Clock clock, DriverContext context) {
        this.clock = clock;
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.warningThresholdMicros = config.getDuration(DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, Duration.ZERO).toNanos() / 1000L;
        this.warningIntervalMillis = this.warningThresholdMicros == 0L ? 0L : config.getDuration(DefaultDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL).toMillis();
    }

    protected long computeNext(long last) {
        long currentTick = this.clock.currentTimeMicros();
        if (last >= currentTick) {
            this.maybeLog(currentTick, last);
            return last + 1L;
        }
        return currentTick;
    }

    @Override
    public void close() throws Exception {
    }

    private void maybeLog(long currentTick, long last) {
        long lastWarning;
        long now;
        if (this.warningThresholdMicros != 0L && LOG.isWarnEnabled() && last > currentTick + this.warningThresholdMicros && (now = System.currentTimeMillis()) > (lastWarning = this.lastDriftWarning.get()) + this.warningIntervalMillis && this.lastDriftWarning.compareAndSet(lastWarning, now)) {
            LOG.warn("Clock skew detected: current tick ({}) was {} microseconds behind the last generated timestamp ({}), returned timestamps will be artificially incremented to guarantee monotonicity.", new Object[]{currentTick, last - currentTick, last});
        }
    }

    private static Clock buildClock(DriverContext context) {
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        boolean forceJavaClock = config.getBoolean(DefaultDriverOption.TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK, false);
        return Clock.getInstance(forceJavaClock);
    }
}

