/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class IntListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<int[]> {
    public IntListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.INT), GenericType.of(int[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return int[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof int[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull int[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        output.putInt(array[index]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull int[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.getInt();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull int[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull int[] array, int index) {
        array[index] = Integer.parseInt(input);
    }

    @Override
    @NonNull
    protected int[] newInstance(int size) {
        return new int[size];
    }
}

