/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQAgent;

public interface AQMessageProperties {
    public static final int MESSAGE_NO_DELAY = 0;
    public static final int MESSAGE_NO_EXPIRATION = -1;

    public int getDequeueAttemptsCount();

    public void setCorrelation(String var1) throws SQLException;

    public String getCorrelation();

    public void setDelay(int var1) throws SQLException;

    public int getDelay();

    public Timestamp getEnqueueTime();

    public void setExceptionQueue(String var1) throws SQLException;

    public String getExceptionQueue();

    public void setExpiration(int var1) throws SQLException;

    public int getExpiration();

    public MessageState getState();

    public void setPriority(int var1) throws SQLException;

    public int getPriority();

    public void setRecipientList(AQAgent[] var1) throws SQLException;

    public AQAgent[] getRecipientList();

    public void setSender(AQAgent var1) throws SQLException;

    public AQAgent getSender();

    public String getTransactionGroup();

    public byte[] getPreviousQueueMessageId();

    public DeliveryMode getDeliveryMode();

    public String toString();

    public static final class DeliveryMode
    extends Enum<DeliveryMode> {
        public static final /* enum */ DeliveryMode PERSISTENT;
        public static final /* enum */ DeliveryMode BUFFERED;
        private final int code;
        private static final /* synthetic */ DeliveryMode[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static DeliveryMode[] values() {
            return (DeliveryMode[])$VALUES.clone();
        }

        public static DeliveryMode valueOf(String name) {
            return Enum.valueOf(DeliveryMode.class, name);
        }

        private DeliveryMode(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final DeliveryMode getDeliveryMode(int code) {
            if (code == BUFFERED.getCode()) {
                return BUFFERED;
            }
            return PERSISTENT;
        }

        static {
            try {
                $$$methodRef$$$4 = DeliveryMode.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = DeliveryMode.class.getDeclaredMethod("getDeliveryMode", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = DeliveryMode.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DeliveryMode.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DeliveryMode.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            PERSISTENT = new DeliveryMode(1);
            BUFFERED = new DeliveryMode(2);
            $VALUES = new DeliveryMode[]{PERSISTENT, BUFFERED};
        }
    }

    public static final class MessageState
    extends Enum<MessageState> {
        public static final /* enum */ MessageState WAITING;
        public static final /* enum */ MessageState READY;
        public static final /* enum */ MessageState PROCESSED;
        public static final /* enum */ MessageState EXPIRED;
        private final int code;
        private static final /* synthetic */ MessageState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static MessageState[] values() {
            return (MessageState[])$VALUES.clone();
        }

        public static MessageState valueOf(String name) {
            return Enum.valueOf(MessageState.class, name);
        }

        private MessageState(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final MessageState getMessageState(int code) {
            if (code == WAITING.getCode()) {
                return WAITING;
            }
            if (code == READY.getCode()) {
                return READY;
            }
            if (code == PROCESSED.getCode()) {
                return PROCESSED;
            }
            return EXPIRED;
        }

        static {
            try {
                $$$methodRef$$$4 = MessageState.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = MessageState.class.getDeclaredMethod("getMessageState", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = MessageState.class.getDeclaredMethod("getCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = MessageState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = MessageState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            WAITING = new MessageState(1);
            READY = new MessageState(0);
            PROCESSED = new MessageState(2);
            EXPIRED = new MessageState(3);
            $VALUES = new MessageState[]{WAITING, READY, PROCESSED, EXPIRED};
        }
    }
}

