/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

final class EncryptionStream
implements AutoCloseable {
    private static final int KEY_SIZE = 256;
    private static final int IV_SIZE = 16;
    private static final String ENCRYPTION_TRANSFORMATION_STR = "AES/CBC/PKCS5Padding";
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final String KEY_ENCRYPTION_TRANSFORMATION_STR = "RSA/ECB/PKCS1Padding";
    private final DataOutputStream outStream;
    private CipherOutputStream cipherOutStream;
    private byte[] sessionKey;
    private byte[] iv;
    private byte[] encryptedSessionKey;
    private byte[] encryptedIV;
    private final X509Certificate certificate;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    private EncryptionStream(OutputStream outStream, X509Certificate certificate) throws RuntimeException {
        try {
            this.outStream = new DataOutputStream(outStream);
            this.certificate = certificate;
            this.initializeKeyandIV();
            this.writeLogFileHeader();
            this.cipherOutStream = new CipherOutputStream(outStream, this.newCipher());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    static EncryptionStream newEncryptionStream(OutputStream outStream, X509Certificate certificate) throws RuntimeException {
        return new EncryptionStream(outStream, certificate);
    }

    private void writeLogFileHeader() throws IOException {
        this.outStream.writeInt(this.encryptedSessionKey.length);
        this.outStream.writeInt(this.encryptedIV.length);
        this.outStream.write(this.encryptedSessionKey);
        this.outStream.write(this.encryptedIV);
    }

    private Cipher newCipher() throws Exception {
        return null;
    }

    private void initializeKeyandIV() {
        throw new Error("EncryptionStream not supported");
    }

    public void write(byte[] data) throws IOException {
        this.cipherOutStream.write(data);
    }

    public void flush() throws IOException {
        this.cipherOutStream.flush();
        this.outStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.cipherOutStream.flush();
        this.cipherOutStream.close();
        this.outStream.flush();
        this.outStream.close();
    }

    static {
        try {
            $$$methodRef$$$7 = EncryptionStream.class.getDeclaredConstructor(OutputStream.class, X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = EncryptionStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = EncryptionStream.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = EncryptionStream.class.getDeclaredMethod("write", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = EncryptionStream.class.getDeclaredMethod("initializeKeyandIV", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = EncryptionStream.class.getDeclaredMethod("newCipher", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = EncryptionStream.class.getDeclaredMethod("writeLogFileHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = EncryptionStream.class.getDeclaredMethod("newEncryptionStream", OutputStream.class, X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

