/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionInputStreamInternal;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterSetMetaData;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHARACTER_SET_CONVERSION})
public class DBConversion {
    public static final boolean DO_CONVERSION_WITH_REPLACEMENT = true;
    public static final short ORACLE8_PROD_VERSION = 8030;
    protected short serverNCharSetId;
    protected short serverCharSetId;
    protected short clientCharSetId;
    protected CharacterSet serverCharSet;
    protected CharacterSet serverNCharSet;
    protected CharacterSet clientCharSet;
    protected CharacterSet asciiCharSet;
    protected boolean isServerCharSetFixedWidth;
    protected boolean isServerNCharSetFixedWidth;
    protected int c2sNlsRatio;
    protected int s2cNlsRatio;
    protected int sMaxCharSize;
    protected int cMaxCharSize;
    protected int maxNCharSize;
    protected boolean isServerCSMultiByte;
    private boolean isStrictASCIIConversion;
    private boolean isQuickASCIIConversion;
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short WE8ISO8859P15_CHARSET = 46;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short AL16UTF16_CHARSET = 2000;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;

    public DBConversion(short svrCharSet, short drvrCharSet, short svrNCharSet, boolean strictConversion, boolean quickASCIIConversion) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, DBConversion.class, $$$methodRef$$$62, null, svrCharSet, drvrCharSet, svrNCharSet, strictConversion, quickASCIIConversion);
            }
            this.isStrictASCIIConversion = false;
            this.isQuickASCIIConversion = false;
            this.isStrictASCIIConversion = strictConversion;
            this.isQuickASCIIConversion = quickASCIIConversion;
            if (drvrCharSet != -1) {
                this.init(svrCharSet, drvrCharSet, svrNCharSet);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, DBConversion.class, $$$methodRef$$$62, null);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, DBConversion.class, $$$methodRef$$$62, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, DBConversion.class, $$$methodRef$$$62, null, throwable2);
            }
            throw throwable;
        }
    }

    public DBConversion(short svrCharSet, short drvrCharSet, short svrNCharSet) throws SQLException {
        this(svrCharSet, drvrCharSet, svrNCharSet, false, false);
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, DBConversion.class, $$$methodRef$$$63, null, svrCharSet, drvrCharSet, svrNCharSet);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, DBConversion.class, $$$methodRef$$$63, null);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, DBConversion.class, $$$methodRef$$$63, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, DBConversion.class, $$$methodRef$$$63, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(short s2, short s3, short s4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void svrNCharSet;
            void svrCharSet;
            void drvrCharSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DBConversion.class, $$$methodRef$$$0, this, s2, s3, s4);
            }
            switch (drvrCharSet) {
                case -5: 
                case 1: 
                case 2: 
                case 31: 
                case 46: 
                case 178: 
                case 870: 
                case 871: 
                case 873: {
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset((short)drvrCharSet);
                }
            }
            this.serverCharSetId = svrCharSet;
            this.clientCharSetId = drvrCharSet;
            this.serverCharSet = CharacterSet.make(this.serverCharSetId);
            this.serverNCharSetId = svrNCharSet;
            this.serverNCharSet = CharacterSet.make(this.serverNCharSetId);
            this.clientCharSet = CharacterSet.make(this.clientCharSetId);
            this.c2sNlsRatio = CharacterSetMetaData.getRatio((int)svrCharSet, (int)drvrCharSet);
            this.s2cNlsRatio = CharacterSetMetaData.getRatio((int)drvrCharSet, (int)svrCharSet);
            this.sMaxCharSize = CharacterSetMetaData.getRatio((int)svrCharSet, 1);
            this.cMaxCharSize = CharacterSetMetaData.getRatio((int)drvrCharSet, 1);
            this.maxNCharSize = CharacterSetMetaData.getRatio((int)svrNCharSet, 1);
            this.findFixedWidthInfo();
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "DBConversion.c2sNlsRatio=" + this.c2sNlsRatio + "DBConversion.s2cNlsRatio=" + this.s2cNlsRatio);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DBConversion.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DBConversion.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DBConversion.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void findFixedWidthInfo() throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DBConversion.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.isServerCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverCharSetId);
            this.isServerNCharSetFixedWidth = CharacterSetMetaData.isFixedWidth(this.serverNCharSetId);
            boolean bl2 = this.isServerCSMultiByte = this.sMaxCharSize > 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DBConversion.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DBConversion.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DBConversion.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public short getServerCharSetId() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DBConversion.class, $$$methodRef$$$2, this, new Object[0]);
            }
            short s2 = this.serverCharSetId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DBConversion.class, $$$methodRef$$$2, this, s2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DBConversion.class, $$$methodRef$$$2, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DBConversion.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public short getNCharSetId() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DBConversion.class, $$$methodRef$$$3, this, new Object[0]);
            }
            short s2 = this.serverNCharSetId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DBConversion.class, $$$methodRef$$$3, this, s2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DBConversion.class, $$$methodRef$$$3, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DBConversion.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean IsNCharFixedWith() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DBConversion.class, $$$methodRef$$$4, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.serverNCharSetId == 2000;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DBConversion.class, $$$methodRef$$$4, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DBConversion.class, $$$methodRef$$$4, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DBConversion.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public short getClientCharSet() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.clientCharSetId == -1) {
                short s2 = this.serverCharSetId;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, s2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, null);
                }
                return s2;
            }
            short s3 = this.clientCharSetId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, s3);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, null);
            }
            return s3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DBConversion.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public CharacterSet getDbCharSetObj() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DBConversion.class, $$$methodRef$$$6, this, new Object[0]);
            }
            CharacterSet characterSet = this.serverCharSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DBConversion.class, $$$methodRef$$$6, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DBConversion.class, $$$methodRef$$$6, this, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DBConversion.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public CharacterSet getDriverCharSetObj() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DBConversion.class, $$$methodRef$$$7, this, new Object[0]);
            }
            CharacterSet characterSet = this.clientCharSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DBConversion.class, $$$methodRef$$$7, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DBConversion.class, $$$methodRef$$$7, this, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DBConversion.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public CharacterSet getDriverNCharSetObj() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DBConversion.class, $$$methodRef$$$8, this, new Object[0]);
            }
            CharacterSet characterSet = this.serverNCharSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DBConversion.class, $$$methodRef$$$8, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DBConversion.class, $$$methodRef$$$8, this, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DBConversion.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    CharacterSet getCharacterSet(short s2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void formOfUse;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, s2);
            }
            if (formOfUse == 2) {
                CharacterSet characterSet = this.getDriverNCharSetObj();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, characterSet);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, null);
                }
                return characterSet;
            }
            CharacterSet characterSet = this.getDriverCharSetObj();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, characterSet);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, null);
            }
            return characterSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DBConversion.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final short findDriverCharSet(short s2, short s3) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            int svrCharSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DBConversion.class, $$$methodRef$$$10, null, s2, s3);
            }
            int driver_charset = 0;
            switch (svrCharSet) {
                case 1: 
                case 2: 
                case 31: 
                case 46: 
                case 178: 
                case 873: {
                    driver_charset = svrCharSet;
                    break;
                }
                default: {
                    void oraVersion;
                    driver_charset = oraVersion >= 8030 ? 871 : 870;
                }
            }
            short s4 = driver_charset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DBConversion.class, $$$methodRef$$$10, null, s4);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DBConversion.class, $$$methodRef$$$10, null, null);
            }
            return s4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DBConversion.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] stringToDriverCharBytes(String string, short s2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void charset;
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, string, s2);
            }
            if (str == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, null);
                }
                return null;
            }
            byte[] ret_bytes = null;
            switch (charset) {
                case -5: 
                case 2000: {
                    ret_bytes = CharacterSet.stringToAL16UTF16Bytes(str);
                    break;
                }
                case 1: 
                case 2: {
                    ret_bytes = CharacterSet.stringToASCII(str);
                    break;
                }
                case 870: 
                case 871: {
                    ret_bytes = CharacterSet.stringToUTF(str);
                    break;
                }
                case 873: {
                    ret_bytes = CharacterSet.stringToAL32UTF8(str);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset((short)charset);
                }
            }
            byte[] byArray = ret_bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, null);
            }
            return ret_bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DBConversion.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] StringToCharBytes(String string) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, string);
            }
            if (str.length() == 0) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, null);
                }
                return null;
            }
            switch (this.clientCharSetId) {
                case -1: {
                    byte[] byArray = this.serverCharSet.convertWithReplacement((String)str);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, null);
                    }
                    return byArray;
                }
                case 2: 
                case 31: 
                case 46: 
                case 178: {
                    byte[] byArray = this.clientCharSet.convertWithReplacement((String)str);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, null);
                    }
                    return byArray;
                }
                case 1: {
                    if (!this.isQuickASCIIConversion) break;
                    byte[] bytearr = new byte[str.length()];
                    CharacterSet.convertJavaCharsToASCIIBytes(str.toCharArray(), 0, bytearr, 0, str.length(), false);
                    byte[] byArray = bytearr;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, null);
                    }
                    return bytearr;
                }
            }
            byte[] byArray = DBConversion.stringToDriverCharBytes((String)str, this.clientCharSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DBConversion.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String CharBytesToString(byte[] byArray, int n2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DBConversion.class, $$$methodRef$$$13, this, byArray, n2);
            }
            String string = this.CharBytesToString((byte[])bytes, (int)nbytes, true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DBConversion.class, $$$methodRef$$$13, this, string);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DBConversion.class, $$$methodRef$$$13, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DBConversion.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String CharBytesToString(byte[] byArray, int n2, boolean bl) throws SQLException {
        boolean bl2 = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, byArray, n2, bl);
            }
            String ret_str = null;
            if (((void)bytes).length == 0) {
                String string = ret_str;
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, string);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, null);
                }
                return string;
            }
            switch (this.clientCharSetId) {
                case -5: {
                    void nbytes;
                    ret_str = CharacterSet.AL16UTF16BytesToString((byte[])bytes, (int)nbytes);
                    break;
                }
                case 1: {
                    void nbytes;
                    ret_str = new String((byte[])bytes, 0, 0, (int)nbytes);
                    break;
                }
                case 2: 
                case 31: 
                case 46: 
                case 178: {
                    void useReplacementChar;
                    void nbytes;
                    if (useReplacementChar != false) {
                        ret_str = this.clientCharSet.toStringWithReplacement((byte[])bytes, 0, (int)nbytes);
                        break;
                    }
                    ret_str = this.clientCharSet.toString((byte[])bytes, 0, (int)nbytes);
                    break;
                }
                case 870: 
                case 871: {
                    void useReplacementChar;
                    void nbytes;
                    ret_str = CharacterSet.UTFToString((byte[])bytes, 0, (int)nbytes, (boolean)useReplacementChar);
                    break;
                }
                case 873: {
                    void useReplacementChar;
                    void nbytes;
                    ret_str = CharacterSet.AL32UTF8ToString((byte[])bytes, 0, (int)nbytes, (boolean)useReplacementChar);
                    break;
                }
                case -1: {
                    void nbytes;
                    ret_str = this.serverCharSet.toStringWithReplacement((byte[])bytes, 0, (int)nbytes);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.clientCharSetId);
                }
            }
            String string = ret_str;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DBConversion.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String NCharBytesToString(byte[] byArray, int n2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, DBConversion.class, $$$methodRef$$$15, this, byArray, n2);
            }
            String ret_str = null;
            if (this.clientCharSetId == -1) {
                ret_str = this.serverNCharSet.toStringWithReplacement((byte[])bytes, 0, (int)nbytes);
            } else {
                switch (this.serverNCharSetId) {
                    case -5: 
                    case 2000: {
                        ret_str = CharacterSet.AL16UTF16BytesToString((byte[])bytes, (int)nbytes);
                        break;
                    }
                    case 1: 
                    case 2: {
                        ret_str = new String((byte[])bytes, 0, 0, (int)nbytes);
                        break;
                    }
                    case 31: 
                    case 46: 
                    case 178: {
                        ret_str = this.serverNCharSet.toStringWithReplacement((byte[])bytes, 0, (int)nbytes);
                        break;
                    }
                    case 870: 
                    case 871: {
                        ret_str = CharacterSet.UTFToString((byte[])bytes, 0, (int)nbytes);
                        break;
                    }
                    case 873: {
                        ret_str = CharacterSet.AL32UTF8ToString((byte[])bytes, 0, (int)nbytes);
                        break;
                    }
                    case -1: {
                        ret_str = this.serverCharSet.toStringWithReplacement((byte[])bytes, 0, (int)nbytes);
                        break;
                    }
                    default: {
                        DBConversion.unexpectedCharset(this.clientCharSetId);
                    }
                }
            }
            String string = ret_str;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DBConversion.class, $$$methodRef$$$15, this, string);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DBConversion.class, $$$methodRef$$$15, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DBConversion.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToCHARBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            void nchars;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, DBConversion.class, $$$methodRef$$$16, this, cArray, n2, byArray);
            }
            int n3 = this.javaCharsToCHARBytes((char[])chars, (int)nchars, (byte[])bytes, this.clientCharSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DBConversion.class, $$$methodRef$$$16, this, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DBConversion.class, $$$methodRef$$$16, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DBConversion.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToCHARBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void byteOffset;
            void bytes;
            void charOffset;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, DBConversion.class, $$$methodRef$$$17, this, cArray, n2, byArray, n3, n4);
            }
            int n5 = this.javaCharsToCHARBytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, this.clientCharSetId, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DBConversion.class, $$$methodRef$$$17, this, n5);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DBConversion.class, $$$methodRef$$$17, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DBConversion.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] javaCharsToCHARBytes(char[] cArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, DBConversion.class, $$$methodRef$$$18, this, new Object[]{cArray});
            }
            byte[] buffer = new byte[((void)chars).length * this.getMaxCharbyteSize()];
            byte[] byArray = Arrays.copyOf(buffer, this.javaCharsToCHARBytes((char[])chars, ((void)chars).length, buffer));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DBConversion.class, $$$methodRef$$$18, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DBConversion.class, $$$methodRef$$$18, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DBConversion.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToNCHARBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            void nchars;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, DBConversion.class, $$$methodRef$$$19, this, cArray, n2, byArray);
            }
            int n3 = this.javaCharsToCHARBytes((char[])chars, (int)nchars, (byte[])bytes, this.serverNCharSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DBConversion.class, $$$methodRef$$$19, this, n3);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DBConversion.class, $$$methodRef$$$19, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DBConversion.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToNCHARBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void byteOffset;
            void bytes;
            void charOffset;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, DBConversion.class, $$$methodRef$$$20, this, cArray, n2, byArray, n3, n4);
            }
            int n5 = this.javaCharsToCHARBytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, this.serverNCharSetId, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DBConversion.class, $$$methodRef$$$20, this, n5);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DBConversion.class, $$$methodRef$$$20, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DBConversion.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int javaCharsToCHARBytes(char[] cArray, int n2, byte[] byArray, short s2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void cs;
            void bytes;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, DBConversion.class, $$$methodRef$$$21, this, cArray, n2, byArray, s2);
            }
            int n3 = this.javaCharsToCHARBytes((char[])chars, 0, (byte[])bytes, 0, (short)cs, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DBConversion.class, $$$methodRef$$$21, this, n3);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DBConversion.class, $$$methodRef$$$21, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DBConversion.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int javaCharsToCHARBytes(char[] cArray, int n2, byte[] byArray, int n3, short s2, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void cs;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, DBConversion.class, $$$methodRef$$$22, this, cArray, n2, byArray, n3, s2, n4);
            }
            int ret = 0;
            switch (cs) {
                case -5: 
                case 2000: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = CharacterSet.convertJavaCharsToAL16UTF16Bytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars);
                    break;
                }
                case 2: 
                case 46: 
                case 178: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    int[] ncharsRet = new int[]{nchars};
                    this.clientCharSet.convertWithReplacement((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, ncharsRet);
                    ret = ncharsRet[0];
                    break;
                }
                case 1: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = CharacterSet.convertJavaCharsToASCIIBytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars, this.isStrictASCIIConversion);
                    break;
                }
                case 31: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = CharacterSet.convertJavaCharsToISOLATIN1Bytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars);
                    break;
                }
                case 870: 
                case 871: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = CharacterSet.convertJavaCharsToUTFBytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars);
                    break;
                }
                case 873: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = CharacterSet.convertJavaCharsToAL32UTF8Bytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars);
                    break;
                }
                case -1: {
                    void nchars;
                    void byteOffset;
                    void bytes;
                    void charOffset;
                    void chars;
                    ret = this.javaCharsToDbCsBytes((char[])chars, (int)charOffset, (byte[])bytes, (int)byteOffset, (int)nchars);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset(this.clientCharSetId);
                }
            }
            int n5 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, DBConversion.class, $$$methodRef$$$22, this, n5);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DBConversion.class, $$$methodRef$$$22, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DBConversion.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int CHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, int n4, boolean bl) throws SQLException {
        boolean bl2 = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void charSize;
            void nbytes;
            void charOffset;
            void chars;
            void byteOffset;
            void bytes;
            void isNchar;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, byArray, n2, cArray, n3, nArray, n4, bl);
            }
            if (isNchar != false) {
                int n5 = this.NCHARBytesToJavaChars((byte[])bytes, (int)byteOffset, (char[])chars, (int)charOffset, (int[])nbytes, (int)charSize);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, n5);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, null);
                }
                return n5;
            }
            int n6 = this.CHARBytesToJavaChars((byte[])bytes, (int)byteOffset, (char[])chars, (int)charOffset, (int[])nbytes, (int)charSize);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, n6);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, null);
            }
            return n6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DBConversion.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int CHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void charSize;
            void nbytes;
            void charOffset;
            void chars;
            void byteOffset;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, DBConversion.class, $$$methodRef$$$24, this, byArray, n2, cArray, n3, nArray, n4);
            }
            int n5 = DBConversion._CHARBytesToJavaChars((byte[])bytes, (int)byteOffset, (char[])chars, (int)charOffset, this.clientCharSetId, (int[])nbytes, (int)charSize, this.serverCharSet, this.serverNCharSet, this.clientCharSet, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, DBConversion.class, $$$methodRef$$$24, this, n5);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DBConversion.class, $$$methodRef$$$24, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DBConversion.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int NCHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int[] nArray, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void charSize;
            void nbytes;
            void charOffset;
            void chars;
            void byteOffset;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, DBConversion.class, $$$methodRef$$$25, this, byArray, n2, cArray, n3, nArray, n4);
            }
            int n5 = DBConversion._CHARBytesToJavaChars((byte[])bytes, (int)byteOffset, (char[])chars, (int)charOffset, this.serverNCharSetId, (int[])nbytes, (int)charSize, this.serverCharSet, this.serverNCharSet, this.clientCharSet, true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, DBConversion.class, $$$methodRef$$$25, this, n5);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DBConversion.class, $$$methodRef$$$25, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DBConversion.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int _CHARBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, short s2, int[] nArray, int n4, CharacterSet characterSet, CharacterSet characterSet2, CharacterSet characterSet3, boolean bl) throws SQLException {
        boolean bl2 = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void cs;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, DBConversion.class, $$$methodRef$$$26, null, byArray, n2, cArray, n3, s2, nArray, n4, characterSet, characterSet2, characterSet3, bl);
            }
            int count = 0;
            int nbBytes = 0;
            switch (cs) {
                case -5: 
                case 2000: {
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    int charSize;
                    void nbytes;
                    nbBytes = nbytes[0] - nbytes[0] % 2;
                    if (charSize > ((void)chars).length - charOffset) {
                        charSize = ((void)chars).length - charOffset;
                    }
                    if (charSize * 2 < nbBytes) {
                        nbBytes = charSize * 2;
                    }
                    count = CharacterSet.convertAL16UTF16BytesToJavaChars(bytes, (int)byteOffset, (char[])chars, (int)charOffset, nbBytes, true);
                    nbytes[0] = nbytes[0] - nbBytes;
                    break;
                }
                case 1: {
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    int charSize;
                    void nbytes;
                    nbBytes = nbytes[0];
                    if (charSize > ((void)chars).length - charOffset) {
                        charSize = ((void)chars).length - charOffset;
                    }
                    if (charSize < nbBytes) {
                        nbBytes = charSize;
                    }
                    count = CharacterSet.convertASCIIBytesToJavaChars(bytes, (int)byteOffset, (char[])chars, (int)charOffset, nbBytes);
                    nbytes[0] = nbytes[0] - nbBytes;
                    break;
                }
                case 31: 
                case 46: 
                case 178: {
                    void _m_databaseCs;
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    void nbytes;
                    nbBytes = nbytes[0];
                    count = _m_databaseCs.toCharWithReplacement(bytes, (int)byteOffset, (char[])chars, (int)charOffset, nbBytes);
                    void v0 = nbytes;
                    v0[0] = v0[0] - count;
                    break;
                }
                case 870: 
                case 871: {
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    int charSize;
                    void nbytes;
                    if (charSize > ((void)chars).length - charOffset) {
                        charSize = ((void)chars).length - charOffset;
                    }
                    count = CharacterSet.convertUTFBytesToJavaChars(bytes, (int)byteOffset, (char[])chars, (int)charOffset, (int[])nbytes, true, charSize);
                    break;
                }
                case 873: {
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    int charSize;
                    void nbytes;
                    if (charSize > ((void)chars).length - charOffset) {
                        charSize = ((void)chars).length - charOffset;
                    }
                    count = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, (int)byteOffset, (char[])chars, (int)charOffset, (int[])nbytes, true, charSize);
                    break;
                }
                case -1: {
                    DBConversion.unexpectedCharset((short)-1);
                    break;
                }
                default: {
                    String converted;
                    char[] convertedChars;
                    int nbCharsToCopy;
                    void isNCharData;
                    void _m_driverCs;
                    void byteOffset;
                    byte[] bytes;
                    void charOffset;
                    void chars;
                    int charSize;
                    void nbytes;
                    void chSet = _m_driverCs;
                    if (isNCharData != false) {
                        void _m_databaseNCs;
                        chSet = _m_databaseNCs;
                    }
                    if ((nbCharsToCopy = (convertedChars = (converted = chSet.toStringWithReplacement(bytes, (int)byteOffset, (int)nbytes[0])).toCharArray()).length) > charSize) {
                        nbCharsToCopy = charSize;
                    }
                    count = nbCharsToCopy;
                    nbytes[0] = nbytes[0] - nbCharsToCopy;
                    System.arraycopy(convertedChars, 0, chars, (int)charOffset, nbCharsToCopy);
                }
            }
            int n5 = count;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, DBConversion.class, $$$methodRef$$$26, null, n5);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DBConversion.class, $$$methodRef$$$26, null, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DBConversion.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] asciiBytesToCHARBytes(byte[] byArray) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, DBConversion.class, $$$methodRef$$$27, this, new Object[]{byArray});
            }
            byte[] retbytes = null;
            switch (this.clientCharSetId) {
                case -5: {
                    void bytes;
                    retbytes = new byte[((void)bytes).length * 2];
                    int retbyte_i = 0;
                    for (int i2 = 0; i2 < ((void)bytes).length; ++i2) {
                        retbytes[retbyte_i++] = 0;
                        retbytes[retbyte_i++] = bytes[i2];
                    }
                    break;
                }
                case -1: {
                    void bytes;
                    if (this.asciiCharSet == null) {
                        this.asciiCharSet = CharacterSet.make(1);
                    }
                    try {
                        retbytes = this.serverCharSet.convert(this.asciiCharSet, (byte[])bytes, 0, ((void)bytes).length);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                default: {
                    void bytes;
                    retbytes = bytes;
                }
            }
            byte[] byArray2 = retbytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, DBConversion.class, $$$methodRef$$$27, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DBConversion.class, $$$methodRef$$$27, this, null);
            }
            return retbytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DBConversion.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToDbCsBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes;
            void chars;
            int num_conv_bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, DBConversion.class, $$$methodRef$$$28, this, cArray, n2, byArray);
            }
            int n3 = num_conv_bytes = this.javaCharsToDbCsBytes((char[])chars, 0, (byte[])bytes, 0, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, DBConversion.class, $$$methodRef$$$28, this, n3);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DBConversion.class, $$$methodRef$$$28, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DBConversion.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int javaCharsToDbCsBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void charOffset;
            void chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, DBConversion.class, $$$methodRef$$$29, this, cArray, n2, byArray, n3, n4);
            }
            int num_conv_bytes = 0;
            DBConversion.catchCharsLen((char[])chars, (int)charOffset, (int)nchars);
            String str = new String((char[])chars, (int)charOffset, (int)nchars);
            byte[] dbcs_bytes = this.serverCharSet.convertWithReplacement(str);
            str = null;
            if (dbcs_bytes != null) {
                void byteOffset;
                void bytes;
                num_conv_bytes = dbcs_bytes.length;
                DBConversion.catchBytesLen((byte[])bytes, (int)byteOffset, num_conv_bytes);
                System.arraycopy(dbcs_bytes, 0, bytes, (int)byteOffset, num_conv_bytes);
                dbcs_bytes = null;
            }
            int n5 = num_conv_bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, DBConversion.class, $$$methodRef$$$29, this, n5);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DBConversion.class, $$$methodRef$$$29, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DBConversion.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int javaCharsToUcs2Bytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes;
            char[] chars;
            int byte_i;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, DBConversion.class, $$$methodRef$$$30, null, cArray, n2, byArray);
            }
            int n3 = byte_i = DBConversion.javaCharsToUcs2Bytes(chars, 0, (byte[])bytes, 0, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, DBConversion.class, $$$methodRef$$$30, null, n3);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DBConversion.class, $$$methodRef$$$30, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DBConversion.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int javaCharsToUcs2Bytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void byteOffset;
            void bytes;
            void nchars;
            void charOffset;
            char[] chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, DBConversion.class, $$$methodRef$$$31, null, cArray, n2, byArray, n3, n4);
            }
            DBConversion.catchCharsLen(chars, (int)charOffset, (int)nchars);
            DBConversion.catchBytesLen((byte[])bytes, (int)byteOffset, (int)(nchars * 2));
            void lastChar = nchars + charOffset;
            void byte_i = byteOffset;
            for (void char_i = charOffset; char_i < lastChar; ++char_i) {
                bytes[byte_i++] = (byte)(chars[char_i] >> 8 & 0xFF);
                bytes[byte_i++] = (byte)(chars[char_i] & 0xFF);
            }
            void var9_9 = byte_i - byteOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, DBConversion.class, $$$methodRef$$$31, null, (int)var9_9);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DBConversion.class, $$$methodRef$$$31, null, null);
            }
            return (int)var9_9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DBConversion.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int ucs2BytesToJavaChars(byte[] byArray, int n2, char[] cArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void chars;
            void nbytes;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, DBConversion.class, $$$methodRef$$$32, null, byArray, n2, cArray);
            }
            int n3 = CharacterSet.AL16UTF16BytesToJavaChars(bytes, (int)nbytes, (char[])chars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, DBConversion.class, $$$methodRef$$$32, null, n3);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DBConversion.class, $$$methodRef$$$32, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DBConversion.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] stringToAsciiBytes(String string) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, DBConversion.class, $$$methodRef$$$33, null, string);
            }
            byte[] byArray = CharacterSet.stringToASCII(str);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, DBConversion.class, $$$methodRef$$$33, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DBConversion.class, $$$methodRef$$$33, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DBConversion.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int asciiBytesToJavaChars(byte[] byArray, int n2, char[] cArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nbytes;
            void chars;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, DBConversion.class, $$$methodRef$$$34, null, byArray, n2, cArray);
            }
            int n3 = CharacterSet.convertASCIIBytesToJavaChars(bytes, 0, (char[])chars, 0, (int)nbytes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, DBConversion.class, $$$methodRef$$$34, null, n3);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DBConversion.class, $$$methodRef$$$34, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DBConversion.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int javaCharsToAsciiBytes(char[] cArray, int n2, byte[] byArray) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void nchars;
            void bytes;
            char[] chars;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, DBConversion.class, $$$methodRef$$$35, null, cArray, n2, byArray);
            }
            int n3 = CharacterSet.convertJavaCharsToASCIIBytes(chars, 0, (byte[])bytes, 0, (int)nchars);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, DBConversion.class, $$$methodRef$$$35, null, n3);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DBConversion.class, $$$methodRef$$$35, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DBConversion.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final int asciiBytesToUTF16Bytes(byte[] byArray, int n2, byte[] byArray2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void utf16Bytes;
            void nbytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, DBConversion.class, $$$methodRef$$$36, null, byArray, n2, byArray2);
            }
            if (nbytes < 0) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Number of bytes to convert is negative:" + (int)nbytes);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, DBConversion.class, $$$methodRef$$$36, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            int writeLimit = Math.min((int)(nbytes * 2), ((void)utf16Bytes).length & 0xFFFFFFFE);
            for (int i2 = 0; i2 < writeLimit; i2 += 2) {
                byte[] asciiBytes;
                utf16Bytes[i2] = false;
                utf16Bytes[i2 + 1] = asciiBytes[i2 >>> 1];
            }
            int n3 = writeLimit;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, DBConversion.class, $$$methodRef$$$36, null, n3);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DBConversion.class, $$$methodRef$$$36, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DBConversion.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final boolean isCharSetMultibyte(short s2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            short charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, s2);
            }
            switch (charSet) {
                case 1: 
                case 31: 
                case 46: {
                    boolean bl2 = false;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, bl2);
                        ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, null);
                    }
                    return false;
                }
                case -5: 
                case -1: 
                case 870: 
                case 871: 
                case 873: {
                    boolean bl3 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, bl3);
                        ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, null);
                    }
                    return true;
                }
            }
            boolean bl4 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, bl4);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DBConversion.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    public int getMaxCharbyteSize() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, DBConversion.class, $$$methodRef$$$38, this, new Object[0]);
            }
            int n2 = this._getMaxCharbyteSize(this.clientCharSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, DBConversion.class, $$$methodRef$$$38, this, n2);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DBConversion.class, $$$methodRef$$$38, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DBConversion.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getMaxNCharbyteSize() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, DBConversion.class, $$$methodRef$$$39, this, new Object[0]);
            }
            int n2 = this._getMaxCharbyteSize(this.serverNCharSetId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, DBConversion.class, $$$methodRef$$$39, this, n2);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DBConversion.class, $$$methodRef$$$39, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DBConversion.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int _getMaxCharbyteSize(short s2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void cs;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, s2);
            }
            switch (cs) {
                case 1: {
                    int n2 = 1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n2);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 1;
                }
                case 31: 
                case 46: {
                    int n3 = 1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 1;
                }
                case 870: 
                case 871: {
                    int n4 = 3;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 3;
                }
                case -5: 
                case 2000: {
                    int n5 = 2;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 2;
                }
                case -1: {
                    int n6 = 4;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 4;
                }
                case 873: {
                    int n7 = 4;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n7);
                        ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
                    }
                    return 4;
                }
            }
            int n8 = 1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, n8);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, null);
            }
            return 1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DBConversion.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isUcs2CharSet() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, DBConversion.class, $$$methodRef$$$41, this, new Object[0]);
            }
            boolean bl3 = bl2 = this.clientCharSetId == -5;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, DBConversion.class, $$$methodRef$$$41, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DBConversion.class, $$$methodRef$$$41, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DBConversion.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public static final int RAWBytesToHexChars(byte[] byArray, int n2, char[] cArray) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            int nbytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, DBConversion.class, $$$methodRef$$$42, null, byArray, n2, cArray);
            }
            int char_i = 0;
            for (int byte_i = 0; byte_i < nbytes; ++byte_i) {
                byte[] bytes;
                chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] >> 4 & 0xF));
                chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] & 0xF));
            }
            int n3 = char_i;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, DBConversion.class, $$$methodRef$$$42, null, n3);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DBConversion.class, $$$methodRef$$$42, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DBConversion.class, $$$methodRef$$$42, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int hexDigit2Nibble(char c2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void hex;
            int result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, DBConversion.class, $$$methodRef$$$43, this, Character.valueOf(c2));
            }
            if ((result = Character.digit((char)hex, 16)) == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, "Invalid hex digit: " + (char)hex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, DBConversion.class, $$$methodRef$$$43, this, sQLException);
                }
                throw sQLException;
            }
            int n2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, DBConversion.class, $$$methodRef$$$43, this, n2);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DBConversion.class, $$$methodRef$$$43, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DBConversion.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] hexString2Bytes(String string) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void hexString;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, DBConversion.class, $$$methodRef$$$44, this, string);
            }
            int len = hexString.length();
            char[] hexChars = new char[len];
            hexString.getChars(0, len, hexChars, 0);
            byte[] byArray = this.hexChars2Bytes(hexChars, 0, len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, DBConversion.class, $$$methodRef$$$44, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DBConversion.class, $$$methodRef$$$44, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DBConversion.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] hexChars2Bytes(char[] cArray, int n2, int n3) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void hexChars;
            byte[] bytes;
            void len;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, cArray, n2, n3);
            }
            int i2 = 0;
            void j2 = offset;
            if (len == false) {
                byte[] byArray = new byte[]{};
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, null);
                }
                return byArray;
            }
            if (len % 2 > 0) {
                bytes = new byte[(len + true) / 2];
                bytes[i2++] = (byte)this.hexDigit2Nibble((char)hexChars[j2++]);
            } else {
                bytes = new byte[len / 2];
            }
            while (i2 < bytes.length) {
                bytes[i2] = (byte)(this.hexDigit2Nibble((char)hexChars[j2++]) << 4 | this.hexDigit2Nibble((char)hexChars[j2++]));
                ++i2;
            }
            byte[] byArray = bytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, null);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DBConversion.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream ConvertStream(InputStream inputStream, int n2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void conversion;
            void stream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, DBConversion.class, $$$methodRef$$$46, this, inputStream, n2);
            }
            OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this, (InputStream)stream, (int)conversion);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, DBConversion.class, $$$methodRef$$$46, this, oracleConversionInputStream);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DBConversion.class, $$$methodRef$$$46, this, null);
            }
            return oracleConversionInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DBConversion.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream ConvertStream(InputStream inputStream, int n2, int n3) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void max_bytes;
            void conversion;
            void stream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, DBConversion.class, $$$methodRef$$$47, this, inputStream, n2, n3);
            }
            OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this, (InputStream)stream, (int)conversion, (int)max_bytes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, DBConversion.class, $$$methodRef$$$47, this, oracleConversionInputStream);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DBConversion.class, $$$methodRef$$$47, this, null);
            }
            return oracleConversionInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DBConversion.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream ConvertStreamInternal(InputStream inputStream, int n2, int n3) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void max_bytes;
            void conversion;
            void stream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, DBConversion.class, $$$methodRef$$$48, this, inputStream, n2, n3);
            }
            OracleConversionInputStreamInternal oracleConversionInputStreamInternal = new OracleConversionInputStreamInternal(this, (InputStream)stream, (int)conversion, (int)max_bytes);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, DBConversion.class, $$$methodRef$$$48, this, oracleConversionInputStreamInternal);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DBConversion.class, $$$methodRef$$$48, this, null);
            }
            return oracleConversionInputStreamInternal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DBConversion.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream ConvertStream(Reader reader, int n2, int n3, short s2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void form_of_use;
            void max_chars;
            void conversion;
            void stream;
            OracleConversionInputStream ocis;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, DBConversion.class, $$$methodRef$$$49, this, reader, n2, n3, s2);
            }
            OracleConversionInputStream oracleConversionInputStream = ocis = new OracleConversionInputStream(this, (Reader)stream, (int)conversion, (int)max_chars, (short)form_of_use);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, DBConversion.class, $$$methodRef$$$49, this, oracleConversionInputStream);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DBConversion.class, $$$methodRef$$$49, this, null);
            }
            return oracleConversionInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DBConversion.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream ConvertStreamInternal(Reader reader, int n2, int n3, short s2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void form_of_use;
            void max_chars;
            void conversion;
            void stream;
            OracleConversionInputStreamInternal ocis;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, DBConversion.class, $$$methodRef$$$50, this, reader, n2, n3, s2);
            }
            OracleConversionInputStreamInternal oracleConversionInputStreamInternal = ocis = new OracleConversionInputStreamInternal(this, (Reader)stream, (int)conversion, (int)max_chars, (short)form_of_use);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, DBConversion.class, $$$methodRef$$$50, this, oracleConversionInputStreamInternal);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DBConversion.class, $$$methodRef$$$50, this, null);
            }
            return oracleConversionInputStreamInternal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DBConversion.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Reader ConvertCharacterStream(InputStream inputStream, int n2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void conversion;
            void stream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, DBConversion.class, $$$methodRef$$$51, this, inputStream, n2);
            }
            OracleConversionReader oracleConversionReader = new OracleConversionReader(this, (InputStream)stream, (int)conversion);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, DBConversion.class, $$$methodRef$$$51, this, oracleConversionReader);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DBConversion.class, $$$methodRef$$$51, this, null);
            }
            return oracleConversionReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DBConversion.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Reader ConvertCharacterStream(InputStream inputStream, int n2, short s2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void form_of_use;
            void conversion;
            void stream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, DBConversion.class, $$$methodRef$$$52, this, inputStream, n2, s2);
            }
            OracleConversionReader ocr = new OracleConversionReader(this, (InputStream)stream, (int)conversion);
            ocr.setFormOfUse((short)form_of_use);
            OracleConversionReader oracleConversionReader = ocr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, DBConversion.class, $$$methodRef$$$52, this, oracleConversionReader);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DBConversion.class, $$$methodRef$$$52, this, null);
            }
            return oracleConversionReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DBConversion.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream CharsToStream(char[] cArray, int n2, int n3, int n4) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            void offset;
            void javachars;
            void conversion;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, cArray, n2, n3, n4);
            }
            if (conversion == 10) {
                AsciiStream asciiStream = new AsciiStream((char[])javachars, (int)offset, (int)len);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, asciiStream);
                    ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, null);
                }
                return asciiStream;
            }
            if (conversion == 11) {
                UnicodeStream unicodeStream = new UnicodeStream((char[])javachars, (int)offset, (int)len);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, unicodeStream);
                    ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, null);
                }
                return unicodeStream;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 39, "unknownConversion").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DBConversion.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    static final void unexpectedCharset(short s2) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, DBConversion.class, $$$methodRef$$$54, null, s2);
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(35, "DBConversion").fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$54, Level.FINEST, DBConversion.class, $$$methodRef$$$54, null, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DBConversion.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static final void catchBytesLen(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] bytes;
            void nbytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, DBConversion.class, $$$methodRef$$$55, null, byArray, n2, n3);
            }
            if (offset + nbytes > bytes.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(39, "catchBytesLen").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$55, Level.FINEST, DBConversion.class, $$$methodRef$$$55, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, DBConversion.class, $$$methodRef$$$55, null);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DBConversion.class, $$$methodRef$$$55, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DBConversion.class, $$$methodRef$$$55, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static final void catchCharsLen(char[] cArray, int n2, int n3) throws SQLException {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            char[] chars;
            void nchars;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, DBConversion.class, $$$methodRef$$$56, null, cArray, n2, n3);
            }
            if (offset + nchars > chars.length) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(39, "catchCharsLen").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$56, Level.FINEST, DBConversion.class, $$$methodRef$$$56, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, DBConversion.class, $$$methodRef$$$56, null);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DBConversion.class, $$$methodRef$$$56, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DBConversion.class, $$$methodRef$$$56, null, throwable2);
            }
            throw throwable;
        }
    }

    public static final int getUtfLen(char c2) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            char c3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, DBConversion.class, $$$methodRef$$$57, null, Character.valueOf(c2));
            }
            int utf_len = 0;
            utf_len = (c3 & 0xFF80) == 0 ? 1 : ((c3 & 0xF800) == 0 ? 2 : 3);
            int n2 = utf_len;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, DBConversion.class, $$$methodRef$$$57, null, n2);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DBConversion.class, $$$methodRef$$$57, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DBConversion.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int encodedByteLength(String string, boolean bl) throws SQLException {
        boolean bl2 = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, DBConversion.class, $$$methodRef$$$58, this, string, bl);
            }
            int len = 0;
            if (s2 != null && (len = s2.length()) != 0) {
                void isNChar;
                len = isNChar != false ? (this.isServerNCharSetFixedWidth ? len * this.maxNCharSize : this.serverNCharSet.encodedByteLength((String)s2)) : (this.isServerCharSetFixedWidth ? len * this.sMaxCharSize : this.serverCharSet.encodedByteLength((String)s2));
            }
            int n2 = len;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, DBConversion.class, $$$methodRef$$$58, this, n2);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DBConversion.class, $$$methodRef$$$58, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DBConversion.class, $$$methodRef$$$58, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int encodedByteLength(char[] cArray, boolean bl) throws SQLException {
        boolean bl2 = (2L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, DBConversion.class, $$$methodRef$$$59, this, cArray, bl);
            }
            int len = 0;
            if (c2 != null && (len = ((void)c2).length) != 0) {
                void isNChar;
                len = isNChar != false ? (this.isServerNCharSetFixedWidth ? len * this.maxNCharSize : this.serverNCharSet.encodedByteLength((char[])c2)) : (this.isServerCharSetFixedWidth ? len * this.sMaxCharSize : this.serverCharSet.encodedByteLength((char[])c2));
            }
            int n2 = len;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, DBConversion.class, $$$methodRef$$$59, this, n2);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DBConversion.class, $$$methodRef$$$59, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DBConversion.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, DBConversion.class, $$$methodRef$$$60, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DBConversion.class, $$$methodRef$$$60, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DBConversion.class, $$$methodRef$$$60, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DBConversion.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ boolean access$000(DBConversion dBConversion) {
        boolean bl = (2L & TraceControllerImpl.feature) != 0L;
        try {
            DBConversion x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, DBConversion.class, $$$methodRef$$$61, null, dBConversion);
            }
            boolean bl2 = x0.isStrictASCIIConversion;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, DBConversion.class, $$$methodRef$$$61, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, DBConversion.class, $$$methodRef$$$61, null, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, DBConversion.class, $$$methodRef$$$61, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$63 = DBConversion.class.getDeclaredConstructor(Short.TYPE, Short.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = DBConversion.class.getDeclaredConstructor(Short.TYPE, Short.TYPE, Short.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = DBConversion.class.getDeclaredMethod("access$000", DBConversion.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = DBConversion.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = DBConversion.class.getDeclaredMethod("encodedByteLength", char[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = DBConversion.class.getDeclaredMethod("encodedByteLength", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = DBConversion.class.getDeclaredMethod("getUtfLen", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = DBConversion.class.getDeclaredMethod("catchCharsLen", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = DBConversion.class.getDeclaredMethod("catchBytesLen", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = DBConversion.class.getDeclaredMethod("unexpectedCharset", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = DBConversion.class.getDeclaredMethod("CharsToStream", char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = DBConversion.class.getDeclaredMethod("ConvertCharacterStream", InputStream.class, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = DBConversion.class.getDeclaredMethod("ConvertCharacterStream", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = DBConversion.class.getDeclaredMethod("ConvertStreamInternal", Reader.class, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = DBConversion.class.getDeclaredMethod("ConvertStream", Reader.class, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = DBConversion.class.getDeclaredMethod("ConvertStreamInternal", InputStream.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = DBConversion.class.getDeclaredMethod("ConvertStream", InputStream.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = DBConversion.class.getDeclaredMethod("ConvertStream", InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = DBConversion.class.getDeclaredMethod("hexChars2Bytes", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = DBConversion.class.getDeclaredMethod("hexString2Bytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = DBConversion.class.getDeclaredMethod("hexDigit2Nibble", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = DBConversion.class.getDeclaredMethod("RAWBytesToHexChars", byte[].class, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = DBConversion.class.getDeclaredMethod("isUcs2CharSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = DBConversion.class.getDeclaredMethod("_getMaxCharbyteSize", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = DBConversion.class.getDeclaredMethod("getMaxNCharbyteSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = DBConversion.class.getDeclaredMethod("getMaxCharbyteSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = DBConversion.class.getDeclaredMethod("isCharSetMultibyte", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = DBConversion.class.getDeclaredMethod("asciiBytesToUTF16Bytes", byte[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = DBConversion.class.getDeclaredMethod("javaCharsToAsciiBytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = DBConversion.class.getDeclaredMethod("asciiBytesToJavaChars", byte[].class, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = DBConversion.class.getDeclaredMethod("stringToAsciiBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = DBConversion.class.getDeclaredMethod("ucs2BytesToJavaChars", byte[].class, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = DBConversion.class.getDeclaredMethod("javaCharsToUcs2Bytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = DBConversion.class.getDeclaredMethod("javaCharsToUcs2Bytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = DBConversion.class.getDeclaredMethod("javaCharsToDbCsBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = DBConversion.class.getDeclaredMethod("javaCharsToDbCsBytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = DBConversion.class.getDeclaredMethod("asciiBytesToCHARBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = DBConversion.class.getDeclaredMethod("_CHARBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, Short.TYPE, int[].class, Integer.TYPE, CharacterSet.class, CharacterSet.class, CharacterSet.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = DBConversion.class.getDeclaredMethod("NCHARBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = DBConversion.class.getDeclaredMethod("CHARBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = DBConversion.class.getDeclaredMethod("CHARBytesToJavaChars", byte[].class, Integer.TYPE, char[].class, Integer.TYPE, int[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = DBConversion.class.getDeclaredMethod("javaCharsToCHARBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = DBConversion.class.getDeclaredMethod("javaCharsToCHARBytes", char[].class, Integer.TYPE, byte[].class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = DBConversion.class.getDeclaredMethod("javaCharsToNCHARBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = DBConversion.class.getDeclaredMethod("javaCharsToNCHARBytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = DBConversion.class.getDeclaredMethod("javaCharsToCHARBytes", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = DBConversion.class.getDeclaredMethod("javaCharsToCHARBytes", char[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = DBConversion.class.getDeclaredMethod("javaCharsToCHARBytes", char[].class, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = DBConversion.class.getDeclaredMethod("NCharBytesToString", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = DBConversion.class.getDeclaredMethod("CharBytesToString", byte[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = DBConversion.class.getDeclaredMethod("CharBytesToString", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = DBConversion.class.getDeclaredMethod("StringToCharBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = DBConversion.class.getDeclaredMethod("stringToDriverCharBytes", String.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = DBConversion.class.getDeclaredMethod("findDriverCharSet", Short.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = DBConversion.class.getDeclaredMethod("getCharacterSet", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DBConversion.class.getDeclaredMethod("getDriverNCharSetObj", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DBConversion.class.getDeclaredMethod("getDriverCharSetObj", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DBConversion.class.getDeclaredMethod("getDbCharSetObj", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DBConversion.class.getDeclaredMethod("getClientCharSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DBConversion.class.getDeclaredMethod("IsNCharFixedWith", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DBConversion.class.getDeclaredMethod("getNCharSetId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DBConversion.class.getDeclaredMethod("getServerCharSetId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DBConversion.class.getDeclaredMethod("findFixedWidthInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DBConversion.class.getDeclaredMethod("init", Short.TYPE, Short.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    class UnicodeStream
    extends OracleBufferedStream {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        UnicodeStream(char[] javachars, int offset, int len) {
            super(len);
            this.currentBufferSize = this.initialBufferSize;
            this.resizableBuffer = new byte[this.currentBufferSize];
            int cind = offset;
            int bind = 0;
            while (bind < len) {
                char c2 = javachars[cind++];
                this.resizableBuffer[bind++] = (byte)(c2 >> 8 & 0xFF);
                this.resizableBuffer[bind++] = (byte)(c2 & 0xFF);
            }
            this.count = len;
        }

        @Override
        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }

        @Override
        public boolean needBytes(int ignore) {
            return !this.closed && this.pos < this.count;
        }

        static {
            try {
                $$$methodRef$$$2 = UnicodeStream.class.getDeclaredConstructor(DBConversion.class, char[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = UnicodeStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = UnicodeStream.class.getDeclaredMethod("needBytes", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    class AsciiStream
    extends OracleBufferedStream {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        AsciiStream(char[] javachars, int offset, int len) {
            super(len);
            this.currentBufferSize = this.initialBufferSize;
            this.resizableBuffer = new byte[this.currentBufferSize];
            if (DBConversion.this.serverCharSetId == 1 || !DBConversion.access$000(DBConversion.this)) {
                int cind = offset;
                for (int bind = 0; bind < len; ++bind) {
                    this.resizableBuffer[bind] = (byte)javachars[cind++];
                }
            } else {
                if (DBConversion.this.asciiCharSet == null) {
                    DBConversion.this.asciiCharSet = CharacterSet.make(1);
                }
                this.resizableBuffer = DBConversion.this.asciiCharSet.convertWithReplacement(new String(javachars, offset, len));
            }
            this.count = len;
        }

        @Override
        public boolean needBytes() {
            return !this.closed && this.pos < this.count;
        }

        @Override
        public boolean needBytes(int ignore) {
            return !this.closed && this.pos < this.count;
        }

        static {
            try {
                $$$methodRef$$$2 = AsciiStream.class.getDeclaredConstructor(DBConversion.class, char[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AsciiStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AsciiStream.class.getDeclaredMethod("needBytes", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

