/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Logger;

class FDBigInt {
    int nWords;
    int[] data;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    FDBigInt(int v2) {
        this.nWords = 1;
        this.data = new int[1];
        this.data[0] = v2;
    }

    FDBigInt(long v2) {
        this.data = new int[2];
        this.data[0] = (int)v2;
        this.data[1] = (int)(v2 >>> 32);
        this.nWords = this.data[1] == 0 ? 1 : 2;
    }

    FDBigInt(FDBigInt other) {
        this.nWords = other.nWords;
        this.data = new int[this.nWords];
        System.arraycopy(other.data, 0, this.data, 0, this.nWords);
    }

    FDBigInt(int[] d2, int n2) {
        this.data = d2;
        this.nWords = n2;
    }

    void lshiftMe(int c2) throws IllegalArgumentException {
        if (c2 <= 0) {
            if (c2 == 0) {
                return;
            }
            throw new IllegalArgumentException("negative shift count");
        }
        int wordcount = c2 >> 5;
        int bitcount = c2 & 0x1F;
        int anticount = 32 - bitcount;
        int[] t2 = this.data;
        int[] s2 = this.data;
        if (this.nWords + wordcount + 1 > t2.length) {
            t2 = new int[this.nWords + wordcount + 1];
        }
        int target = this.nWords + wordcount;
        int src = this.nWords - 1;
        if (bitcount == 0) {
            System.arraycopy(s2, 0, t2, wordcount, this.nWords);
            target = wordcount - 1;
        } else {
            t2[target--] = s2[src] >>> anticount;
            while (src >= 1) {
                t2[target--] = s2[src] << bitcount | s2[--src] >>> anticount;
            }
            t2[target--] = s2[src] << bitcount;
        }
        while (target >= 0) {
            t2[target--] = 0;
        }
        this.data = t2;
        this.nWords += wordcount + 1;
        while (this.nWords > 1 && this.data[this.nWords - 1] == 0) {
            --this.nWords;
        }
    }

    int normalizeMe() throws IllegalArgumentException {
        int src;
        int wordcount = 0;
        int bitcount = 0;
        int v2 = 0;
        for (src = this.nWords - 1; src >= 0 && (v2 = this.data[src]) == 0; --src) {
            ++wordcount;
        }
        if (src < 0) {
            throw new IllegalArgumentException("zero value");
        }
        this.nWords -= wordcount;
        if ((v2 & 0xF0000000) != 0) {
            bitcount = 32;
            while ((v2 & 0xF0000000) != 0) {
                v2 >>>= 1;
                --bitcount;
            }
        } else {
            while (v2 <= 1048575) {
                v2 <<= 8;
                bitcount += 8;
            }
            while (v2 <= 0x7FFFFFF) {
                v2 <<= 1;
                ++bitcount;
            }
        }
        if (bitcount != 0) {
            this.lshiftMe(bitcount);
        }
        return bitcount;
    }

    FDBigInt mult(int iv) {
        long v2 = iv;
        int[] r2 = new int[v2 * ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) > 0xFFFFFFFL ? this.nWords + 1 : this.nWords];
        long p2 = 0L;
        for (int i2 = 0; i2 < this.nWords; ++i2) {
            r2[i2] = (int)(p2 += v2 * ((long)this.data[i2] & 0xFFFFFFFFL));
            p2 >>>= 32;
        }
        if (p2 == 0L) {
            return new FDBigInt(r2, this.nWords);
        }
        r2[this.nWords] = (int)p2;
        return new FDBigInt(r2, this.nWords + 1);
    }

    FDBigInt mult(FDBigInt other) {
        int i2;
        int[] r2 = new int[this.nWords + other.nWords];
        for (i2 = 0; i2 < this.nWords; ++i2) {
            long v2 = (long)this.data[i2] & 0xFFFFFFFFL;
            long p2 = 0L;
            for (int j2 = 0; j2 < other.nWords; ++j2) {
                r2[i2 + j2] = (int)(p2 += ((long)r2[i2 + j2] & 0xFFFFFFFFL) + v2 * ((long)other.data[j2] & 0xFFFFFFFFL));
                p2 >>>= 32;
            }
            r2[i2 + j2] = (int)p2;
        }
        for (i2 = r2.length - 1; i2 > 0 && r2[i2] == 0; --i2) {
        }
        return new FDBigInt(r2, i2 + 1);
    }

    FDBigInt add(FDBigInt other) {
        int i2;
        int m2;
        int[] b2;
        int n2;
        int[] a2;
        long c2 = 0L;
        if (this.nWords >= other.nWords) {
            a2 = this.data;
            n2 = this.nWords;
            b2 = other.data;
            m2 = other.nWords;
        } else {
            a2 = other.data;
            n2 = other.nWords;
            b2 = this.data;
            m2 = this.nWords;
        }
        int[] r2 = new int[n2];
        for (i2 = 0; i2 < n2; ++i2) {
            c2 += (long)a2[i2] & 0xFFFFFFFFL;
            if (i2 < m2) {
                c2 += (long)b2[i2] & 0xFFFFFFFFL;
            }
            r2[i2] = (int)c2;
            c2 >>= 32;
        }
        if (c2 != 0L) {
            int[] s2 = new int[r2.length + 1];
            System.arraycopy(r2, 0, s2, 0, r2.length);
            s2[i2++] = (int)c2;
            return new FDBigInt(s2, i2);
        }
        return new FDBigInt(r2, i2);
    }

    int cmp(FDBigInt other) {
        int i2;
        int j2;
        if (this.nWords > other.nWords) {
            j2 = other.nWords - 1;
            for (i2 = this.nWords - 1; i2 > j2; --i2) {
                if (this.data[i2] == 0) continue;
                return 1;
            }
        } else if (this.nWords < other.nWords) {
            j2 = this.nWords - 1;
            for (i2 = other.nWords - 1; i2 > j2; --i2) {
                if (other.data[i2] == 0) continue;
                return -1;
            }
        } else {
            i2 = this.nWords - 1;
        }
        while (i2 > 0 && this.data[i2] == other.data[i2]) {
            --i2;
        }
        int a2 = this.data[i2];
        int b2 = other.data[i2];
        if (a2 < 0) {
            if (b2 < 0) {
                return a2 - b2;
            }
            return 1;
        }
        if (b2 < 0) {
            return -1;
        }
        return a2 - b2;
    }

    int quoRemIteration(FDBigInt S) throws IllegalArgumentException {
        int i2;
        if (this.nWords != S.nWords) {
            throw new IllegalArgumentException("disparate values");
        }
        int n2 = this.nWords - 1;
        long q2 = ((long)this.data[n2] & 0xFFFFFFFFL) / (long)S.data[n2];
        long diff = 0L;
        for (int i3 = 0; i3 <= n2; ++i3) {
            this.data[i3] = (int)(diff += ((long)this.data[i3] & 0xFFFFFFFFL) - q2 * ((long)S.data[i3] & 0xFFFFFFFFL));
            diff >>= 32;
        }
        if (diff != 0L) {
            long sum = 0L;
            while (sum == 0L) {
                sum = 0L;
                for (i2 = 0; i2 <= n2; ++i2) {
                    this.data[i2] = (int)(sum += ((long)this.data[i2] & 0xFFFFFFFFL) + ((long)S.data[i2] & 0xFFFFFFFFL));
                    sum >>= 32;
                }
                if (sum != 0L && sum != 1L) {
                    throw new RuntimeException("Assertion botch: " + sum + " carry out of division correction");
                }
                --q2;
            }
        }
        long p2 = 0L;
        for (i2 = 0; i2 <= n2; ++i2) {
            this.data[i2] = (int)(p2 += 10L * ((long)this.data[i2] & 0xFFFFFFFFL));
            p2 >>= 32;
        }
        if (p2 != 0L) {
            throw new RuntimeException("Assertion botch: carry out of *10");
        }
        return (int)q2;
    }

    static {
        try {
            $$$methodRef$$$10 = FDBigInt.class.getDeclaredConstructor(int[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = FDBigInt.class.getDeclaredConstructor(FDBigInt.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = FDBigInt.class.getDeclaredConstructor(Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = FDBigInt.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = FDBigInt.class.getDeclaredMethod("quoRemIteration", FDBigInt.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = FDBigInt.class.getDeclaredMethod("cmp", FDBigInt.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = FDBigInt.class.getDeclaredMethod("add", FDBigInt.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = FDBigInt.class.getDeclaredMethod("mult", FDBigInt.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = FDBigInt.class.getDeclaredMethod("mult", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = FDBigInt.class.getDeclaredMethod("normalizeMe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = FDBigInt.class.getDeclaredMethod("lshiftMe", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

