/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNQueryChanges
implements QueryChangeDescription {
    private final long queryId;
    private final QueryChangeDescription.QueryChangeEventType queryopflags;
    private final int numberOfTables;
    private final NTFDCNTableChanges[] tcdesc;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NTFDCNQueryChanges(ByteBuffer data, int csid) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$3, null, data, csid);
            }
            long queryId1 = data.getInt() & 0xFFFFFFFF;
            long queryId2 = data.getInt() & 0xFFFFFFFF;
            this.queryId = queryId1 | queryId2 << 32;
            this.queryopflags = QueryChangeDescription.QueryChangeEventType.getQueryChangeEventType(data.getInt());
            this.numberOfTables = data.getShort();
            this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
            for (int j2 = 0; j2 < this.tcdesc.length; ++j2) {
                this.tcdesc[j2] = new NTFDCNTableChanges(data, csid);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getQueryId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$0, this, new Object[0]);
            }
            long l2 = this.queryId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$0, this, l2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$0, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public QueryChangeDescription.QueryChangeEventType getQueryChangeEventType() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$1, this, new Object[0]);
            }
            QueryChangeDescription.QueryChangeEventType queryChangeEventType = this.queryopflags;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$1, this, (Object)queryChangeEventType);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$1, this, null);
            }
            return queryChangeEventType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$2, this, new Object[0]);
            }
            TableChangeDescription[] tableChangeDescriptionArray = this.tcdesc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$2, this, tableChangeDescriptionArray);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$2, this, null);
            }
            return this.tcdesc;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFDCNQueryChanges.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  query ID=" + this.queryId + ", query change event type=" + (Object)((Object)this.queryopflags) + "\n");
        TableChangeDescription[] rdesc = this.getTableChangeDescription();
        if (rdesc != null) {
            sb.append("  Table Change Description (length=" + rdesc.length + "):");
            for (int i2 = 0; i2 < rdesc.length; ++i2) {
                sb.append(rdesc[i2].toString());
            }
        }
        return sb.toString();
    }

    static {
        try {
            $$$methodRef$$$3 = NTFDCNQueryChanges.class.getDeclaredConstructor(ByteBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNQueryChanges.class.getDeclaredMethod("getTableChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNQueryChanges.class.getDeclaredMethod("getQueryChangeEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNQueryChanges.class.getDeclaredMethod("getQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

