/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ResultSetAccessor
extends Accessor {
    static final int MAXLENGTH = 16;
    OracleStatement currentStmt;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    ResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.RESULT_SET, stmt, 16, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$2, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 102, 116, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    ResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.RESULT_SET, stmt, 16, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$3, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 102, 116, form, false);
            this.initForDescribe(102, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ResultSet getCursor(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$0, this, n2);
            }
            OracleResultSet rset = null;
            if (this.currentStmt != null && this.currentStmt.refCursorRowNumber == currentRow && !this.currentStmt.isClosed()) {
                rset = this.currentStmt.createResultSet();
            } else {
                byte[] bytes = this.getBytes((int)currentRow);
                OracleStatement newstmt = this.statement.connection.RefCursorBytesToStatement(bytes, this.statement);
                newstmt.refCursorRowNumber = currentRow;
                newstmt.doDescribe(false);
                if (newstmt.numberOfDefinePositions > 0) {
                    newstmt.prepareAccessors();
                }
                newstmt.setPrefetchInternal(this.statement.getFetchSize(), false, false);
                newstmt.closeOnCompletion();
                newstmt.currentResultSet = rset = newstmt.createResultSet();
                this.currentStmt = newstmt;
            }
            OracleResultSet oracleResultSet = rset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$0, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$0, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$1, this, n2);
            }
            ResultSet resultSet = this.getCursor((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$1, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$1, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ResultSetAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = ResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetAccessor.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

