/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.io.LuaBinOutput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b9R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lorg/luaj/vm2/compiler/DumpState;", "", "w", "Lorg/luaj/vm2/io/LuaBinOutput;", "strip", "", "(Lorg/luaj/vm2/io/LuaBinOutput;Z)V", "IS_LITTLE_ENDIAN", "NUMBER_FORMAT", "", "SIZEOF_LUA_NUMBER", "status", "getStatus$luak", "()I", "setStatus$luak", "(I)V", "getStrip$luak", "()Z", "setStrip$luak", "(Z)V", "writer", "getWriter$luak", "()Lorg/luaj/vm2/io/LuaBinOutput;", "setWriter$luak", "(Lorg/luaj/vm2/io/LuaBinOutput;)V", "dumpBlock", "", "b", "", "size", "dumpBlock$luak", "dumpChar", "dumpChar$luak", "dumpCode", "f", "Lorg/luaj/vm2/Prototype;", "dumpCode$luak", "dumpConstants", "dumpConstants$luak", "dumpDebug", "dumpDebug$luak", "dumpDouble", "d", "", "dumpDouble$luak", "dumpFunction", "dumpFunction$luak", "dumpHeader", "dumpHeader$luak", "dumpInt", "x", "dumpInt$luak", "dumpString", "s", "Lorg/luaj/vm2/LuaString;", "dumpString$luak", "dumpUpvalues", "dumpUpvalues$luak", "Companion", "luak"})
public final class DumpState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean strip;
    private boolean IS_LITTLE_ENDIAN;
    private int NUMBER_FORMAT;
    private int SIZEOF_LUA_NUMBER;
    @NotNull
    private LuaBinOutput writer;
    private int status;
    @JvmField
    public static boolean ALLOW_INTEGER_CASTING;
    @JvmField
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES;
    @JvmField
    public static final int NUMBER_FORMAT_INTS_ONLY;
    @JvmField
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32;
    @JvmField
    public static final int NUMBER_FORMAT_DEFAULT;
    private static final int SIZEOF_INT;
    private static final int SIZEOF_SIZET;
    private static final int SIZEOF_INSTRUCTION;

    public DumpState(@NotNull LuaBinOutput w, boolean strip) {
        Intrinsics.checkNotNullParameter(w, "w");
        this.strip = strip;
        this.NUMBER_FORMAT = NUMBER_FORMAT_DEFAULT;
        this.SIZEOF_LUA_NUMBER = 8;
        this.writer = w;
    }

    public final boolean getStrip$luak() {
        return this.strip;
    }

    public final void setStrip$luak(boolean bl) {
        this.strip = bl;
    }

    @NotNull
    public final LuaBinOutput getWriter$luak() {
        return this.writer;
    }

    public final void setWriter$luak(@NotNull LuaBinOutput luaBinOutput) {
        Intrinsics.checkNotNullParameter(luaBinOutput, "<set-?>");
        this.writer = luaBinOutput;
    }

    public final int getStatus$luak() {
        return this.status;
    }

    public final void setStatus$luak(int n) {
        this.status = n;
    }

    public final void dumpBlock$luak(@NotNull byte[] b, int size2) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.writer.write(b, 0, size2);
    }

    public final void dumpChar$luak(int b) {
        this.writer.write(b);
    }

    public final void dumpInt$luak(int x) {
        if (this.IS_LITTLE_ENDIAN) {
            this.writer.writeByte(x & 0xFF);
            this.writer.writeByte(x >> 8 & 0xFF);
            this.writer.writeByte(x >> 16 & 0xFF);
            this.writer.writeByte(x >> 24 & 0xFF);
        } else {
            this.writer.writeInt(x);
        }
    }

    public final void dumpString$luak(@NotNull LuaString s) {
        Intrinsics.checkNotNullParameter(s, "s");
        int len = s.len().toint();
        this.dumpInt$luak(len + 1);
        s.write(this.writer, 0, len);
        this.writer.write(0);
    }

    public final void dumpDouble$luak(double d) {
        long l = Double.doubleToRawLongBits(d);
        if (this.IS_LITTLE_ENDIAN) {
            this.dumpInt$luak((int)l);
            this.dumpInt$luak((int)(l >> 32));
        } else {
            this.writer.writeLong(l);
        }
    }

    public final void dumpCode$luak(@NotNull Prototype f) {
        Intrinsics.checkNotNullParameter(f, "f");
        int[] code = f.code;
        int n = code.length;
        this.dumpInt$luak(n);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            this.dumpInt$luak(code[i]);
        }
    }

    public final void dumpConstants$luak(@NotNull Prototype f) {
        Intrinsics.checkNotNullParameter(f, "f");
        LuaValue[] k = f.k;
        int i = 0;
        int n = k.length;
        this.dumpInt$luak(n);
        i = 0;
        while (i < n) {
            LuaValue o = k[i];
            switch (o.type()) {
                case 0: {
                    this.writer.write(0);
                    break;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar$luak(o.toboolean() ? 1 : 0);
                    break;
                }
                case 3: {
                    int n2 = this.NUMBER_FORMAT;
                    if (n2 == NUMBER_FORMAT_FLOATS_OR_DOUBLES) {
                        this.writer.write(3);
                        this.dumpDouble$luak(o.todouble());
                        break;
                    }
                    if (n2 == NUMBER_FORMAT_INTS_ONLY) {
                        if (!ALLOW_INTEGER_CASTING && !o.isint()) {
                            throw new IllegalArgumentException(Intrinsics.stringPlus("not an integer: ", o));
                        }
                        this.writer.write(3);
                        this.dumpInt$luak(o.toint());
                        break;
                    }
                    if (n2 == NUMBER_FORMAT_NUM_PATCH_INT32) {
                        if (o.isint()) {
                            this.writer.write(-2);
                            this.dumpInt$luak(o.toint());
                            break;
                        }
                        this.writer.write(3);
                        this.dumpDouble$luak(o.todouble());
                        break;
                    }
                    throw new IllegalArgumentException(Intrinsics.stringPlus("number format not supported: ", this.NUMBER_FORMAT));
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString$luak((LuaString)o);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("bad type for ", o));
                }
            }
            int n3 = i;
            i = n3 + 1;
        }
        n = f.p.length;
        this.dumpInt$luak(n);
        i = 0;
        while (i < n) {
            this.dumpFunction$luak(f.p[i]);
            int n4 = i;
            i = n4 + 1;
        }
    }

    public final void dumpUpvalues$luak(@NotNull Prototype f) {
        Intrinsics.checkNotNullParameter(f, "f");
        int n = f.upvalues.length;
        this.dumpInt$luak(n);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            this.writer.writeByte(f.upvalues[i].instack ? 1 : 0);
            this.writer.writeByte(f.upvalues[i].idx);
        }
    }

    public final void dumpDebug$luak(@NotNull Prototype f) {
        Intrinsics.checkNotNullParameter(f, "f");
        if (this.strip) {
            this.dumpInt$luak(0);
        } else {
            this.dumpString$luak(f.source);
        }
        int n = this.strip ? 0 : f.lineinfo.length;
        this.dumpInt$luak(n);
        int i = 0;
        while (i < n) {
            this.dumpInt$luak(f.lineinfo[i]);
            int n2 = i;
            i = n2 + 1;
        }
        n = this.strip ? 0 : f.locvars.length;
        this.dumpInt$luak(n);
        i = 0;
        while (i < n) {
            LocVars lvi = f.locvars[i];
            this.dumpString$luak(lvi.varname);
            this.dumpInt$luak(lvi.startpc);
            this.dumpInt$luak(lvi.endpc);
            int n3 = i;
            i = n3 + 1;
        }
        n = this.strip ? 0 : f.upvalues.length;
        this.dumpInt$luak(n);
        i = 0;
        while (i < n) {
            LuaString luaString = f.upvalues[i].name;
            Intrinsics.checkNotNull(luaString);
            this.dumpString$luak(luaString);
            int n4 = i;
            i = n4 + 1;
        }
    }

    public final void dumpFunction$luak(@NotNull Prototype f) {
        Intrinsics.checkNotNullParameter(f, "f");
        this.dumpInt$luak(f.linedefined);
        this.dumpInt$luak(f.lastlinedefined);
        this.dumpChar$luak(f.numparams);
        this.dumpChar$luak(f.is_vararg);
        this.dumpChar$luak(f.maxstacksize);
        this.dumpCode$luak(f);
        this.dumpConstants$luak(f);
        this.dumpUpvalues$luak(f);
        this.dumpDebug$luak(f);
    }

    public final void dumpHeader$luak() {
        this.writer.write(LoadState.LUA_SIGNATURE);
        this.writer.write(LoadState.LUAC_VERSION);
        this.writer.write(LoadState.LUAC_FORMAT);
        this.writer.write(this.IS_LITTLE_ENDIAN ? 1 : 0);
        this.writer.write(SIZEOF_INT);
        this.writer.write(SIZEOF_SIZET);
        this.writer.write(SIZEOF_INSTRUCTION);
        this.writer.write(this.SIZEOF_LUA_NUMBER);
        this.writer.write(this.NUMBER_FORMAT);
        this.writer.write(LoadState.LUAC_TAIL);
    }

    static {
        NUMBER_FORMAT_INTS_ONLY = 1;
        NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
        NUMBER_FORMAT_DEFAULT = NUMBER_FORMAT_FLOATS_OR_DOUBLES;
        SIZEOF_INT = 4;
        SIZEOF_SIZET = 4;
        SIZEOF_INSTRUCTION = 4;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J.\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/luaj/vm2/compiler/DumpState$Companion;", "", "()V", "ALLOW_INTEGER_CASTING", "", "NUMBER_FORMAT_DEFAULT", "", "NUMBER_FORMAT_FLOATS_OR_DOUBLES", "NUMBER_FORMAT_INTS_ONLY", "NUMBER_FORMAT_NUM_PATCH_INT32", "SIZEOF_INSTRUCTION", "SIZEOF_INT", "SIZEOF_SIZET", "dump", "f", "Lorg/luaj/vm2/Prototype;", "w", "Lorg/luaj/vm2/io/LuaBinOutput;", "strip", "stripDebug", "numberFormat", "littleendian", "luak"})
    public static final class Companion {
        private Companion() {
        }

        public final int dump(@NotNull Prototype f, @NotNull LuaBinOutput w, boolean strip) {
            Intrinsics.checkNotNullParameter(f, "f");
            Intrinsics.checkNotNullParameter(w, "w");
            DumpState D = new DumpState(w, strip);
            D.dumpHeader$luak();
            D.dumpFunction$luak(f);
            return D.getStatus$luak();
        }

        public final int dump(@NotNull Prototype f, @NotNull LuaBinOutput w, boolean stripDebug, int numberFormat, boolean littleendian) {
            Intrinsics.checkNotNullParameter(f, "f");
            Intrinsics.checkNotNullParameter(w, "w");
            int n = numberFormat;
            if (!((n == NUMBER_FORMAT_FLOATS_OR_DOUBLES ? true : n == NUMBER_FORMAT_INTS_ONLY) ? true : n == NUMBER_FORMAT_NUM_PATCH_INT32)) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("number format not supported: ", numberFormat));
            }
            DumpState D = new DumpState(w, stripDebug);
            D.IS_LITTLE_ENDIAN = littleendian;
            D.NUMBER_FORMAT = numberFormat;
            D.SIZEOF_LUA_NUMBER = numberFormat == NUMBER_FORMAT_INTS_ONLY ? 4 : 8;
            D.dumpHeader$luak();
            D.dumpFunction$luak(f);
            return D.getStatus$luak();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

