/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gephi.appearance.PartitionImpl;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;

public class EdgeTypePartitionImpl
extends PartitionImpl {
    private final Class valueType;
    private final Column column;

    public EdgeTypePartitionImpl(Column column, Class valueType) {
        this.valueType = valueType;
        this.column = column;
    }

    @Override
    public Collection getValues(Graph graph) {
        int[] types = graph.getModel().getEdgeTypes();
        return Arrays.stream(types).filter(t -> graph.getEdgeCount(t) > 0).mapToObj(t -> graph.getModel().getEdgeTypeLabel(t)).collect(Collectors.toList());
    }

    @Override
    public Object getValue(Element element, Graph gr) {
        return ((Edge)element).getTypeLabel();
    }

    @Override
    public int getElementCount(Graph graph) {
        return graph.getEdgeCount();
    }

    @Override
    public int count(Object value, Graph graph) {
        return this.getIndex(graph).count(this.column, value);
    }

    @Override
    public float percentage(Object value, Graph graph) {
        Index<Edge> index = this.getIndex(graph);
        int count = index.count(this.column, value);
        return 100.0f * ((float)count / (float)index.countElements(this.column));
    }

    @Override
    public int size(Graph graph) {
        return this.getIndex(graph).countValues(this.column);
    }

    private Index<Edge> getIndex(Graph graph) {
        return graph.getModel().getEdgeIndex(graph.getView());
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public Class getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isValid(Graph graph) {
        return graph.getModel().isMultiGraph();
    }

    @Override
    public int getVersion(Graph graph) {
        if (this.isValid(graph)) {
            return this.getIndex(graph).getColumnIndex(this.column).getVersion();
        }
        return 0;
    }
}

