/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.signing;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.auth.signing.AwsSigningResult;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;

public class AwsSigner {
    public static CompletableFuture<HttpRequest> signRequest(HttpRequest request, AwsSigningConfig config) {
        CompletableFuture<HttpRequest> future = new CompletableFuture<HttpRequest>();
        CompletableFuture<AwsSigningResult> result = AwsSigner.sign(request, config);
        result.whenComplete((res, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(res.getSignedRequest());
            }
        });
        return future;
    }

    public static CompletableFuture<byte[]> signChunk(HttpRequestBodyStream chunkBody, byte[] previousSignature, AwsSigningConfig config) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        CompletableFuture<AwsSigningResult> result = AwsSigner.sign(chunkBody, previousSignature, config);
        result.whenComplete((res, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(res.getSignature());
            }
        });
        return future;
    }

    public static CompletableFuture<AwsSigningResult> sign(HttpRequest request, AwsSigningConfig config) {
        CompletableFuture<AwsSigningResult> future = new CompletableFuture<AwsSigningResult>();
        try {
            AwsSigner.awsSignerSignRequest(request, request.marshalForJni(), config, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public static CompletableFuture<AwsSigningResult> sign(HttpRequestBodyStream chunkBody, byte[] previousSignature, AwsSigningConfig config) {
        CompletableFuture<AwsSigningResult> future = new CompletableFuture<AwsSigningResult>();
        try {
            AwsSigner.awsSignerSignChunk(chunkBody, previousSignature, config, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public static CompletableFuture<AwsSigningResult> sign(List<HttpHeader> headers, byte[] previousSignature, AwsSigningConfig config) {
        CompletableFuture<AwsSigningResult> future = new CompletableFuture<AwsSigningResult>();
        try {
            AwsSigner.awsSignerSignTrailingHeaders(HttpHeader.marshalHeadersForJni(headers), previousSignature, config, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static native void awsSignerSignRequest(HttpRequest var0, byte[] var1, AwsSigningConfig var2, CompletableFuture<AwsSigningResult> var3) throws CrtRuntimeException;

    private static native void awsSignerSignChunk(HttpRequestBodyStream var0, byte[] var1, AwsSigningConfig var2, CompletableFuture<AwsSigningResult> var3) throws CrtRuntimeException;

    private static native void awsSignerSignTrailingHeaders(byte[] var0, byte[] var1, AwsSigningConfig var2, CompletableFuture<AwsSigningResult> var3) throws CrtRuntimeException;
}

