/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.HashMap;
import java.util.Map;

public enum TlsSignatureAlgorithm {
    UNKNOWN(0),
    RSA(1),
    ECDSA(2);

    int nativeValue;
    static Map<Integer, TlsSignatureAlgorithm> enumMapping;

    static Map<Integer, TlsSignatureAlgorithm> buildEnumMapping() {
        HashMap<Integer, TlsSignatureAlgorithm> enumMapping = new HashMap<Integer, TlsSignatureAlgorithm>();
        for (TlsSignatureAlgorithm i : TlsSignatureAlgorithm.values()) {
            enumMapping.put(i.nativeValue, i);
        }
        return enumMapping;
    }

    public static TlsSignatureAlgorithm getEnumValueFromInteger(int value) {
        TlsSignatureAlgorithm enumValue = enumMapping.get(value);
        if (enumValue != null) {
            return enumValue;
        }
        throw new RuntimeException("Illegal TlsKeyOperation.TlsSignatureAlgorithm");
    }

    private TlsSignatureAlgorithm(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getNativeValue() {
        return this.nativeValue;
    }

    static {
        enumMapping = TlsSignatureAlgorithm.buildEnumMapping();
    }
}

