/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.view;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.view.ViewService;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@ExperimentalApi
public class ListViewNamesAction
extends ActionType<Response> {
    public static final ListViewNamesAction INSTANCE = new ListViewNamesAction();
    public static final String NAME = "views:data/read/list";

    public ListViewNamesAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final ViewService viewService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, ViewService viewService) {
            super(ListViewNamesAction.NAME, transportService, actionFilters, Request::new);
            this.viewService = viewService;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            this.viewService.listViewNames(listener);
        }
    }

    @ExperimentalApi
    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<String> views;

        public Response(List<String> views) {
            this.views = views;
        }

        public Response(StreamInput in) throws IOException {
            this.views = in.readStringList();
        }

        public List<String> getViewNames() {
            return this.views;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.views.equals(that.views);
        }

        public int hashCode() {
            return Objects.hash(this.views);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.views);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("views", this.views);
            builder.endObject();
            return builder;
        }
    }

    @ExperimentalApi
    public static class Request
    extends ActionRequest {
        public Request() {
        }

        public Request(StreamInput in) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return true;
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

