# (c) Copyright 2011-2013. CodeWeavers, Inc.

from gi.repository import Gtk

try:
    # pylint: disable=E1101
    _GTKINFOBAR = Gtk.InfoBar
except AttributeError:
    _GTKINFOBAR = None

def _do_nothing(_widget, _response_id):
    pass

# An evil horizontal and less version-sensitive infobar.
class InfoBar(Gtk.HBox):
    __gtype_name__ = 'InfoBar'

    def __init__(self):
        Gtk.HBox.__init__(self)

        if _GTKINFOBAR:
            # pylint: disable=E1101
            self._child = Gtk.InfoBar()
            self._child.show()
            self.add(self._child)
            self._content_area = self._child.get_content_area()

            self._action_area = Gtk.HBox()
            self._action_area.show()
            self._action_area.set_spacing(6)
            self._child.get_action_area().add(self._action_area)
        else:
            self.set_spacing(12)

            self._content_area = Gtk.HBox()
            self._content_area.show()
            self._content_area.set_spacing(6)
            self.add(self._content_area)

            self._action_area = Gtk.HBox()
            self._action_area.show()
            self._action_area.set_spacing(6)
            self.add(self._action_area)
            self.set_child_packing(self._action_area, False, False, 0, Gtk.PackType.END)

        self.response_callback = _do_nothing
        self._message_type = Gtk.MessageType.INFO

    def set_message_type(self, message_type):
        self._message_type = message_type
        if _GTKINFOBAR:
            self._child.set_message_type(message_type)

    def get_content_area(self):
        return self._content_area

    def response(self, response_id):
        self.response_callback(self, response_id)

    def _activated(self, _widget, response_id):
        self.response(response_id)

    def add_action_widget(self, widget, response_id):
        widget.connect('clicked', self._activated, response_id)
        self._action_area.add(widget)

    def add_button(self, button_text, response_id):
        button = Gtk.Button(label=button_text)

        button.show()

        self.add_action_widget(button, response_id)

        return button

    def _clear_box(self, box):
        for child in box.get_children():
            box.remove(child)

    def clear(self):
        self._clear_box(self._content_area)
        self._clear_box(self._action_area)
