/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details:
 *
 * Copyright (C) 2019 James Wah
 * Copyright (C) 2020 Marinus Enzinger <marinus@enzingerm.de>
 * Copyright (C) 2023 Shane Parslow
 * Copyright (C) 2024 Thomas Vogt
 */

#ifndef MM_PORT_SERIAL_XMMRPC_XMM7360_H
#define MM_PORT_SERIAL_XMMRPC_XMM7360_H

#include <glib.h>
#include <glib-object.h>

#include "mm-port-serial.h"

typedef enum {
    XMM7360_RPC_CALL_UTA_MS_SIM_OPEN_REQ = 0x001,
    XMM7360_RPC_CALL_UTA_MS_SIM_APDU_CMD_REQ = 0x002,
    XMM7360_RPC_CALL_UTA_MS_SIM_APPLICATION_REQ = 0x004,
    XMM7360_RPC_CALL_UTA_MS_SIM_DECODE_FCP = 0x006,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_READ_ENTRY_REQ = 0x00d,
    XMM7360_RPC_CALL_UTA_MS_SIM_GEN_PIN_REQ = 0x00f,
    XMM7360_RPC_CALL_UTA_MS_SIM_MODIFY_LOCK_REQ = 0x011,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_PROACTIVE_COMMAND_RSP = 0x016,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_ENVELOPE_COMMAND_REQ = 0x017,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_TERMINAL_PROFILE_READ_REQ = 0x019,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_REGISTER_HANDLER = 0x01c,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_DEREGISTER_HANDLER = 0x01d,
    XMM7360_RPC_CALL_UTA_MS_CPS_SET_MODE_REQ = 0x01f,
    XMM7360_RPC_CALL_UTA_MS_CPS_SET_STACK_MODE_CONFIGURATION = 0x020,
    XMM7360_RPC_CALL_UTA_MS_CPS_SET_SIM_MODE_CONFIGURATION = 0x021,
    XMM7360_RPC_CALL_UTA_MS_CPS_READ_IMEI = 0x023,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_INIT = 0x024,
    XMM7360_RPC_CALL_UTA_MS_CBS_INIT = 0x025,
    XMM7360_RPC_CALL_UTA_MS_SS_INIT = 0x026,
    XMM7360_RPC_CALL_UTA_MS_SS_SEND_USSD_REQ = 0x027,
    XMM7360_RPC_CALL_UTA_MS_SS_RESPOND_USSD = 0x028,
    XMM7360_RPC_CALL_UTA_MS_SS_ABORT = 0x029,
    XMM7360_RPC_CALL_UTA_MS_SMS_INIT = 0x030,
    XMM7360_RPC_CALL_UTA_MS_SMS_SEND_REQ = 0x031,
    XMM7360_RPC_CALL_UTA_MS_SMS_SET_MEMORY_AVAILABLE_REQ = 0x034,
    XMM7360_RPC_CALL_UTA_MS_SMS_INCOMING_SMS_ACK = 0x036,
    XMM7360_RPC_CALL_UTA_MS_SMS_SIM_MSG_COUNT_REQ = 0x038,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_INITIALIZE = 0x03a,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_OBTAIN_PDP_CONTEXT_ID = 0x03b,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_RELEASE_PDP_CONTEXT_ID = 0x03c,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_DEFINE_PRIMARY_REQ = 0x03d,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_UNDEFINE_PRIMARY_REQ = 0x03f,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_PRIMARY_REQ = 0x041,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_SET_AUTHENTICATION_REQ = 0x043,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_SET_DNS_REQ = 0x045,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_NEGOTIATED_DNS_REQ = 0x047,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_NEG_IP_ADDR_REQ = 0x049,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_ACTIVATE_REQ = 0x04b,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_DEACTIVATE_REQ = 0x04e,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_CONNECT_REQ = 0x051,
    XMM7360_RPC_CALL_UTA_MS_NET_OPEN = 0x053,
    XMM7360_RPC_CALL_UTA_MS_NET_SET_RADIO_SIGNAL_REPORTING = 0x054,
    XMM7360_RPC_CALL_UTA_MS_NET_SINGLE_SHOT_RADIO_SIGNAL_REPORTING_REQ = 0x055,
    XMM7360_RPC_CALL_UTA_MS_NET_ATTACH_REQ = 0x05c,
    XMM7360_RPC_CALL_UTA_MS_NET_PS_ATTACH_REQ = 0x05d,
    XMM7360_RPC_CALL_UTA_MS_NET_PS_DETACH_REQ = 0x05e,
    XMM7360_RPC_CALL_UTA_MS_NET_SCAN_REQ = 0x05f,
    XMM7360_RPC_CALL_UTA_MS_NET_SCAN_ABORT = 0x060,
    XMM7360_RPC_CALL_UTA_MS_NET_POWER_DOWN_REQ = 0x061,
    XMM7360_RPC_CALL_UTA_MS_NET_EXT_SCAN_REQ = 0x062,
    XMM7360_RPC_CALL_UTA_MS_NET_SET_FD_CONFIG_REQ = 0x06e,
    XMM7360_RPC_CALL_UTA_MS_NET_GET_FD_CONFIG_REQ = 0x071,
    XMM7360_RPC_CALL_UTA_MS_NET_CONFIGURE_NETWORK_MODE_REQ = 0x073,
    XMM7360_RPC_CALL_UTA_MS_NET_RAT_MODE_STATUS_REQ = 0x076,
    XMM7360_RPC_CALL_UTA_NVM_READ = 0x079,
    XMM7360_RPC_CALL_UTA_NVM_WRITE = 0x07a,
    XMM7360_RPC_CALL_UTA_NVM_WRITE_COMMIT = 0x07b,
    XMM7360_RPC_CALL_UTA_SYS_GET_INFO = 0x07c,
    XMM7360_RPC_CALL_UTA_RPC_PS_CONNECT_SETUP_REQ = 0x07d,
    XMM7360_RPC_CALL_UTA_RPC_PS_CONNECT_TO_DATACHANNEL_REQ = 0x07e,
    XMM7360_RPC_CALL_UTA_RPC_PS_CONNECT_RELEASE_REQ = 0x07f,
    XMM7360_RPC_CALL_UTA_MS_NET_DC_SET_VOICE_DOMAIN_PREFERENCE_CONFIG_REQ = 0x080,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_SETUP_VOICE_CALL_REQ = 0x082,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_RELEASE_CALL_REQ = 0x088,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_ACCEPT_CALL_REQ = 0x08d,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_SWAP_CALLS_REQ = 0x090,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_HOLD_CALL_REQ = 0x092,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_RETRIEVE_CALL_REQ = 0x094,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_SPLIT_MPTY_REQ = 0x096,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_JOIN_CALLS_REQ = 0x098,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_TRANSFER_CALLS_REQ = 0x09a,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_START_DTMF_REQ = 0x09c,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_STOP_DTMF_REQ = 0x09e,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_SET_UUS1_INFO = 0x0a6,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_SET_TTY_DEVICE_MODE = 0x0a7,
    XMM7360_RPC_CALL_UTA_MS_CALL_CS_GET_TTY_DEVICE_MODE = 0x0a8,
    XMM7360_RPC_CALL_UTA_MS_CALL_MULTIMEDIA_SETUP_CALL_REQ = 0x0ac,
    XMM7360_RPC_CALL_UTA_MS_CALL_MULTIMEDIA_UPDATE_CALL_REQ = 0x0ad,
    XMM7360_RPC_CALL_UTA_MS_CPS_SET_SIM_MODE_REQ = 0x0b0,
    XMM7360_RPC_CALL_UTA_MS_SS_CALL_FORWARD_REQ = 0x0b2,
    XMM7360_RPC_CALL_UTA_MS_SS_CALL_WAITING_REQ = 0x0b4,
    XMM7360_RPC_CALL_UTA_MS_SS_CALL_BARRING_REQ = 0x0b6,
    XMM7360_RPC_CALL_UTA_MS_SS_IDENTIFICATION_REQ = 0x0b8,
    XMM7360_RPC_CALL_UTA_MS_SMS_SET_SEND_MORE_MESSAGES_STATUS = 0x0ba,
    XMM7360_RPC_CALL_UTA_MS_SMS_DATA_DOWNLOAD_REQ = 0x0bb,
    XMM7360_RPC_CALL_UTA_MS_SMS_DATA_DOWNLOAD_ACK = 0x0bd,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_NEG_QOS_REQ = 0x0be,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_TFT_REQ = 0x0c0,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_SET_PCO_REQ = 0x0c2,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_GET_NW_PCO_REQ = 0x0c4,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_NW_ACTIVATE_ACCEPT_REQ = 0x0c7,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_NW_ACTIVATE_REJECT_REQ = 0x0c9,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_SET_DATA_PREF_REQ = 0x0cd,
    XMM7360_RPC_CALL_UTA_MS_CBS_START_REQ = 0x0cf,
    XMM7360_RPC_CALL_UTA_MS_CBS_STOP_REQ = 0x0d0,
    XMM7360_RPC_CALL_UTA_MS_CBS_SET_MSG_FILTER = 0x0d3,
    XMM7360_RPC_CALL_UTA_MS_CBS_GET_MSG_FILTER = 0x0d4,
    XMM7360_RPC_CALL_UTA_MS_CBS_ETWS_CONFIG_REQ = 0x0d6,
    XMM7360_RPC_CALL_UTA_MS_CBS_ETWS_START_REQ = 0x0d8,
    XMM7360_RPC_CALL_UTA_MS_CBS_ETWS_STOP_REQ = 0x0da,
    XMM7360_RPC_CALL_UTA_MS_CPS_NVM_WRITE = 0x0de,
    XMM7360_RPC_CALL_UTA_MS_CPS_NVM_READ = 0x0df,
    XMM7360_RPC_CALL_UTA_MS_NET_CONFIGURE_RX_DIVERSITY_DARP = 0x0e0,
    XMM7360_RPC_CALL_UTA_MS_NET_LDR_GET_APN_PARAMETER_LIST = 0x0e2,
    XMM7360_RPC_CALL_UTA_MS_NET_TIME_INFO_READ_REQ = 0x0e3,
    XMM7360_RPC_CALL_UTA_MS_NET_SET_CSG_CONFIG_REQ = 0x0e6,
    XMM7360_RPC_CALL_UTA_MS_NET_BAND_STATUS_REQ = 0x0e7,
    XMM7360_RPC_CALL_UTA_MS_NET_GET_EXTENDED_RADIO_SIGNAL_INFO_REQ = 0x0ec,
    XMM7360_RPC_CALL_UTA_MS_NET_DETACH_REQ = 0x0ef,
    XMM7360_RPC_CALL_UTA_MS_NET_SELECT_GPRS_CLASS_REQ = 0x0f1,
    XMM7360_RPC_CALL_UTA_MS_NET_GET_CSG_CONFIG_REQ = 0x0f3,
    XMM7360_RPC_CALL_UTA_MS_NET_CS_SERVICE_NOTIFICATION_ACCEPT = 0x0f4,
    XMM7360_RPC_CALL_UTA_MS_NET_SINGLE_SHOT_FD_REQ = 0x0f9,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_LOCATION_REQ = 0x0fb,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_READ_GAS_ENTRY_REQ = 0x0fd,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_WRITE_ENTRY_REQ = 0x0ff,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_GET_META_INFORMATION_REQ = 0x101,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_USIM_PB_SELECT_REQ = 0x103,
    XMM7360_RPC_CALL_UTA_MS_SIM_PB_GET_FREE_RECORDS_REQ = 0x105,
    XMM7360_RPC_CALL_UTA_MS_SIM_CREATE_READ_BINARY_APDU = 0x10a,
    XMM7360_RPC_CALL_UTA_MS_SIM_CREATE_UPDATE_BINARY_APDU = 0x10b,
    XMM7360_RPC_CALL_UTA_MS_SIM_ANALYSE_READ_RESULT = 0x10c,
    XMM7360_RPC_CALL_UTA_MS_SIM_SET_FDN_REQ = 0x10e,
    XMM7360_RPC_CALL_SET_AP_SCREEN_STATE = 0x110,
    XMM7360_RPC_CALL_UTA_IO_CTL = 0x111,
    XMM7360_RPC_CALL_UTA_IDC_AP_MSG_SET_REQ = 0x114,
    XMM7360_RPC_CALL_UTA_IDC_AP_MSG_GET_REQ = 0x115,
    XMM7360_RPC_CALL_UTA_IDC_ENBLE_REQ = 0x116,
    XMM7360_RPC_CALL_UTA_IDC_CWS_MSG_SET_REQ = 0x119,
    XMM7360_RPC_CALL_UTA_IDC_CWS_MSG_GET_REQ = 0x11a,
    XMM7360_RPC_CALL_UTA_IDC_SUBSCRIBE_INDICATIONS = 0x11c,
    XMM7360_RPC_CALL_UTA_IDC_UNSUBSCRIBE_INDICATIONS = 0x11d,
    XMM7360_RPC_CALL_UTA_BOOT_PREPARE_SHUTDOWN_REQ = 0x11f,
    XMM7360_RPC_CALL_UTA_BOOT_SHUTDOWN_REQ = 0x120,
    XMM7360_RPC_CALL_UTA_RF_MAX_TX_PWR_SET_2G = 0x121,
    XMM7360_RPC_CALL_UTA_RF_MAX_TX_PWR_SET_3G = 0x122,
    XMM7360_RPC_CALL_UTA_RF_MAX_TX_PWR_SET_4G = 0x123,
    XMM7360_RPC_CALL_UTA_FREQ_INFO_ACTIVATE_REQ = 0x128,
    XMM7360_RPC_CALL_UTA_FREQ_INFO_GET_FREQ_INFO_REQ = 0x129,
    XMM7360_RPC_CALL_UTA_FREQ_INFO_DEACTIVATE_REQ = 0x12a,
    XMM7360_RPC_CALL_UTA_FREQ_INFO_REGISTER_INDICATIONS = 0x12b,
    XMM7360_RPC_CALL_UTA_FREQ_INFO_DEREGISTER_INDICATIONS = 0x12c,
    XMM7360_RPC_CALL_UTA_MODE_SET_REQ = 0x12f,
    XMM7360_RPC_CALL_UTA_NVM_FLUSH_SYNC = 0x130,
    XMM7360_RPC_CALL_UTA_PROD_REGISTER_GTI_CALLBACK_FUNC = 0x132,
    XMM7360_RPC_CALL_UTA_PROD_GTI_CMD_REQ = 0x133,
    XMM7360_RPC_CALL_UTA_CELL_TIME_STAMP_REQ = 0x134,
    XMM7360_RPC_CALL_UTA_MS_SS_LCS_INIT = 0x136,
    XMM7360_RPC_CALL_UTA_MS_SS_LCS_MO_LOCATION_REQ = 0x137,
    XMM7360_RPC_CALL_UTA_MS_SS_LCS_MTLR_NOTIFICATION_RSP = 0x139,
    XMM7360_RPC_CALL_UTA_MS_CP_ASSISTANCE_DATA_INJECT_REQ = 0x13c,
    XMM7360_RPC_CALL_UTA_MS_CP_RESET_ASSISTANCE_DATA = 0x13d,
    XMM7360_RPC_CALL_UTA_MS_CP_POS_MEASUREMENT_REQ = 0x140,
    XMM7360_RPC_CALL_UTA_MS_CP_POS_MEASUREMENT_ABORT_REQ = 0x142,
    XMM7360_RPC_CALL_UTA_MS_CP_POS_ENABLE_MEASUREMENT_REPORT = 0x144,
    XMM7360_RPC_CALL_UTA_MS_CP_POS_DISABLE_MEASUREMENT_REPORT = 0x145,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_INIT = 0x146,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_EXEC_SMS_PP_RSP = 0x148,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_EXEC_SIM_INITIATED_CALL_RSP = 0x14a,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_EXEC_SS_USSD_RSP = 0x14c,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_EXEC_DTMF_RSP = 0x14e,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_STOP_DTMF_REQ = 0x150,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_REFRESH_CONFIRM_RSP = 0x152,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_REFRESH_FCN_RSP = 0x154,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_CONTROL_REQ = 0x155,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_TERMINAL_PROFILE_DOWNLOAD_REQ = 0x157,
    XMM7360_RPC_CALL_UTA_MS_3GPP2_SMS_SEND_REQ = 0x15a,
    XMM7360_RPC_CALL_UTA_MS_3GPP2_SMS_SUBSCRIBE_INDICATIONS = 0x15c,
    XMM7360_RPC_CALL_UTA_MS_3GPP2_SMS_UNSUBSCRIBE_INDICATIONS = 0x15d,
    XMM7360_RPC_CALL_RPC_GET_REMOTE_VER_INFO = 0x15e,
    XMM7360_RPC_CALL_UTA_MS_METRICS_REGISTER_HANDLER = 0x160,
    XMM7360_RPC_CALL_UTA_MS_METRICS_DEREGISTER_HANDLER = 0x161,
    XMM7360_RPC_CALL_UTA_MS_METRICS_SET_OPTIONS = 0x162,
    XMM7360_RPC_CALL_UTA_MS_METRICS_TRIGGER = 0x163,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_INIT = 0x164,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_SET_SERVICE_REQ = 0x165,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_MBSFN_AREA_CONFIG_REQ = 0x166,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_SESSION_CONFIG_REQ = 0x167,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_SET_INTERESTED_TMGI_LIST_REQ = 0x168,
    XMM7360_RPC_CALL_UTA_MS_EMBMS_SET_INTERESTED_SAI_FREQ_REQ = 0x169,
    XMM7360_RPC_CALL_UTA_IMS_SUBSCRIBE_INDICATIONS = 0x176,
    XMM7360_RPC_CALL_UTA_IMS_UNSUBSCRIBE_INDICATIONS = 0x177,
    XMM7360_RPC_CALL_UTA_IMS_GET_FRAMEWORK_STATE = 0x178,
    XMM7360_RPC_CALL_UTA_RTC_GET_DATETIME = 0x179,
    XMM7360_RPC_CALL_UTA_MS_SIM_ANALYSE_SIM_APDU_RESULT = 0x17a,
    XMM7360_RPC_CALL_UTA_MS_SIM_OPEN_CHANNEL_REQ = 0x17b,
    XMM7360_RPC_CALL_UTA_MS_SIM_CLOSE_CHANNEL_REQ = 0x17d,
    XMM7360_RPC_CALL_UTA_MS_SIM_SET_BDN_REQ = 0x17f,
    XMM7360_RPC_CALL_UTA_MS_SET_SIM_STACK_MAPPING_REQ = 0x181,
    XMM7360_RPC_CALL_UTA_MS_GET_SIM_STACK_MAPPING_REQ = 0x183,
    XMM7360_RPC_CALL_UTA_MS_NET_SET_RADIO_SIGNAL_REPORTING_CONFIGURATION = 0x188,
    XMM7360_RPC_CALL_UTA_PC_IE_ENUMERATIONEXT_TOUT = 0x189,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_SET_TERMINAL_CAPABILITY_REQ = 0x18a,
    XMM7360_RPC_CALL_UTA_MS_SIM_TK_READ_TERMINAL_CAPABILITY_REQ = 0x18c,
    XMM7360_RPC_CALL_CSI_FCC_LOCK_QUERY_REQ = 0x18e,
    XMM7360_RPC_CALL_CSI_FCC_LOCK_GEN_CHALLENGE_REQ = 0x190,
    XMM7360_RPC_CALL_CSI_FCC_LOCK_VER_CHALLENGE_REQ = 0x192,
    XMM7360_RPC_CALL_UTA_SENSOR_OPEN_REQ = 0x194,
    XMM7360_RPC_CALL_UTA_SENSOR_CLOSE_EXT = 0x197,
    XMM7360_RPC_CALL_UTA_SENSOR_START_EXT = 0x198,
    XMM7360_RPC_CALL_UTA_SENSOR_SET_ALARM_PARAM_EXT = 0x199,
    XMM7360_RPC_CALL_UTA_SENSOR_SET_SCHEDULER_PARAM_EXT = 0x19a,
    XMM7360_RPC_CALL_CSI_SIO_IP_FILTER_CNTRL_SET_REQ = 0x19b,
    XMM7360_RPC_CALL_UTA_MS_ACC_CURRENT_FREQ_INFO_REQ = 0x19d,
    XMM7360_RPC_CALL_CSI_TRC_AT_CMND_REQ = 0x1a0,
    XMM7360_RPC_CALL_UTA_MS_SIM_APDU_CMD_EXT_REQ = 0x1a2,
    XMM7360_RPC_CALL_UTA_MS_NET_GET_PLMN_NAME_INFO_REQ = 0x1a4,
    XMM7360_RPC_CALL_UTA_MS_NET_GET_COUNTRY_LIST_REQ = 0x1a7,
    XMM7360_RPC_CALL_UTA_MS_NET_EXT_CONFIGURE_NETWORK_MODE_REQ = 0x1a9,
    XMM7360_RPC_CALL_UTA_MS_NET_EXT_BAND_STATUS_REQ = 0x1ac,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_ATTACH_APN_CONFIG_REQ = 0x1af,
    XMM7360_RPC_CALL_CSI_MS_CALL_PS_INITIALIZE = 0x1b1,
    XMM7360_RPC_CALL_UTA_AUDIO_ENABLE_SOURCE = 0x1b2,
    XMM7360_RPC_CALL_UTA_AUDIO_DISABLE_SOURCE = 0x1b3,
    XMM7360_RPC_CALL_UTA_AUDIO_CONFIGURE_DESTINATION_EXT = 0x1b4,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_DESTINATIONS_FOR_SOURCE = 0x1b5,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_VOLUME_FOR_SOURCE = 0x1b6,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_MUTE_FOR_SOURCE_EXT = 0x1b7,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_VOLUME_FOR_DESTINATION = 0x1b8,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_MUTE_FOR_DESTINATION_EXT = 0x1b9,
    XMM7360_RPC_CALL_UTA_AUDIO_CONFIGURE_SOURCE_EXT = 0x1ba,
    XMM7360_RPC_CALL_UTA_AUDIO_SET_DESTINATIONS_FOR_SOURCE_EXT = 0x1bb,
    XMM7360_RPC_CALL_UTA_RPC_SCREEN_CONTROL_REQ = 0x1bc,
    XMM7360_RPC_CALL_UTA_MS_CALL_PS_READ_CONTEXT_STATUS_REQ = 0x1bd,
    XMM7360_RPC_CALL_CSI_MS_SIM_ACCESS_GET_SIM_STATE_INFO_REQ = 0x1bf,
    XMM7360_RPC_CALL_CSI_MS_NET_GET_REGISTRATION_INFO_REQ = 0x1c1,
    XMM7360_RPC_CALL_CSI_SIO_IP_FILTER_NEW_CNTRL_SET_REQ = 0x1c3,
    XMM7360_RPC_CALL_CSI_MS_NET_LDR_GET_APN_PLMN_PARAMETER_LIST_REQ = 0x1c5,
    XMM7360_RPC_CALL_RPC_GET_API_PARAM_CHANGED_BITMAP = 0x1c8,
} Xmm7360RpcCallId;

typedef enum {
    XMM7360_RPC_UNSOL_UTA_MS_SIM_APDU_CMD_RSP_CB = 0x003,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_APPLICATION_RSP_CB = 0x005,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_INFO_IND_CB = 0x007,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_INIT_IND_CB = 0x008,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_FULL_ACCESS_IND_CB = 0x009,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_ERROR_IND_CB = 0x00a,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_CARD_IND_CB = 0x00b,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_APPLICATION_IND_CB = 0x00c,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_READ_ENTRY_RSP_CB = 0x00e,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_GEN_PIN_RSP_CB = 0x010,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_MODIFY_LOCK_RSP_CB = 0x012,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_LOCK_STATUS_IND_CB = 0x013,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_MO_SMS_CONTROL_INFO_IND_CB = 0x014,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_PROACTIVE_COMMAND_IND_CB = 0x015,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_ENVELOPE_RES_IND_CB = 0x018,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_TERMINAL_PROFILE_READ_RSP_CB = 0x01a,
    XMM7360_RPC_UNSOL_UTA_SIM_TK_PROACTIVE_COMMAND_HANDLER_FUNC = 0x01b,
    XMM7360_RPC_UNSOL_UTA_MS_CPS_SET_MODE_RSP = 0x01e,
    XMM7360_RPC_UNSOL_UTA_MS_CPS_SET_MODE_IND_CB = 0x022,
    XMM7360_RPC_UNSOL_UTA_MS_SS_NETWORK_ERROR_IND_CB = 0x02a,
    XMM7360_RPC_UNSOL_UTA_MS_SS_NETWORK_REJECT_IND_CB = 0x02b,
    XMM7360_RPC_UNSOL_UTA_MS_SS_NETWORK_GSM_CAUSE_IND_CB = 0x02c,
    XMM7360_RPC_UNSOL_UTA_MS_SS_USSD_RSP_CB = 0x02d,
    XMM7360_RPC_UNSOL_UTA_MS_SS_USSD_IND_CB = 0x02e,
    XMM7360_RPC_UNSOL_UTA_MS_SS_END_IND_CB = 0x02f,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_INCOMING_IND_CB = 0x032,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_SEND_RSP_CB = 0x033,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_SET_MEMORY_AVAILABLE_RSP_CB = 0x035,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_SIM_MSG_CACHE_FINISHED_IND_CB = 0x037,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_SIM_MSG_COUNT_RSP_CB = 0x039,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_DEFINE_PRIMARY_RSP_CB = 0x03e,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_UNDEFINE_PRIMARY_RSP_CB = 0x040,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_PRIMARY_RSP_CB = 0x042,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_SET_AUTHENTICATION_RSP_CB = 0x044,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_SET_DNS_RSP_CB = 0x046,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_NEGOTIATED_DNS_RSP_CB = 0x048,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_NEG_IP_ADDR_RSP_CB = 0x04a,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_ACTIVATE_RSP_CB = 0x04c,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_ACTIVATE_STATUS_IND_CB = 0x04d,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_DEACTIVATE_RSP_CB = 0x04f,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_DEACTIVATE_IND_CB = 0x050,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_CONNECT_RSP_CB = 0x052,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SINGLE_SHOT_RADIO_SIGNAL_REPORTING_RSP_CB = 0x056,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CELL_INFO_IND_CB = 0x057,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CONNECTION_INFO_IND_CB = 0x058,
    XMM7360_RPC_UNSOL_UTA_MS_NET_HSPA_INFO_IND_CB = 0x059,
    XMM7360_RPC_UNSOL_UTA_MS_NET_RADIO_SIGNAL_IND_CB = 0x05a,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CELL_CHANGE_IND_CB = 0x05b,
    XMM7360_RPC_UNSOL_UTA_MS_NET_ATTACH_RSP_CB = 0x063,
    XMM7360_RPC_UNSOL_UTA_MS_NET_PS_ATTACH_RSP_CB = 0x064,
    XMM7360_RPC_UNSOL_UTA_MS_NET_PS_DETACH_RSP_CB = 0x065,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SCAN_RSP_CB = 0x066,
    XMM7360_RPC_UNSOL_UTA_MS_NET_POWER_DOWN_RSP_CB = 0x067,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EXT_SCAN_RSP_CB = 0x068,
    XMM7360_RPC_UNSOL_UTA_MS_NET_PS_ATTACH_IND_CB = 0x069,
    XMM7360_RPC_UNSOL_UTA_MS_NET_PS_DETACH_IND_CB = 0x06a,
    XMM7360_RPC_UNSOL_UTA_MS_NET_REGISTRATION_INFO_IND_CB = 0x06b,
    XMM7360_RPC_UNSOL_UTA_MS_NET_IS_ATTACH_ALLOWED_IND_CB = 0x06c,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GPRS_CLASS_IND_CB = 0x06d,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SET_FD_CONFIG_RSP_CB = 0x06f,
    XMM7360_RPC_UNSOL_UTA_MS_NET_FD_CONFIG_IND_CB = 0x070,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GET_FD_CONFIG_RSP_CB = 0x072,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CONFIGURE_NETWORK_MODE_RSP_CB = 0x074,
    XMM7360_RPC_UNSOL_UTA_MS_NET_NETWORK_MODE_CHANGE_IND_CB = 0x075,
    XMM7360_RPC_UNSOL_UTA_MS_NET_RAT_MODE_STATUS_RSP_CB = 0x077,
    XMM7360_RPC_UNSOL_UTA_MS_NET_RAT_MODE_STATUS_IND_CB = 0x078,
    XMM7360_RPC_UNSOL_UTA_MS_NET_DC_SET_VOICE_DOMAIN_PREFERENCE_CONFIG_RSP_CB = 0x081,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_SETUP_CALL_RSP_CB = 0x083,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_DIALING_IND_CB = 0x084,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_ALERTING_IND_CB = 0x085,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_CTM_INFO_IND_CB = 0x086,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_CONNECTED_IND_CB = 0x087,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_RELEASE_CALL_RSP_CB = 0x089,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_DISCONNECTING_IND_CB = 0x08a,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_DISCONNECTED_IND_CB = 0x08b,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_INCOMING_CALL_IND_CB = 0x08c,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_ACCEPT_CALL_RSP_CB = 0x08e,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_PROGRESS_IND_CB = 0x08f,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_SWAP_CALLS_RSP_CB = 0x091,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_HOLD_CALL_RSP_CB = 0x093,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_RETRIEVE_CALL_RSP_CB = 0x095,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_SPLIT_MPTY_RSP_CB = 0x097,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_JOIN_CALLS_RSP_CB = 0x099,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_TRANSFER_CALLS_RSP_CB = 0x09b,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_START_DTMF_RSP_CB = 0x09d,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_STOP_DTMF_RSP_CB = 0x09f,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_STOP_DTMF_EXT_RSP_CB = 0x0a0,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_NOTIFICATION_IND_CB = 0x0a1,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_CUG_INFO_IND_CB = 0x0a2,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_CALLING_NAME_INFO_IND_CB = 0x0a3,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_EMERGENCY_NUMBER_LIST_IND_CB = 0x0a4,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_CALL_STATUS_IND_CB = 0x0a5,
    XMM7360_RPC_UNSOL_UTA_CALL_MULTIMEDIA_GET_MEDIA_PROFILES_INFO_RSP_CB = 0x0a9,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_MULTIMEDIA_SETUP_CALL_RSP_CB = 0x0aa,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_MULTIMEDIA_UPDATE_CALL_RSP_CB = 0x0ab,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_CS_VOIMS_SRVCC_HO_STATUS_IND_CB = 0x0ae,
    XMM7360_RPC_UNSOL_UTA_MS_CPS_SET_SIM_MODE_RSP = 0x0af,
    XMM7360_RPC_UNSOL_UTA_MS_CPS_STARTUP_IND_CB = 0x0b1,
    XMM7360_RPC_UNSOL_UTA_MS_SS_CALL_FORWARD_RSP_CB = 0x0b3,
    XMM7360_RPC_UNSOL_UTA_MS_SS_CALL_WAITING_RSP_CB = 0x0b5,
    XMM7360_RPC_UNSOL_UTA_MS_SS_CALL_BARRING_RSP_CB = 0x0b7,
    XMM7360_RPC_UNSOL_UTA_MS_SS_IDENTIFICATION_RSP_CB = 0x0b9,
    XMM7360_RPC_UNSOL_UTA_MS_SMS_DATA_DOWNLOAD_RSP_CB = 0x0bc,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_NEG_QOS_RSP_CB = 0x0bf,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_TFT_RSP_CB = 0x0c1,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_SET_PCO_RSP_CB = 0x0c3,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_GET_NW_PCO_RSP_CB = 0x0c5,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_NW_ACTIVATE_IND_CB = 0x0c6,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_NW_ACTIVATE_ACCEPT_RSP_CB = 0x0c8,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_MODIFY_IND_CB = 0x0ca,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_SUSPEND_IND_CB = 0x0cb,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_RESUME_IND_CB = 0x0cc,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_SET_DATA_PREF_RSP_CB = 0x0ce,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_START_RSP_CB = 0x0d1,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_STOP_RSP_CB = 0x0d2,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_NEW_MESSAGE_IND_CB = 0x0d5,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_ETWS_CONFIG_RSP_CB = 0x0d7,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_ETWS_START_RSP_CB = 0x0d9,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_ETWS_STOP_RSP_CB = 0x0db,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_ETWS_NOTIFY_PRIMARY_WARNING_IND = 0x0dc,
    XMM7360_RPC_UNSOL_UTA_MS_CBS_ETWS_NOTIFY_SECONDARY_WARNING_IND = 0x0dd,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CONFIGURE_RX_DIVERSITY_DARP_IND_CB = 0x0e1,
    XMM7360_RPC_UNSOL_UTA_MS_NET_TIME_INFO_READ_RSP_CB = 0x0e4,
    XMM7360_RPC_UNSOL_UTA_MS_NET_TIME_INFO_IND_CB = 0x0e5,
    XMM7360_RPC_UNSOL_UTA_MS_NET_BAND_STATUS_RSP_CB = 0x0e8,
    XMM7360_RPC_UNSOL_UTA_MS_NET_BAND_STATUS_IND_CB = 0x0e9,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SET_CSG_CONFIG_RSP_CB = 0x0ea,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GET_CSG_CONFIG_RSP_CB = 0x0eb,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GET_EXTENDED_RADIO_SIGNAL_INFO_RSP_CB = 0x0ed,
    XMM7360_RPC_UNSOL_UTA_MS_NET_NITZ_INFO_IND_CB = 0x0ee,
    XMM7360_RPC_UNSOL_UTA_MS_NET_DETACH_RSP_CB = 0x0f0,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SELECT_GPRS_CLASS_RSP_CB = 0x0f2,
    XMM7360_RPC_UNSOL_UTA_MS_NET_NETWORK_FEATURE_SUPPORT_INFO_IND_CB = 0x0f5,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EPS_NETWORK_FEATURE_SUPPORT_INFO_IND_CB = 0x0f6,
    XMM7360_RPC_UNSOL_UTA_MS_NET_CS_SERVICE_NOTIFICATION_IND_CB = 0x0f7,
    XMM7360_RPC_UNSOL_UTA_MS_NET_DUAL_SIM_SERVICE_IND_CB = 0x0f8,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SINGLE_SHOT_FD_RSP_CB = 0x0fa,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_GET_LOCATION_RSP_CB = 0x0fc,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_READ_GAS_ENTRY_RSP_CB = 0x0fe,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_WRITE_ENTRY_RSP_CB = 0x100,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_GET_META_INFORMATION_RSP_CB = 0x102,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_USIM_PB_SELECT_RSP_CB = 0x104,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_GET_FREE_RECORDS_RSP_CB = 0x106,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_USIM_PB_READY_IND_CB = 0x107,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_CACHE_LOAD_FINISHED_IND_CB = 0x108,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_PB_CACHE_LOAD_IND_CB = 0x109,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_GEN_PIN_IND_CB = 0x10d,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_FDN_STATE_IND_CB = 0x10f,
    XMM7360_RPC_UNSOL_UTA_IDC_AP_MSG_SET_RSP_CB = 0x112,
    XMM7360_RPC_UNSOL_UTA_IDC_AP_MSG_GET_RSP_CB = 0x113,
    XMM7360_RPC_UNSOL_UTA_IDC_CWS_MSG_SET_RSP_CB = 0x117,
    XMM7360_RPC_UNSOL_UTA_IDC_CWS_MSG_GET_RSP_CB = 0x118,
    XMM7360_RPC_UNSOL_UTA_IDC_CWS_MSG_IND_CB = 0x11b,
    XMM7360_RPC_UNSOL_UTA_BOOT_PREPARE_SHUTDOWN_RSP_CB = 0x11e,
    XMM7360_RPC_UNSOL_UTA_FREQ_INFO_ACTIVATE_RSP_CB = 0x124,
    XMM7360_RPC_UNSOL_UTA_FREQ_INFO_DEACTIVATE_RSP_CB = 0x125,
    XMM7360_RPC_UNSOL_UTA_FREQ_INFO_GET_FREQ_INFO_RSP_CB = 0x126,
    XMM7360_RPC_UNSOL_UTA_FREQ_INFO_INDICATION_CB = 0x127,
    XMM7360_RPC_UNSOL_UTA_MODE_SET_RSP_CB = 0x12d,
    XMM7360_RPC_UNSOL_UTA_MODE_STARTUP_IND_CB = 0x12e,
    XMM7360_RPC_UNSOL_UTA_PROD_GTI_CMD_RSP_CB = 0x131,
    XMM7360_RPC_UNSOL_UTA_CELL_TIME_STAMP_RSP_CB = 0x135,
    XMM7360_RPC_UNSOL_UTA_MS_SS_LCS_MO_LOCATION_RSP_CB = 0x138,
    XMM7360_RPC_UNSOL_UTA_MS_SS_LCS_CAPABILITIES_IND_CB = 0x13a,
    XMM7360_RPC_UNSOL_UTA_MS_CP_ASSISTANCE_DATA_INJECT_RSP_CB = 0x13b,
    XMM7360_RPC_UNSOL_UTA_MS_CP_ASSISTANCE_DATA_NEEDED_IND_CB = 0x13e,
    XMM7360_RPC_UNSOL_UTA_MS_CP_POS_MEASUREMENT_RSP_CB = 0x13f,
    XMM7360_RPC_UNSOL_UTA_MS_CP_POS_MEASUREMENT_ABORT_RSP_CB = 0x141,
    XMM7360_RPC_UNSOL_UTA_MS_CP_POS_REPORT_MEASUREMENT_IND_CB = 0x143,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_EXEC_SMS_PP_IND_CB = 0x147,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_EXEC_SIM_INITIATED_CALL_IND_CB = 0x149,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_EXEC_SS_USSD_IND_CB = 0x14b,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_EXEC_DTMF_IND_CB = 0x14d,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_EXEC_DTMF_END_IND_CB = 0x14f,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_REFRESH_CONFIRM_IND_CB = 0x151,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_REFRESH_FCN_IND_CB = 0x153,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_CONTROL_RSP_CB = 0x156,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_TERMINAL_PROFILE_DOWNLOAD_RSP_CB = 0x158,
    XMM7360_RPC_UNSOL_UTA_MS_3GPP2_SMS_SEND_RSP_CB = 0x159,
    XMM7360_RPC_UNSOL_UTA_MS_3GPP2_SMS_INCOMING_IND_CB = 0x15b,
    XMM7360_RPC_UNSOL_UTA_METRICS_HANDLER_FUNCTION = 0x15f,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SET_SERVICE_RSP_CB = 0x16a,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_MBSFN_AREA_CONFIG_RSP_CB = 0x16b,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SESSION_CONFIG_RSP_CB = 0x16c,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SET_INTERESTED_TMGI_LIST_RSP_CB = 0x16d,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SET_INTERESTED_SAI_FREQ_RSP_CB = 0x16e,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SERVICE_IND_CB = 0x16f,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_MBSFN_AREA_IND_CB = 0x170,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SERVICES_LIST_IND_CB = 0x171,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_SAI_LIST_IND_CB = 0x172,
    XMM7360_RPC_UNSOL_UTA_MS_EMBMS_MPS_INFO_IND_CB = 0x173,
    XMM7360_RPC_UNSOL_UTA_IMS_STATE_CHANGED_IND_CB = 0x174,
    XMM7360_RPC_UNSOL_UTA_IMS_SERVICE_STATE_CHANGED_IND_CB = 0x175,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_OPEN_CHANNEL_RSP_CB = 0x17c,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_CLOSE_CHANNEL_RSP_CB = 0x17e,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_BDN_STATE_IND_CB = 0x180,
    XMM7360_RPC_UNSOL_UTA_MS_SET_SIM_STACK_MAPPING_RSP_CB = 0x182,
    XMM7360_RPC_UNSOL_UTA_MS_GET_SIM_STACK_MAPPING_RSP_CB = 0x184,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_MCC_MNC_IND_CB = 0x185,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_TERMINAL_RESPONSE_IND_CB = 0x186,
    XMM7360_RPC_UNSOL_UTA_MS_NET_REGISTERED_PLMN_NAME_IND_CB = 0x187,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_SET_TERMINAL_CAPABILITY_RSP_CB = 0x18b,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_TK_READ_TERMINAL_CAPABILITY_RSP_CB = 0x18d,
    XMM7360_RPC_UNSOL_CSI_FCC_LOCK_QUERY_RSP_CB = 0x18f,
    XMM7360_RPC_UNSOL_CSI_FCC_LOCK_GEN_CHALLENGE_RSP_CB = 0x191,
    XMM7360_RPC_UNSOL_CSI_FCC_LOCK_VER_CHALLENGE_RSP_CB = 0x193,
    XMM7360_RPC_UNSOL_UTA_SENSOR_OPEN_RSP_CB = 0x195,
    XMM7360_RPC_UNSOL_UTA_SENSOR_MEAS_IND_CB = 0x196,
    XMM7360_RPC_UNSOL_CSI_SIO_IP_FILTER_CNTRL_SET_RSP_CB = 0x19c,
    XMM7360_RPC_UNSOL_CSI_SIO_IP_FILTER_NEW_CNTRL_SET_RSP_CB = 0x1c4,
    XMM7360_RPC_UNSOL_UTA_MS_ACC_CURRENT_FREQ_INFO_RSP_CB = 0x19e,
    XMM7360_RPC_UNSOL_UTA_MS_ACC_CURRENT_FREQ_INFO_IND_CB = 0x19f,
    XMM7360_RPC_UNSOL_CSI_TRC_AT_CMND_RSP_CB = 0x1a1,
    XMM7360_RPC_UNSOL_UTA_MS_SIM_APDU_CMD_EXT_RSP_CB = 0x1a3,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GET_PLMN_NAME_INFO_RSP_CB = 0x1a5,
    XMM7360_RPC_UNSOL_UTA_MS_NET_SIB8_TIME_INFO_IND_CB = 0x1a6,
    XMM7360_RPC_UNSOL_UTA_MS_NET_GET_COUNTRY_LIST_RSP_CB = 0x1a8,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EXT_CONFIGURE_NETWORK_MODE_RSP_CB = 0x1aa,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EXT_NETWORK_MODE_CHANGE_IND_CB = 0x1ab,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EXT_BAND_STATUS_RSP_CB = 0x1ad,
    XMM7360_RPC_UNSOL_UTA_MS_NET_EXT_BAND_STATUS_IND_CB = 0x1ae,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_ATTACH_APN_CONFIG_RSP_CB = 0x1b0,
    XMM7360_RPC_UNSOL_UTA_MS_CALL_PS_READ_CONTEXT_STATUS_RSP_CB = 0x1be,
    XMM7360_RPC_UNSOL_CSI_MS_SIM_ACCESS_GET_SIM_STATE_INFO_RSP_CB = 0x1c0,
    XMM7360_RPC_UNSOL_CSI_MS_NET_GET_REGISTRATION_INFO_RSP_CB = 0x1c2,
    XMM7360_RPC_UNSOL_CSI_MS_NET_LDR_GET_APN_PLMN_PARAMETER_LIST_RSP_CB = 0x1c6,
    XMM7360_RPC_UNSOL_UTA_MS_NET_LDR_APN_PARAMETERS_CHANGE_IND_CB = 0x1c7,
} Xmm7360RpcUnsolId;

typedef enum {
    XMM7360_RPC_MSG_ARG_TYPE_BYTE,
    XMM7360_RPC_MSG_ARG_TYPE_SHORT,
    XMM7360_RPC_MSG_ARG_TYPE_LONG,
    XMM7360_RPC_MSG_ARG_TYPE_STRING,
    XMM7360_RPC_MSG_ARG_TYPE_UNKNOWN,
} Xmm7360RpcMsgArgType;


#define XMM7360_RPC_MSG_ARG_GET_INT(arg)                              \
    (arg->type == XMM7360_RPC_MSG_ARG_TYPE_BYTE ? arg->value.b        \
     : arg->type == XMM7360_RPC_MSG_ARG_TYPE_SHORT ? arg->value.s     \
     : arg->type == XMM7360_RPC_MSG_ARG_TYPE_LONG ? arg->value.l : -1)

typedef struct {
    Xmm7360RpcMsgArgType type;
    union {
        gint8 b;
        gint16 s;
        gint32 l;
        const gchar *string;
    } value;
    gsize size;
    gsize pad;
} Xmm7360RpcMsgArg;

typedef enum {
    XMM7360_RPC_RESPONSE_TYPE_RESPONSE,
    XMM7360_RPC_RESPONSE_TYPE_ASYNC_ACK,
    XMM7360_RPC_RESPONSE_TYPE_UNSOLICITED,
    XMM7360_RPC_RESPONSE_TYPE_UNKNOWN,
} Xmm7360RpcResponseType;

typedef struct {
    guint32 id;
    Xmm7360RpcResponseType type;
    guint32 unsol_id;
    GByteArray *body;
    GPtrArray *content;  /* contains (Xmm7360RpcMsgArgs *) */
} Xmm7360RpcResponse;

#define MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360            (mm_port_serial_xmmrpc_xmm7360_get_type ())
#define MM_PORT_SERIAL_XMMRPC_XMM7360(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360, MMPortSerialXmmrpcXmm7360))
#define MM_PORT_SERIAL_XMMRPC_XMM7360_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360, MMPortSerialXmmrpcXmm7360Class))
#define MM_IS_PORT_SERIAL_XMMRPC_XMM7360(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360))
#define MM_IS_PORT_SERIAL_XMMRPC_XMM7360_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360))
#define MM_PORT_SERIAL_XMMRPC_XMM7360_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  MM_TYPE_PORT_SERIAL_XMMRPC_XMM7360, MMPortSerialXmmrpcXmm7360Class))

typedef struct _MMPortSerialXmmrpcXmm7360 MMPortSerialXmmrpcXmm7360;
typedef struct _MMPortSerialXmmrpcXmm7360Class MMPortSerialXmmrpcXmm7360Class;
typedef struct _MMPortSerialXmmrpcXmm7360Private MMPortSerialXmmrpcXmm7360Private;

typedef gboolean (*MMPortSerialXmmrpcXmm7360UnsolicitedMsgFn) (MMPortSerialXmmrpcXmm7360 *port,
                                                               Xmm7360RpcResponse *response,
                                                               gpointer user_data);

struct _MMPortSerialXmmrpcXmm7360 {
    MMPortSerial parent;
    MMPortSerialXmmrpcXmm7360Private *priv;
};

struct _MMPortSerialXmmrpcXmm7360Class {
    MMPortSerialClass parent;
};

GType mm_port_serial_xmmrpc_xmm7360_get_type (void);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MMPortSerialXmmrpcXmm7360, g_object_unref)

MMPortSerialXmmrpcXmm7360 *mm_port_serial_xmmrpc_xmm7360_new (const char *name);

void mm_port_serial_xmmrpc_xmm7360_command (MMPortSerialXmmrpcXmm7360 *self,
                                            Xmm7360RpcCallId callid,
                                            gboolean is_async,
                                            GByteArray *body,
                                            guint32 timeout_seconds,
                                            gboolean allow_cached,
                                            GCancellable *cancellable,
                                            GAsyncReadyCallback callback,
                                            gpointer user_data);

void xmm7360_byte_array_append_asn_int4 (GByteArray *array, gint32 value);

void xmm7360_rpc_response_free (Xmm7360RpcResponse *msg);

G_DEFINE_AUTOPTR_CLEANUP_FUNC (Xmm7360RpcResponse, xmm7360_rpc_response_free);

GByteArray *xmm7360_rpc_args_to_byte_array (const Xmm7360RpcMsgArg *args);

Xmm7360RpcResponse *mm_port_serial_xmmrpc_xmm7360_command_finish (MMPortSerialXmmrpcXmm7360  *self,
                                                                  GAsyncResult               *res,
                                                                  GError                    **error);

guint mm_port_serial_xmmrpc_xmm7360_add_unsolicited_msg_handler (MMPortSerialXmmrpcXmm7360 *self,
                                                                   MMPortSerialXmmrpcXmm7360UnsolicitedMsgFn callback,
                                                                   gpointer user_data,
                                                                   GDestroyNotify notify);

void mm_port_serial_xmmrpc_xmm7360_enable_unsolicited_msg_handler (MMPortSerialXmmrpcXmm7360 *self,
                                                                   guint handler_id,
                                                                   gboolean enable);

#endif /* MM_PORT_SERIAL_XMMRPC_XMM7360_H */
