# Star Control II — Walkthrough

*Crystal Dynamics / Fred Ford & Paul Kiche III*

A space strategy shooter. In 2112, the Ur-Quan enslaved Earth. The
galaxy is home to dozens of worlds with exotic names. Your goal is to
prepare for the final battle against the Ur-Quan stronghold — the
Sa-Matra base in the Crater constellation. The game uses a detailed star
map (about five hundred stars).

---

## Map notation

Star names are built from the constellation name, a Greek letter, and a
number. The game uses Latin names for the Greek letters:

| Letter      | Latin   |
|-------------|---------|
| α (alpha)   | Alpha   |
| β (beta)    | Beta    |
| γ (gamma)   | Gamma   |
| δ (delta)   | Delta   |
| ε (epsilon) | Epsilon |
| η (eta)     | Eta     |
| ζ (zeta)    | Zeta    |

**Important:** Do not let Pkunk ships get close to Yehat — Yehat will
destroy them. Protect Zoq-Fot-Pik from the warlike Ur-Quan. Ur-Quan is
the collective name for Kohr-Ah (black ships, exterminate everything)
and Kzer-Za (green ships, enslave everything).

---

## Homeworlds (coordinates X; Y)

Coordinates are given for the star on the hyperspace map.

| World / race               | System           | Coordinates          |
|----------------------------|------------------|----------------------|
| Vela, your homeworld       | —                | (334.5; 193.1) [04]  |
| Solar,  Earth              | —                | (175.2; 145.0) [01]  |
| Chenjesu & Mmrnmhrm (Chmmr)| Procyon II       | (74.2; 226.8) [11]   |
| Druuge (trading world)     | ζ Persei I       | (946.9; 280.6) [15]  |
| Ilwrath                    | α Tauri I        | (22.9; 366.6) [2B]   |
| Mycon                      | α Scorpii I      | (629.1; 220.8) [IF]  |
| Orz                        | γ Vulpeculae     | (371.3; 253.7) [28]  |
| Pkunk                      | γ Krueger I      | (52.2; 52.5) [23]    |
| Shofixti                   | δ Gorno          | (290.8; 26.9) [02]   |
| Slylandro                  | β Corvi IV       | (33.3; 981.2) [14]   |
| Spathi                     | ε Gruis I-a      | (241.6; 368.7) [05]  |
| Supox                      | β Librae I       | (741.4; 912.4) [25]  |
| Syreen                     | Betelgeuse I     | (412.5; 377.0) [12]  |
| Thraddash                  | δ Draconis I     | (253.5; 835.8) [29]  |
| Umgah                      | β Orionis I      | (197.8; 596.8) [10]  |
| Utwig                      | β Aquarii I      | (863.0; 869.3) [24]  |
| VUX                        | β Luyten I       | (433.3; 168.7) [27]  |
| Yehat                      | γ Serpentis I    | (492.3; 29.4) [26]   |
| Zoq-Fot-Pik                | α Tucanae I      | (400.0; 543.7) [06]  |

Without money you cannot buy fuel. Earn by destroying ships or mining
and selling minerals on Earth. Melnorme trade information and fuel; they
are found near supergiant stars — use them as refuelling stops.

---

## Space traders (Melnorme)

| Star             | Coordinates          |
|------------------|----------------------|
| α Apodis         | (258.2; 850.7) [0E]  |
| α Aquilae        | (915.9; 974.5) [0F]  |
| α Centauri       | (155.9; 99.3) [08]   |
| α Eridani        | (587.5; 772.9) [0D]  |
| α Illuminati     | (235.4; 329.1) [0B]  |
| α Octantis       | (157.8; 666.8) [0C]  |
| α Vulpeculae     | (365.4; 258.7) [0A]  |
| β Arae           | (933.3; 93.7) [07]   |
| Zeeman           | (335.2; 194.0) [09]  |

---

## Required tasks

To destroy Sa-Matra you must complete several required steps.

### Rebuilding the Ultron

You need to gather the components:

- **Crystal Spindle** — with the Pkunk on their homeworld. Visit them —
  they will give it.
- **Aqua Helix** — at ζ Draconis I, with the Thraddash. To get them to
  give the helix, earn their respect: destroy about twenty of their
  ships. Do not steal the helix — that will enrage the Thraddash.
- **Rosy Sphere** — with the Druuge on their trading planet. Price: 100
  crew (or a crate of Mycon eggs; look near β Brahe I).
- **Ultron** — assemble it with the Supox on β Librae. Put all parts
  into the Ultron via the "use" option. Deliver the Ultron to the Utwig
  world — they will give you the bomb for Sa-Matra. The bomb is on the
  second moon — **ζ Hyades VI-B**. Coordinates: (850.0; 937.2) [16].
  Five Druuge ships are there; easy to destroy with Hellbore and ATS or
  nukes from the Earthling Cruiser. After that, Utwig and Supox will
  attack Kohr-Ah and you gain time (between months 9 and 12).

### Tasks in Syreen space

- Ensure Syra is destroyed by the Mycon on the way to the former Syreen
  world (β Copernicus I).
- Retrieve Syreen ships from storage at ε Camelopardalis I-a.
- Go to the Mycon — let them take "Deep Child" from the new planet. On
  the way to β Brahe I you will lose most of your fleet; then a battle
  with five Mycon ships.
- From the planet surface take the Sun Device. To tell the Syreen about
  Syra — buy the information from the Melnorme or visit the destroyed
  world and ask the Mycon about Brahe.

### Tasks in Shofixti space


- At δ Gorno they will mistake you for Ur-Quan and the Shofixti will
  attack. Do not kill them — explain who you are.
- Restore the population: find Shofixti females with Admiral Zex at α
  Cerenkov I. In exchange he wants an aggressive creature from δ Lyncis
  I. Once you deliver the creature, the admiral will try to capture you,
  but the creature will break free and kill him — you get the females.
  Give them to Tanaka; in two months you receive a Shofixti ship and a
  discount on crew.
- Civil war among the Shofixti is unavoidable; later the Yehat will
  provide the ships you need.

### Tasks in Umgah space

- Get the Talking Pet. The "Taalo Physic" shield at δ Vulpeculae II-c
  protects against its tricks; do not be rude to the Orz. The Pet will
  try to send you against an Ur-Quan armada; after attacking ten Umgah
  commanders it will surrender. Return to the planet — the Umgah will
  give information about the Mycon, 500 units (sell to Melnorme), and
  four ships. Leave quickly: they are preparing an attack.

### Tasks in Chmmr space

- Chenjesu and Mmrnmhrm merge into Chmmr. Use the Sun Device to speed the fusion. Chmmr will provide unlimited resources, build an excellent ship, and improve the bomb.

### Assault on Sa-Matra

- Chmmr will take you to Earth; in two weeks the bomb will be on your
  flagship. Fill six slots (recommended: one fuel system, five crew).
  Buy ten Avatars from Chmmr, keep two Pkunk ships. The Utwig Jugger is
  nearly invulnerable to Ur-Quan and Kohr-Ah.
- Use the Portal Spawner to jump to the Crater constellation, fly to δ
  Crateris V. The Talking Pet will distract the orbital fleet. Save the
  game. Three Kzer-Za and three Kohr-Ah will attack Sa-Matra — deploy
  Chmmr Avatars; losses will be replaced by Yehat Terminators and Pkunk
  Furies. The Pet will describe Sa-Matra's configuration. Pkunk are
  effective against shield generators; then target the green spots and
  fireballs. Destroy them — board the flagship, victory.

---

## Optional tasks

### Spathi

Clear the Spathi world of biological forms, tell them about your trip to
their moon, force them to send ships to Earth. They will leave the Umgah
Mind Caster on the moon — needed to call the Melnorme, contact
Chenjesu/Mmrnmhrm, and deceive the Ilwrath (Dogar and Kazon).
Alternative: Burvixese Caster at Arcturus I-a (if you have the Portal
Spawner).

### Arilou

On the blue planet at α Pavonis — a Ur-Quan dreadnought. Deal with the
wreck and recover the device. Visit the Arilou world in the far upper
corner of QuasiSpace. If you have the Ur-Quan device, they will give you
the Portal Spawner (saves time and fuel).

### Zoq-Fot-Pik

They join you immediately and provide information about Sa-Matra and the
Ur-Quan vs Kohr-Ah war.

### Slylandro — rainbow worlds

Ten worlds toward the galactic core:

| System           | Coordinates      |
|------------------|------------------|
| β Pegasi I       | (39.5; 745.8)    |
| ε Draconis I     | (283.6; 785.7)   |
| ε Ursae I        | (543.7; 827.0)   |
| β Leporis 1      | (766.6; 866.6)   |
| γ Aquarii I      | (853.4; 879.7)   |
| Groombridge I    | (996.0; 904.2)   |
| α Andromedae I   | (862.5; 700.0)   |
| γ Reticuli I     | (741.6; 508.3)   |
| γ Kepler I       | (602.0; 297.9)   |
| ζ Sextantis I    | (468.1; 91.6)    |

Slylandro will give the code sequence for the probes and information
about the Precursors.

### Ilwrath

When entering their system use the Caster to confuse the Ilwrath. First
take the Aqua Helix from the Thraddash, then direct the Ilwrath against
the Thraddash.

---

## Notable star coordinates

| Star / system       | Coordinates           | Purpose              |
|---------------------|-----------------------|----------------------|
| δ Crateris (Crater) | (620.0; 593.5) [ID]   | Sa-Matra Ur-Quan     |
| α Pavonis           | (56.2; 800.0) [1B]    | Ur-Quan ship         |
| α Cerenkov          | (422.1; 198.6) [03]   | Zex, Shofixti females|
| δ Lyncis            | (570.4; 979.5) [1C]   | creature for Zex     |
| Organon             | (685.8; 57.7) [2D]    | Mycon's end          |
| β Brahe             | (639.5; 231.2) [18]   | Mycon Sun Device     |
| γ Scorpii           | (647.9; 206.2) [21]   | Mycon eggs           |
| β Copernicus        | (600.8; 263.1) [20]   | Mycon eggs           |
| γ Brahe             | (635.4; 272.9) [22]   | Mycon eggs           |
| Rigel               | (210.4; 208.3) [1E]   | meet Zoq-Fot-Pik     |
| η Vulpeculae        | (358.7; 256.6) [2C]   | —                    |
| δ Vulpeculae II-c   | (372.1; 261.9) [19]   | Taalo device         |
| ε Camelopardalis    | (593.7; 393.7) [1A]   | Syreen ship (locked) |
| Arcturus I-A        | (964.5; 579.1) [13]   | Burvix Caster        |
| ζ Draconis          | (277.6; 867.3) [17]   | Aqua Helix           |
| **ζ Hyades VI-B**   | **(850.0; 937.2) [16]** | **Utwig bomb**    |

---

## Suggested play order

1. Start in the Solar system (Sol). Mercury or Jupiter-B — radioactive
   elements.
2. Pluto — meet the Spathi, recruit them.
3. Earth — fuel, then ε Gruis — convince the Spathi to rejoin, wait for
   the red shield.
4. Spathiwa — Umgah Caster.
5. β Copernicus I — Mycon eggs. Talk to the Mycon about "Deep Child".
6. ε Scorpii → Betelgeuse — talk to the Syreen about ships.
7. ε Camelopardalis I-a (Ur-Quan world) — investigate the door; they
   send you to Betelgeuse. Talana will direct you to the Mycon
   (Organon).
8. β Brahe — Sun Device.
9. γ Krueger I — Spindle.
10. δ Draconis — convince the Thraddash not to attack Kohr-Ah.
11. ζ Draconis I — Aqua Helix.
12. ζ Persei I — trade with the Druuge for the Rosy Sphere (or a crate
    of Mycon eggs).
13. β Librae (Supox) — broken Ultron. Assemble Spindle, Helix, and Rosy
    Sphere into the Ultron.
14. β Aquarii I (Utwig) — deliver the Ultron.
15. ζ Hyades VI-b — pick up the bomb (destroy the Druuge).
16. α Tauri (Ilwrath) — use the Umgah Caster: let the Ilwrath attack the
    Thraddash.
17. η Vulpeculae II (Orz) — alliance.
18. δ Vulpeculae II-c — Taalo device; α Pavonis VII — Ur-Quan wreck.
19. Quasi-Portal (43.8; 637.2) — wait at the QuasiSpace entrance (bright
    point on the map; green opening in hyperspace). The portal appears
    on the 17th of each month.
20. Outer star — Ariloulaleelay, Portal Spawner, information about the
    Talking Pet.
21. β Orionis (Umgah) — Talking Pet; return later for the reward.
22. Procyon II — Sun Device. Chmmr will explain the finale and give
    unlimited resources.
23. Earth — buy ships, prepare for the final battle.
24. δ Crateris V — Talking Pet to distract the fleet. Save the game.
    Attack Sa-Matra.

---

*This document is included in the uqm-russian package for players'
convenience. It was generated by artificial intelligence based on
information found on the internet and the game's source texts.*
